/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.recognition;

import com.sun.speech.engine.SpeechEventDispatcher;
import com.sun.speech.engine.SpeechEventUtilities;
import com.sun.speech.engine.recognition.BaseRecognizer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.speech.SpeechEvent;
import javax.speech.recognition.Grammar;
import javax.speech.recognition.GrammarEvent;
import javax.speech.recognition.GrammarListener;
import javax.speech.recognition.Recognizer;
import javax.speech.recognition.Result;
import javax.speech.recognition.ResultEvent;
import javax.speech.recognition.ResultListener;

public class BaseGrammar
implements Grammar,
Serializable,
SpeechEventDispatcher {
    public transient BaseRecognizer recognizer;
    protected final transient List<GrammarListener> grammarListeners = new ArrayList<GrammarListener>();
    protected final transient List<ResultListener> resultListeners = new ArrayList<ResultListener>();
    protected String myName;
    protected boolean grammarActive;
    protected boolean grammarEnabled;
    protected boolean grammarChanged;
    protected int activationMode;

    public BaseGrammar(BaseRecognizer rec, String name) {
        this.recognizer = rec;
        this.myName = name;
        this.grammarActive = false;
        this.grammarEnabled = true;
        this.grammarChanged = true;
        this.activationMode = 900;
    }

    @Override
    public Recognizer getRecognizer() {
        return this.recognizer;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.grammarEnabled) {
            this.grammarEnabled = enabled;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.grammarEnabled;
    }

    @Override
    public void setActivationMode(int mode) throws IllegalArgumentException {
        if (mode != 902 && mode != 901 && mode != 900) {
            throw new IllegalArgumentException("Invalid ActivationMode");
        }
        if (mode != this.activationMode) {
            this.activationMode = mode;
        }
    }

    @Override
    public int getActivationMode() {
        return this.activationMode;
    }

    @Override
    public boolean isActive() {
        return this.recognizer.isActive(this);
    }

    @Override
    public void addGrammarListener(GrammarListener listener) {
        if (!this.grammarListeners.contains(listener)) {
            this.grammarListeners.add(listener);
        }
    }

    @Override
    public void removeGrammarListener(GrammarListener listener) {
        this.grammarListeners.remove(listener);
    }

    @Override
    public void addResultListener(ResultListener listener) {
        if (!this.resultListeners.contains(listener)) {
            this.resultListeners.add(listener);
        }
    }

    @Override
    public void removeResultListener(ResultListener listener) {
        this.resultListeners.remove(listener);
    }

    public void postGrammarActivated() {
        SpeechEventUtilities.postSpeechEvent(this, new GrammarEvent(this, 201));
    }

    protected void fireGrammarActivated(GrammarEvent event) {
        for (GrammarListener gl : this.grammarListeners) {
            gl.grammarActivated(event);
        }
    }

    public void postGrammarChangesCommitted() {
        SpeechEventUtilities.postSpeechEvent(this, new GrammarEvent(this, 200));
    }

    protected void fireGrammarChangesCommitted(GrammarEvent event) {
        for (GrammarListener gl : this.grammarListeners) {
            gl.grammarChangesCommitted(event);
        }
    }

    public void postGrammarDeactivated() {
        SpeechEventUtilities.postSpeechEvent(this, new GrammarEvent(this, 202));
    }

    protected void fireGrammarDeactivated(GrammarEvent event) {
        for (GrammarListener gl : this.grammarListeners) {
            gl.grammarDeactivated(event);
        }
    }

    public void postAudioReleased(Result result) {
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(result, 806));
    }

    public void fireAudioReleased(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.audioReleased(event);
        }
    }

    public void postGrammarFinalized(Result result) {
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(result, 803));
    }

    public void fireGrammarFinalized(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.grammarFinalized(event);
        }
    }

    public void postResultAccepted(Result result) {
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(result, 804));
    }

    public void fireResultAccepted(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.resultAccepted(event);
        }
    }

    public void postResultCreated(Result result) {
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(result, 801));
    }

    public void fireResultCreated(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.resultCreated(event);
        }
    }

    public void postResultRejected(Result result) {
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(result, 805));
    }

    public void fireResultRejected(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.resultRejected(event);
        }
    }

    public void postResultUpdated(Result result) {
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(result, 802));
    }

    public void fireResultUpdated(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.resultUpdated(event);
        }
    }

    public void postTrainingInfoReleased(Result result) {
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(result, 807));
    }

    public void fireTrainingInfoReleased(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.trainingInfoReleased(event);
        }
    }

    public void setName(String name) {
        this.myName = name;
    }

    @Override
    public void dispatchSpeechEvent(SpeechEvent event) {
        switch (event.getId()) {
            case 201: {
                this.fireGrammarActivated((GrammarEvent)event);
                break;
            }
            case 200: {
                this.fireGrammarChangesCommitted((GrammarEvent)event);
                break;
            }
            case 202: {
                this.fireGrammarDeactivated((GrammarEvent)event);
                break;
            }
            case 806: {
                this.fireAudioReleased((ResultEvent)event);
                break;
            }
            case 803: {
                this.fireGrammarFinalized((ResultEvent)event);
                break;
            }
            case 804: {
                this.fireResultAccepted((ResultEvent)event);
                break;
            }
            case 801: {
                this.fireResultCreated((ResultEvent)event);
                break;
            }
            case 805: {
                this.fireResultRejected((ResultEvent)event);
                break;
            }
            case 802: {
                this.fireResultUpdated((ResultEvent)event);
                break;
            }
            case 807: {
                this.fireTrainingInfoReleased((ResultEvent)event);
            }
        }
    }
}

