/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine;

import com.sun.speech.engine.SpeechEventDispatcher;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.security.AccessControlException;
import javax.speech.SpeechEvent;

public class SpeechEventUtilities {
    protected static boolean awtRunning;
    protected static EventQueue systemEventQueue;
    protected static SpeechAWTEventTarget speechAWTEventTarget;
    public static boolean waitUntilDispatched;

    protected static boolean isAWTRunning() {
        if (awtRunning) {
            return true;
        }
        try {
            ThreadGroup g;
            ThreadGroup rootGroup = g = Thread.currentThread().getThreadGroup();
            for (ThreadGroup parent = rootGroup.getParent(); parent != null; parent = parent.getParent()) {
                rootGroup = parent;
            }
            int activeCount = rootGroup.activeCount();
            Thread[] threads = new Thread[activeCount];
            rootGroup.enumerate(threads, true);
            for (Thread thread : threads) {
                String name;
                if (thread == null || !(name = thread.getName()).startsWith("AWT-EventQueue")) continue;
                awtRunning = true;
                return true;
            }
        }
        catch (AccessControlException ace) {
            return true;
        }
        return false;
    }

    public static void postSpeechEvent(SpeechEventDispatcher dispatcher, SpeechEvent event) {
        SpeechEventUtilities.postSpeechEvent(dispatcher, event, waitUntilDispatched);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void postSpeechEvent(final SpeechEventDispatcher dispatcher, final SpeechEvent event, boolean waitUntilDispatched) {
        if (SpeechEventUtilities.isAWTRunning()) {
            if (speechAWTEventTarget == null) {
                speechAWTEventTarget = new SpeechAWTEventTarget();
                systemEventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            }
            if (waitUntilDispatched) {
                Object lock;
                Object object = lock = new Object();
                synchronized (object) {
                    systemEventQueue.postEvent(new SpeechAWTEvent(speechAWTEventTarget, dispatcher, event, lock));
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            systemEventQueue.postEvent(new SpeechAWTEvent(speechAWTEventTarget, dispatcher, event));
        } else {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    dispatcher.dispatchSpeechEvent(event);
                }
            };
            thread.start();
        }
    }

    protected static class SpeechAWTEvent
    extends AWTEvent {
        static final int EVENT_ID = 16829;
        SpeechEventDispatcher dispatcher;
        SpeechEvent event;
        Object lock;

        SpeechAWTEvent(SpeechAWTEventTarget target, SpeechEventDispatcher dispatcher, SpeechEvent event) {
            this(target, dispatcher, event, null);
        }

        SpeechAWTEvent(SpeechAWTEventTarget target, SpeechEventDispatcher dispatcher, SpeechEvent event, Object lock) {
            super(target, 16829);
            this.dispatcher = dispatcher;
            this.event = event;
            this.lock = lock;
        }
    }

    protected static class SpeechAWTEventTarget
    extends Component {
        SpeechAWTEventTarget() {
            this.enableEvents(16829L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processEvent(AWTEvent event) {
            if (event instanceof SpeechAWTEvent) {
                SpeechAWTEvent sae = (SpeechAWTEvent)event;
                sae.dispatcher.dispatchSpeechEvent(sae.event);
                if (sae.lock != null) {
                    Object object = sae.lock;
                    synchronized (object) {
                        sae.lock.notify();
                    }
                }
            }
        }
    }
}

