/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.gui.writer;

import edu.cmu.sphinx.tools.gui.ConfigProperties;
import edu.cmu.sphinx.tools.gui.writer.ConfigConverter;
import edu.cmu.sphinx.tools.gui.writer.GUIWriter;
import edu.cmu.sphinx.tools.gui.writer.GUIWriterException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class XMLConfigWriter
implements GUIWriter {
    private XMLConfigWriter() {
    }

    public static XMLConfigWriter getInstance() {
        return XMLWriterHolder.instance;
    }

    @Override
    public boolean writeOutput(ConfigProperties configProp, File fFile) throws GUIWriterException {
        if (fFile == null || fFile.getName().trim().isEmpty()) {
            throw new GUIWriterException("No output filename specified", 3);
        }
        try {
            ConfigConverter cc = ConfigConverter.getInstance();
            StringBuilder sb = cc.writeOutput(configProp);
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(fFile)));
            pw.print(sb);
            pw.flush();
            pw.close();
            return true;
        }
        catch (IOException e) {
            throw new GUIWriterException("IOException thrown during file write", 2);
        }
    }

    @Override
    public String getOutput(ConfigProperties configProp) throws GUIWriterException {
        ConfigConverter cc = ConfigConverter.getInstance();
        StringBuilder sb = cc.writeOutput(configProp);
        return sb.toString();
    }

    private static class XMLWriterHolder {
        private static final XMLConfigWriter instance = new XMLConfigWriter();

        private XMLWriterHolder() {
        }
    }
}

