/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.gui.writer;

import edu.cmu.sphinx.tools.gui.ConfigProperties;
import edu.cmu.sphinx.util.props.RawPropertyData;
import java.util.List;
import java.util.Map;

public class ConfigConverter {
    private static final String XML_HEADING = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
    private static final String XML_SUBHEAD = "\n<!--    Sphinx-4 Configuration file--> \n<!--  ******************************************************** -->\n\n";
    private static final String XML_ROOT = "<config>\n";
    private static final String XML_ROOT_CLOSE = "</config>\n";
    private static final String XML_GLOBAL = "\n<!--  *******************************************-->\n<!--  frequently tuned properties                -->\n<!-- ********************************************-->\n";
    private static final String XML_CONF = "\n<!--  ********************************************************-->\n<!--  component       configuration                           -->\n<!--  ********************************************************-->\n\n";
    private static final String XML_PROP = "\t <property name=\"";
    private static final String XML_COMPONENT = "<component name=\"";
    private static final String XML_COMPONENT_CLOSE = "</component>\n\n";
    private static final String XML_TYPE = " type=\"";
    private static final String XML_VALUE = " value=\"";
    private static final String XML_PROPLIST = "\t <propertylist name=\"";
    private static final String XML_PROPLIST_CLOSE = "\t </propertylist>\n";
    private static final String XML_ITEM = "\t\t <item>";
    private static final String XML_ITEM_CLOSE = "</item>\n";
    private static final String XML_CLOSE_ELEMENT = "\" /> \n";
    private static final String XML_CLOSE_TAG = "\" > \n";
    private static final String XML_QUOTE = "\"";

    private ConfigConverter() {
    }

    public static ConfigConverter getInstance() {
        return ConfigConverterHolder.instance;
    }

    private void writeComponent(StringBuilder sb, RawPropertyData rpd) {
        String name = rpd.getName();
        String classname = rpd.getClassName();
        Map properties = rpd.getProperties();
        if (name == null || classname == null) {
            return;
        }
        sb.append(XML_COMPONENT).append(name).append("\" type=\"").append(classname).append(XML_CLOSE_TAG);
        for (Map.Entry entry : properties.entrySet()) {
            String propName = (String)entry.getKey();
            Object propVal = entry.getValue();
            if (propName == null && propVal == null) continue;
            if (propVal instanceof String) {
                sb.append(XML_PROP).append(propName).append("\" value=\"").append(propVal).append(XML_CLOSE_ELEMENT);
                continue;
            }
            if (!(propVal instanceof List)) continue;
            sb.append(XML_PROPLIST).append(propName).append(XML_CLOSE_TAG);
            for (Object obj : (List)propVal) {
                String item;
                if (!(obj instanceof String) || (item = (String)obj) == null || item.trim().isEmpty()) continue;
                sb.append(XML_ITEM).append(item).append(XML_ITEM_CLOSE);
            }
            sb.append(XML_PROPLIST_CLOSE);
        }
        sb.append(XML_COMPONENT_CLOSE);
    }

    public StringBuilder writeOutput(ConfigProperties cp) {
        String name;
        StringBuilder sb = new StringBuilder();
        Map<String, String> global = cp.getGlobal();
        Map<String, RawPropertyData> property = cp.getProperty();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n\n<!--    Sphinx-4 Configuration file--> \n<!--  ******************************************************** -->\n\n<config>\n\n");
        sb.append("\n<!--  *******************************************-->\n<!--  frequently tuned properties                -->\n<!-- ********************************************-->\n\n");
        if (global != null) {
            for (Map.Entry<String, String> entry : global.entrySet()) {
                name = entry.getKey();
                if (name == null) continue;
                String value = entry.getValue();
                sb.append(XML_PROP).append(name).append("\" value=\"").append(value).append(XML_CLOSE_ELEMENT);
            }
        }
        sb.append(XML_CONF);
        if (property != null) {
            for (Map.Entry<String, String> entry : property.entrySet()) {
                name = entry.getKey();
                RawPropertyData rpd = (RawPropertyData)entry.getValue();
                if (name == null || rpd == null) continue;
                this.writeComponent(sb, rpd);
            }
        }
        sb.append("</config>\n\n");
        return sb;
    }

    private static class ConfigConverterHolder {
        private static final ConfigConverter instance = new ConfigConverter();

        private ConfigConverterHolder() {
        }
    }
}

