/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.gui.util;

import edu.cmu.sphinx.tools.gui.util.SysCommandExecutor;

public class JavadocExtractor {
    private static String _last_class;
    private static String _last_comment;

    private static String extractJavadocComment(String classname, String class_path, String source_path) {
        if (_last_class == null || !_last_class.equals(classname)) {
            try {
                if (!source_path.trim().endsWith("/")) {
                    source_path = source_path.concat("/");
                }
                String source_file = classname.replace('.', '/') + ".java";
                String commandLine = "javadoc -docletpath \"" + class_path + "\" -doclet edu.cmu.sphinx.tools.gui.util.DocletHelper \"" + source_path.trim() + source_file.trim() + '\"';
                SysCommandExecutor cmdExecutor = SysCommandExecutor.getInstance();
                cmdExecutor.runCommand(commandLine);
                _last_comment = cmdExecutor.getCommandOutput();
                _last_class = classname;
            }
            catch (Exception e) {
                System.err.println("Exception " + e.getMessage());
            }
        }
        return _last_comment;
    }

    public static String getJavadocComment(String classname, String class_path, String source_path, String prop_name) {
        if (source_path == null || source_path.trim().isEmpty()) {
            return null;
        }
        String allComment = _last_class == null || !_last_class.trim().equals(classname.trim()) ? JavadocExtractor.extractJavadocComment(classname, class_path, source_path) : _last_comment;
        String[] comments = allComment.split("={3}");
        for (int i = 1; i < comments.length; ++i) {
            String[] oneComment = comments[i].trim().split("={2}");
            if (!oneComment[0].trim().equals(prop_name) || oneComment.length <= 1) continue;
            oneComment[1] = oneComment[1].replaceAll("(\n|\r)+", " ");
            return oneComment[1];
        }
        return null;
    }
}

