/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.gui.util;

import edu.cmu.sphinx.util.props.PropertyType;

public class ConfigurableProperty {
    private final String _name;
    private final String _default;
    private final PropertyType _type;
    private final String _classtype;
    private final String _desc;
    private final String _original_name;

    public ConfigurableProperty(String name, String defaultval, PropertyType type, String desc, String original) {
        this._name = name;
        this._desc = desc;
        this._type = type;
        this._default = defaultval;
        this._original_name = original;
        this._classtype = null;
        System.out.println(" ***** not component property " + name + '_' + defaultval + '_' + type + '_' + desc + '_' + original);
    }

    public ConfigurableProperty(String name, String defaultval, PropertyType type, String desc, String original, String class_type) {
        this._name = name;
        this._desc = desc;
        this._type = type;
        this._default = defaultval;
        this._original_name = original;
        this._classtype = class_type;
        System.out.println(" ***** component property " + name + '_' + defaultval + '_' + type + '_' + desc + '_' + original + '_' + class_type);
    }

    public String toString() {
        StringBuilder output = new StringBuilder("\nProperty name: ").append(this._name).append(' ');
        if (this._default != null && !this._default.isEmpty()) {
            output.append(" Default value : ").append(this._default).append(' ');
        }
        if (!this._desc.isEmpty()) {
            output.append("\nDescription: ").append(this._desc).append(' ');
        }
        output.append("Original name : ").append(this._original_name).append('\n');
        return output.toString();
    }

    public String getName() {
        return this._name;
    }

    public String getDefault() {
        return this._default;
    }

    public PropertyType getType() {
        if (this._type == null) {
            return null;
        }
        return this._type;
    }

    public String getClassType() {
        return this._classtype;
    }

    public String getOriginalName() {
        return this._original_name;
    }

    public String getDesc() {
        return this._desc;
    }
}

