/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.gui;

import edu.cmu.sphinx.tools.gui.ConfigProperties;
import edu.cmu.sphinx.tools.gui.GUIFileActionListener;
import edu.cmu.sphinx.tools.gui.GUIMediator;
import edu.cmu.sphinx.tools.gui.GUIOperationException;
import edu.cmu.sphinx.tools.gui.util.ConfigurableComponent;
import edu.cmu.sphinx.tools.gui.util.ConfigurableProperty;
import edu.cmu.sphinx.util.props.PropertyType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PanelConfigurable
extends JPanel {
    private final PanelMediator _pm;
    private static final int COMBO_NEUTRAL = 1;
    private JButton jButtonAdd;
    private JButton jButtonChange;
    private JButton jButtonDel;
    private JButton jButtonRefresh;
    private JButton jButtonRemove;
    private JButton jButtonRemoveProp;
    private JButton jButtonSource;
    private JComboBox jComboComponent;
    private JComboBox jComboName;
    private JDialog jDialogSource;
    private JPanel jInnerLeftPanel;
    private JLabel jLabelClass;
    private JLabel jLabelClassType;
    private JLabel jLabelDefault;
    private JLabel jLabelDesc;
    private JLabel jLabelEmpty1;
    private JLabel jLabelEmpty2;
    private JLabel jLabelEmpty4;
    private JLabel jLabelEmpty5;
    private JLabel jLabelEmpty6;
    private JLabel jLabelEmpty7;
    private JLabel jLabelName;
    private JLabel jLabelName1;
    private JLabel jLabelNewVal;
    private JLabel jLabelPropName;
    private JLabel jLabelPropType;
    private JLabel jLabelPropVal;
    private JPanel jLeftPanel;
    private JList jListInner;
    private JList jListOuter;
    private JList jListPropVal;
    private JPanel jPanelDetail;
    private JPanel jRightPanel;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JSeparator jSeparator;
    private JSplitPane jSplitPaneInner;
    private JSplitPane jSplitPaneOuter;
    private JTextArea jTextAreaSource;
    private JTextField jTextClass;
    private JTextField jTextClassType;
    private JTextField jTextDefault;
    private JTextArea jTextDesc;
    private JTextArea jTextInnerList;
    private JTextField jTextNewVal;
    private JTextField jTextPropName;
    private JTextField jTextPropType;

    public PanelConfigurable(GUIMediator gm, String name, Set<ConfigurableComponent> groupset) {
        this.initComponents();
        this._pm = new PanelMediator(name, groupset, gm, this);
        this.initGUIComponents();
    }

    private void setVisibleListPropButton(boolean status) {
        this.jButtonAdd.setVisible(status);
        this.jButtonRemove.setVisible(status);
        this.jButtonChange.setVisible(!status);
    }

    private void setVisibleComponentInput(boolean status) {
        this.jComboComponent.setVisible(status);
        this.jTextNewVal.setVisible(!status);
    }

    public void setPanelClassSet(Set<ConfigurableComponent> ccset) {
        this._pm.setGroupMap(ccset);
    }

    private void setEnablePanelDetail(boolean status) {
        this.jListInner.setEnabled(status);
        this.jTextNewVal.setEnabled(status);
        this.jComboComponent.setEnabled(status);
        this.jButtonChange.setEnabled(status);
        this.jButtonAdd.setEnabled(status);
        this.jButtonRemove.setEnabled(status);
        this.jButtonRefresh.setEnabled(status);
    }

    private void initGUIComponents() {
        this.jListOuter.setSelectionMode(0);
        this.jListInner.setSelectionMode(0);
        this.jListPropVal.setSelectionMode(0);
        this.jListOuter.setLayoutOrientation(0);
        this.jListInner.setLayoutOrientation(0);
        this.jListPropVal.setLayoutOrientation(0);
        DefaultListModel<String> outerlistModel = new DefaultListModel<String>();
        for (String s : this._pm.getGroupMap().keySet()) {
            outerlistModel.addElement(s);
        }
        this.jListOuter.setModel(outerlistModel);
        this.jListInner.setModel(new DefaultListModel());
        this.jListPropVal.setModel(new DefaultListModel());
        this.initComboBox();
        this.jComboName.setEnabled(false);
        this.setEnablePanelDetail(false);
        this.jTextInnerList.setText("Property List : ");
        this.setVisibleComponentInput(false);
        this.setVisibleListPropButton(true);
    }

    private void initComboBox() {
        if (this.jComboName.getItemCount() == 0) {
            String[] comboinit = new String[]{"<Create new set>", "Choose configuration set"};
            this.jComboName.insertItemAt(comboinit[0], 0);
            this.jComboName.insertItemAt(comboinit[1], 1);
            this.jComboName.setSelectedIndex(1);
        }
    }

    private void clearPanelDetail() {
        this.jTextPropName.setText("");
        this.jTextPropType.setText("");
        this.jTextClassType.setText("");
        this.jTextDefault.setText("");
        this.jTextDesc.setText("");
        ((DefaultListModel)this.jListPropVal.getModel()).clear();
        this.jTextNewVal.setText(null);
        this.jComboComponent.removeAllItems();
    }

    private void clearAllDisplay() {
        this.clearRightPanel();
        this.jListOuter.clearSelection();
    }

    private void resetInnerSplitPanel() {
        this.jListInner.clearSelection();
        this.clearPanelDetail();
        this.setEnablePanelDetail(false);
    }

    private void clearRightPanel() {
        Component[] carray;
        for (Component component : carray = this.jRightPanel.getComponents()) {
            if (component instanceof TextComponent) {
                ((TextComponent)component).setText("");
                continue;
            }
            if (!(component instanceof JComboBox)) continue;
            ((JComboBox)component).removeAllItems();
        }
        this.jListInner.clearSelection();
        ((DefaultListModel)this.jListInner.getModel()).clear();
        this.clearPanelDetail();
        this.initComboBox();
        this.setEnablePanelDetail(false);
    }

    private boolean checkSetName(String s) {
        char[] chars = s.toCharArray();
        for (int x = 0; x < chars.length; ++x) {
            char c = chars[x];
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || x >= 1 && c >= '0' && c <= '9' || x >= 1 && c == '_' || x >= 1 && c == '-') continue;
            return false;
        }
        return true;
    }

    private boolean isConfigSetChosen() {
        return this.jComboName.getSelectedIndex() > 1;
    }

    private String getTextInput() {
        String newval;
        if (this.jTextNewVal.isVisible()) {
            newval = this.jTextNewVal.getText();
        } else {
            newval = (String)this.jComboComponent.getSelectedItem();
            newval = newval.substring(0, newval.indexOf(45));
        }
        return newval;
    }

    private void clearPropValue() {
        ((DefaultListModel)this.jListPropVal.getModel()).clear();
    }

    private void initPropValue(Iterator<?> newValue) {
        DefaultListModel model = (DefaultListModel)this.jListPropVal.getModel();
        model.clear();
        if (newValue != null) {
            while (newValue.hasNext()) {
                model.addElement(newValue.next());
            }
        }
    }

    private void displayError(String message) {
        JOptionPane.showMessageDialog(this, message, this._pm.getname(), 0);
    }

    private boolean confirmAction(String message) {
        int response = JOptionPane.showConfirmDialog(this, message, "Confirm Action", 2);
        return response == 0;
    }

    private void initComponents() {
        this.jDialogSource = new JDialog();
        this.jScrollPane6 = new JScrollPane();
        this.jTextAreaSource = new JTextArea();
        this.jSplitPaneOuter = new JSplitPane();
        this.jLeftPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jListOuter = new JList();
        this.jButtonSource = new JButton();
        this.jRightPanel = new JPanel();
        this.jLabelEmpty4 = new JLabel();
        this.jLabelClass = new JLabel();
        this.jTextClass = new JTextField();
        this.jLabelEmpty1 = new JLabel();
        this.jLabelName = new JLabel();
        this.jComboName = new JComboBox();
        this.jButtonDel = new JButton();
        this.jLabelEmpty2 = new JLabel();
        this.jSeparator = new JSeparator();
        this.jLabelName1 = new JLabel();
        this.jSplitPaneInner = new JSplitPane();
        this.jInnerLeftPanel = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.jTextInnerList = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.jListInner = new JList();
        this.jButtonRemoveProp = new JButton();
        this.jPanelDetail = new JPanel();
        this.jLabelPropName = new JLabel();
        this.jTextPropName = new JTextField();
        this.jLabelPropType = new JLabel();
        this.jTextPropType = new JTextField();
        this.jLabelClassType = new JLabel();
        this.jTextClassType = new JTextField();
        this.jLabelDefault = new JLabel();
        this.jTextDefault = new JTextField();
        this.jLabelEmpty5 = new JLabel();
        this.jLabelDesc = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextDesc = new JTextArea();
        this.jLabelEmpty6 = new JLabel();
        this.jLabelPropVal = new JLabel();
        this.jScrollPane7 = new JScrollPane();
        this.jListPropVal = new JList();
        this.jLabelNewVal = new JLabel();
        this.jTextNewVal = new JTextField();
        this.jComboComponent = new JComboBox();
        this.jLabelEmpty7 = new JLabel();
        this.jButtonAdd = new JButton();
        this.jButtonRemove = new JButton();
        this.jButtonChange = new JButton();
        this.jButtonRefresh = new JButton();
        this.jDialogSource.setTitle("Source Code");
        this.jDialogSource.setAlwaysOnTop(true);
        this.jDialogSource.setModal(true);
        this.jDialogSource.setName("dialogSource");
        this.jTextAreaSource.setMargin(new Insets(20, 20, 20, 20));
        this.jScrollPane6.setViewportView(this.jTextAreaSource);
        this.jDialogSource.getContentPane().add((Component)this.jScrollPane6, "Center");
        this.setLayout(new BorderLayout());
        this.jSplitPaneOuter.setDividerLocation(250);
        this.jLeftPanel.setLayout(new BorderLayout());
        this.jListOuter.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PanelConfigurable.this.jListOuterValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListOuter);
        this.jLeftPanel.add((Component)this.jScrollPane1, "Center");
        this.jButtonSource.setText("Show Source Code");
        this.jButtonSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelConfigurable.this.jButtonSourceActionPerformed(evt);
            }
        });
        this.jLeftPanel.add((Component)this.jButtonSource, "South");
        this.jSplitPaneOuter.setLeftComponent(this.jLeftPanel);
        this.jRightPanel.setMaximumSize(new Dimension(650, Short.MAX_VALUE));
        this.jLabelEmpty4.setPreferredSize(new Dimension(600, 10));
        this.jRightPanel.add(this.jLabelEmpty4);
        this.jLabelClass.setFont(new Font("Tahoma", 1, 12));
        this.jLabelClass.setText("    Class name :");
        this.jRightPanel.add(this.jLabelClass);
        this.jTextClass.setEditable(false);
        this.jTextClass.setPreferredSize(new Dimension(300, 25));
        this.jRightPanel.add(this.jTextClass);
        this.jLabelEmpty1.setPreferredSize(new Dimension(600, 10));
        this.jRightPanel.add(this.jLabelEmpty1);
        this.jLabelName.setFont(new Font("Tahoma", 1, 12));
        this.jLabelName.setText("    Configuration set  :");
        this.jRightPanel.add(this.jLabelName);
        this.jComboName.setOpaque(false);
        this.jComboName.setPreferredSize(new Dimension(200, 25));
        this.jComboName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelConfigurable.this.RightPanelTopActionPerformed(evt);
            }
        });
        this.jRightPanel.add(this.jComboName);
        this.jButtonDel.setText("Delete");
        this.jButtonDel.setPreferredSize(new Dimension(75, 25));
        this.jButtonDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelConfigurable.this.RightPanelTopActionPerformed(evt);
            }
        });
        this.jRightPanel.add(this.jButtonDel);
        this.jLabelEmpty2.setPreferredSize(new Dimension(400, 10));
        this.jRightPanel.add(this.jLabelEmpty2);
        this.jSeparator.setPreferredSize(new Dimension(650, 20));
        this.jRightPanel.add(this.jSeparator);
        this.jLabelName1.setFont(new Font("Tahoma", 1, 10));
        this.jLabelName1.setText("Please choose a configuration set before selecting any configurable property !");
        this.jRightPanel.add(this.jLabelName1);
        this.jSplitPaneInner.setDividerLocation(150);
        this.jSplitPaneInner.setMaximumSize(new Dimension(350, 600));
        this.jSplitPaneInner.setPreferredSize(new Dimension(600, 430));
        this.jInnerLeftPanel.setLayout(new BorderLayout());
        this.jTextInnerList.setColumns(10);
        this.jTextInnerList.setEditable(false);
        this.jTextInnerList.setFont(new Font("Courier", 1, 13));
        this.jTextInnerList.setLineWrap(true);
        this.jTextInnerList.setRows(1);
        this.jScrollPane4.setViewportView(this.jTextInnerList);
        this.jInnerLeftPanel.add((Component)this.jScrollPane4, "North");
        this.jListInner.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PanelConfigurable.this.jListInnerValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jListInner);
        this.jInnerLeftPanel.add((Component)this.jScrollPane2, "Center");
        this.jButtonRemoveProp.setText("Remove from Set");
        this.jButtonRemoveProp.setToolTipText("Remove selected property from configuration set");
        this.jButtonRemoveProp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelConfigurable.this.jButtonRemovePropActionPerformed(evt);
            }
        });
        this.jInnerLeftPanel.add((Component)this.jButtonRemoveProp, "South");
        this.jSplitPaneInner.setLeftComponent(this.jInnerLeftPanel);
        this.jPanelDetail.setMaximumSize(new Dimension(600, 600));
        this.jLabelPropName.setText("Property Name ");
        this.jPanelDetail.add(this.jLabelPropName);
        this.jTextPropName.setEditable(false);
        this.jTextPropName.setPreferredSize(new Dimension(300, 25));
        this.jPanelDetail.add(this.jTextPropName);
        this.jLabelPropType.setText("Property Type  ");
        this.jPanelDetail.add(this.jLabelPropType);
        this.jTextPropType.setEditable(false);
        this.jTextPropType.setFont(new Font("Tahoma", 1, 11));
        this.jTextPropType.setPreferredSize(new Dimension(300, 25));
        this.jPanelDetail.add(this.jTextPropType);
        this.jLabelClassType.setText("      Class Type  ");
        this.jPanelDetail.add(this.jLabelClassType);
        this.jTextClassType.setEditable(false);
        this.jTextClassType.setFont(new Font("Tahoma", 1, 11));
        this.jTextClassType.setPreferredSize(new Dimension(300, 25));
        this.jPanelDetail.add(this.jTextClassType);
        this.jLabelDefault.setText("     Default value");
        this.jPanelDetail.add(this.jLabelDefault);
        this.jTextDefault.setEditable(false);
        this.jTextDefault.setFont(new Font("Tahoma", 1, 11));
        this.jTextDefault.setPreferredSize(new Dimension(300, 25));
        this.jPanelDetail.add(this.jTextDefault);
        this.jLabelEmpty5.setPreferredSize(new Dimension(600, 10));
        this.jPanelDetail.add(this.jLabelEmpty5);
        this.jLabelDesc.setText("       Description        ");
        this.jPanelDetail.add(this.jLabelDesc);
        this.jTextDesc.setColumns(25);
        this.jTextDesc.setEditable(false);
        this.jTextDesc.setLineWrap(true);
        this.jTextDesc.setRows(4);
        this.jScrollPane3.setViewportView(this.jTextDesc);
        this.jPanelDetail.add(this.jScrollPane3);
        this.jLabelEmpty6.setPreferredSize(new Dimension(600, 10));
        this.jPanelDetail.add(this.jLabelEmpty6);
        this.jLabelPropVal.setText("   Current value                   ");
        this.jPanelDetail.add(this.jLabelPropVal);
        this.jScrollPane7.setMinimumSize(new Dimension(250, 23));
        this.jScrollPane7.setPreferredSize(new Dimension(250, 75));
        this.jListPropVal.setVisibleRowCount(3);
        this.jScrollPane7.setViewportView(this.jListPropVal);
        this.jPanelDetail.add(this.jScrollPane7);
        this.jLabelNewVal.setText("         New value  ");
        this.jPanelDetail.add(this.jLabelNewVal);
        this.jTextNewVal.setPreferredSize(new Dimension(300, 25));
        this.jPanelDetail.add(this.jTextNewVal);
        this.jComboComponent.setFont(new Font("Tahoma", 1, 10));
        this.jComboComponent.setPreferredSize(new Dimension(300, 25));
        this.jPanelDetail.add(this.jComboComponent);
        this.jLabelEmpty7.setPreferredSize(new Dimension(600, 10));
        this.jPanelDetail.add(this.jLabelEmpty7);
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.setPreferredSize(new Dimension(200, 25));
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelConfigurable.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jPanelDetail.add(this.jButtonAdd);
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.setPreferredSize(new Dimension(200, 25));
        this.jButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelConfigurable.this.jButtonRemoveActionPerformed(evt);
            }
        });
        this.jPanelDetail.add(this.jButtonRemove);
        this.jButtonChange.setMnemonic(67);
        this.jButtonChange.setText("Change Value");
        this.jButtonChange.setPreferredSize(new Dimension(200, 25));
        this.jButtonChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelConfigurable.this.jButtonChangeActionPerformed(evt);
            }
        });
        this.jPanelDetail.add(this.jButtonChange);
        this.jButtonRefresh.setText("Refresh Property");
        this.jButtonRefresh.setPreferredSize(new Dimension(250, 23));
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelConfigurable.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jPanelDetail.add(this.jButtonRefresh);
        this.jSplitPaneInner.setRightComponent(this.jPanelDetail);
        this.jRightPanel.add(this.jSplitPaneInner);
        this.jSplitPaneOuter.setRightComponent(this.jRightPanel);
        this.add((Component)this.jSplitPaneOuter, "Center");
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        String classname = (String)this.jListOuter.getSelectedValue();
        String prop = (String)this.jListInner.getSelectedValue();
        String setname = (String)this.jComboName.getSelectedItem();
        String delval = (String)this.jListPropVal.getSelectedValue();
        if (delval != null && classname != null && setname != null && prop != null) {
            Object[] values;
            ArrayList<String> newlist = new ArrayList<String>();
            for (Object obj : values = ((DefaultListModel)this.jListPropVal.getModel()).toArray()) {
                if (!(obj instanceof String)) continue;
                newlist.add((String)obj);
            }
            if (newlist.remove(delval)) {
                try {
                    if (newlist.isEmpty()) {
                        this.removePropFromSet();
                    } else if (this._pm.allowChangePropertyValue(classname, setname, prop, newlist)) {
                        this._pm.changePropertyValue(classname, setname, prop, newlist);
                        ((DefaultListModel)this.jListPropVal.getModel()).removeElement(delval);
                    }
                }
                catch (PanelMediatorException e) {
                    this.displayError("Internal Error : " + e.getMessage());
                }
            }
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        String newval = this.getTextInput();
        if (newval != null) {
            Object[] values;
            newval = newval.trim();
            String classname = (String)this.jListOuter.getSelectedValue();
            String prop = (String)this.jListInner.getSelectedValue();
            String setname = (String)this.jComboName.getSelectedItem();
            ArrayList<String> newlist = new ArrayList<String>();
            for (Object obj : values = ((DefaultListModel)this.jListPropVal.getModel()).toArray()) {
                if (!(obj instanceof String)) continue;
                newlist.add((String)obj);
            }
            if (!newval.isEmpty() && classname != null && setname != null && prop != null) {
                try {
                    if (this._pm.allowChangePropertyValue(classname, setname, prop, newlist)) {
                        this._pm.changePropertyValue(classname, setname, prop, newlist);
                        ((DefaultListModel)this.jListPropVal.getModel()).addElement(newval);
                    }
                }
                catch (PanelMediatorException e) {
                    this.displayError("Internal Error : " + e.getMessage());
                }
            }
        }
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.updateDetails();
    }

    private void jButtonRemovePropActionPerformed(ActionEvent evt) {
        this.removePropFromSet();
    }

    private void removePropFromSet() {
        if (this.jListOuter.getSelectedValue() != null && this.jListInner.getSelectedValue() != null) {
            String propname = (String)this.jListInner.getSelectedValue();
            if (this.isConfigSetChosen() && this.confirmAction("Confirm delete this item?")) {
                try {
                    this._pm.deletePropertyFromConfigurationSet((String)this.jListOuter.getSelectedValue(), propname, (String)this.jComboName.getSelectedItem());
                    this.clearPanelDetail();
                    this.jListInner.clearSelection();
                }
                catch (PanelMediatorException e) {
                    this.displayError("Error :" + e.getMessage());
                }
            } else {
                this.displayError("You have to select a configuration set");
            }
        }
    }

    private void jButtonSourceActionPerformed(ActionEvent evt) {
        if (this.jListOuter.getSelectedValue() != null) {
            String classname = (String)this.jListOuter.getSelectedValue();
            String code = this._pm.getSource(classname);
            this.jTextAreaSource.setText(code);
            this.jDialogSource.setSize(800, 500);
            this.jDialogSource.setLocationRelativeTo(null);
            this.jDialogSource.setVisible(true);
        }
    }

    private void jButtonChangeActionPerformed(ActionEvent evt) {
        String newval = this.getTextInput();
        if (newval != null) {
            newval = newval.trim();
            String classname = (String)this.jListOuter.getSelectedValue();
            String prop = (String)this.jListInner.getSelectedValue();
            String setname = (String)this.jComboName.getSelectedItem();
            if (!newval.isEmpty() && classname != null && setname != null && prop != null) {
                try {
                    if (this._pm.allowChangePropertyValue(classname, setname, prop, newval)) {
                        this._pm.changePropertyValue(classname, setname, prop, newval);
                    }
                    this.clearPropValue();
                    ((DefaultListModel)this.jListPropVal.getModel()).addElement(this._pm.getPropertyValue(classname, setname, prop).next());
                }
                catch (PanelMediatorException pme) {
                    this.displayError("Internal Error : " + pme.getMessage());
                }
            }
        }
    }

    private void jListInnerValueChanged(ListSelectionEvent evt) {
        this.updateDetails();
    }

    private void updateDetails() {
        String classname;
        ConfigurableProperty cp;
        String prop = (String)this.jListInner.getSelectedValue();
        if (prop != null && (cp = this._pm.getProperty(classname = (String)this.jListOuter.getSelectedValue(), prop)) != null) {
            this.jTextPropName.setText(cp.getName());
            PropertyType mytype = cp.getType();
            this.jTextPropType.setText(mytype == null ? null : mytype.toString());
            if (mytype == PropertyType.COMPONENT || mytype == PropertyType.COMPONENT_LIST) {
                this.jLabelClassType.setVisible(true);
                this.jTextClassType.setVisible(true);
                this.jTextClassType.setText(cp.getClassType());
            } else {
                this.jLabelClassType.setVisible(false);
                this.jTextClassType.setVisible(false);
                this.jTextClassType.setText("");
            }
            this.jTextDefault.setText(cp.getDefault());
            this.jTextDesc.setText(cp.getDesc());
            if (this.isConfigSetChosen()) {
                this.initPropValue(this._pm.getPropertyValue(classname, (String)this.jComboName.getSelectedItem(), prop));
            } else {
                this.clearPropValue();
            }
            this.jTextNewVal.setText(null);
            this.jComboComponent.removeAllItems();
            this.setVisibleListPropButton(this._pm.isListProperty(classname, prop));
            if (this._pm.isComponentProperty(classname, prop)) {
                this.setVisibleComponentInput(true);
                List mylist = this._pm.getComponentList(classname, prop);
                if (mylist != null && !mylist.isEmpty()) {
                    for (String item : mylist) {
                        this.jComboComponent.addItem(item);
                    }
                }
            } else {
                this.setVisibleComponentInput(false);
            }
        }
    }

    private void RightPanelTopActionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source instanceof JButton) {
            if (this.isConfigSetChosen() && this.confirmAction("Confirm delete this item?")) {
                try {
                    this._pm.deleteConfigurationSet((String)this.jListOuter.getSelectedValue(), (String)this.jComboName.getSelectedItem());
                    this.jComboName.removeItemAt(this.jComboName.getSelectedIndex());
                    this.jComboName.setSelectedIndex(1);
                }
                catch (PanelMediatorException pme) {
                    this.displayError("Internal Error : " + pme.getMessage());
                }
            }
        } else if (source instanceof JComboBox) {
            String s;
            this.resetInnerSplitPanel();
            if (this.isConfigSetChosen()) {
                this.setEnablePanelDetail(true);
            } else if (this.jComboName.getSelectedIndex() == 0 && (s = JOptionPane.showInputDialog(this, "Please enter the name of new config", "Create New Configuration Set", -1)) != null && !s.isEmpty() && !s.trim().isEmpty()) {
                if (this.checkSetName(s = s.trim())) {
                    try {
                        this._pm.createNewConfigurationSet(s, (String)this.jListOuter.getSelectedValue());
                        this.jComboName.addItem(s.trim());
                        this.jComboName.setSelectedIndex(this.jComboName.getItemCount() - 1);
                        this.setEnablePanelDetail(true);
                    }
                    catch (PanelMediatorException pme) {
                        this.displayError("Internal error " + pme.getMessage());
                        this.jComboName.setSelectedIndex(1);
                    }
                } else {
                    this.displayError("The new set name is not valid\nSet name must start with an alphabet and contain only A-Z; a-z; 0-9; -; _");
                    this.jComboName.setSelectedIndex(1);
                }
            }
        }
    }

    private void jListOuterValueChanged(ListSelectionEvent evt) {
        this.clearRightPanel();
        String classname = (String)this.jListOuter.getSelectedValue();
        if (classname != null) {
            Set prop;
            this.jComboName.setEnabled(true);
            this.jTextClass.setText(classname.substring(classname.lastIndexOf(46) + 1));
            Set config = this._pm.getConfigurationSet((String)this.jListOuter.getSelectedValue());
            if (config != null) {
                for (String configItem : config) {
                    this.jComboName.addItem(configItem);
                }
            }
            if ((prop = this._pm.getPropertySet((String)this.jListOuter.getSelectedValue())) != null) {
                DefaultListModel innerlistModel = (DefaultListModel)this.jListInner.getModel();
                for (String propItem : prop) {
                    innerlistModel.addElement(propItem);
                }
            }
        }
    }

    private class PanelMediatorException
    extends Exception {
        private static final int INVALID_CLASSNAME = 1;
        private static final int DUPLICATE_SET_NAME = 2;
        private static final int INVALID_SETNAME = 3;
        private static final int INVALID_PROPNAME = 4;
        private static final int INVALID_VALUE = 5;

        private PanelMediatorException(int mode, String msg) {
            super(msg);
        }
    }

    private class PanelMediator
    implements GUIFileActionListener {
        private final Map<String, ConfigurableComponent> _ccmap;
        private final String _sectionName;
        private final GUIMediator _gmediator;
        private final PanelConfigurable _panel;

        private PanelMediator(String name, Set<ConfigurableComponent> grpset, GUIMediator gmediator, PanelConfigurable panel) {
            this._gmediator = gmediator;
            this._panel = panel;
            this._sectionName = name;
            this._ccmap = new HashMap<String, ConfigurableComponent>();
            this.setGroupMap(grpset);
            this._gmediator.registerPanel(this);
        }

        private void setGroupMap(Set<ConfigurableComponent> grpset) {
            this._ccmap.clear();
            for (ConfigurableComponent cc : grpset) {
                this._ccmap.put(cc.getName(), cc);
            }
        }

        @Override
        public void update(ConfigProperties cp) {
            this._panel.clearAllDisplay();
        }

        @Override
        public void saveData(ConfigProperties cp) throws GUIOperationException {
        }

        @Override
        public void clearAll() {
            this._panel.clearAllDisplay();
            System.out.println("*** clear all ");
        }

        @Override
        public void modelRefresh() {
        }

        private Map<String, ConfigurableComponent> getGroupMap() {
            return this._ccmap;
        }

        private String getname() {
            return this._sectionName;
        }

        private Set<String> getConfigurationSet(String classname) {
            if (this._ccmap.containsKey(classname)) {
                ConfigurableComponent cc = this._ccmap.get(classname);
                if (cc.getConfigurationPropMap() != null && !cc.getConfigurationPropMap().isEmpty()) {
                    return cc.getConfigurationPropMap().keySet();
                }
                return null;
            }
            return null;
        }

        private void deleteConfigurationSet(String classname, String setname) throws PanelMediatorException {
            ConfigurableComponent cc;
            if (this._ccmap.containsKey(classname)) {
                cc = this._ccmap.get(classname);
                if (!cc.containsConfigurationSet(setname)) {
                    throw new PanelMediatorException(3, "The configuration set name is invalid");
                }
            } else {
                throw new PanelMediatorException(1, "The classname is invalid");
            }
            cc.deleteConfigurationProp(setname);
        }

        private void deletePropertyFromConfigurationSet(String classname, String propname, String setname) throws PanelMediatorException {
            ConfigurableComponent cc;
            if (this._ccmap.containsKey(classname)) {
                cc = this._ccmap.get(classname);
                if (!cc.containsConfigurationSet(setname)) {
                    throw new PanelMediatorException(3, "The configuration set name is invalid");
                }
            } else {
                throw new PanelMediatorException(1, "The classname is invalid");
            }
            cc.deleteOneConfigurationPropFromSet(setname, propname);
        }

        private void createNewConfigurationSet(String name, String classname) throws PanelMediatorException {
            if (this._gmediator.getModelBuilder().checkDuplicateConfigurationSet(name)) {
                throw new PanelMediatorException(2, "This name has been used for another configuration set\nPlease choose a different name");
            }
            if (!this._ccmap.containsKey(classname)) {
                throw new PanelMediatorException(1, "Invalid class name");
            }
            ConfigurableComponent cc = this._ccmap.get(classname);
            cc.createNewSet(name);
        }

        private Set<String> getPropertySet(String classname) {
            if (this._ccmap.containsKey(classname)) {
                ConfigurableComponent cc = this._ccmap.get(classname);
                if (cc.getPropertyMap() != null && !cc.getPropertyMap().isEmpty()) {
                    return cc.getPropertyMap().keySet();
                }
                return null;
            }
            return null;
        }

        private ConfigurableProperty getProperty(String classname, String propname) {
            if (this._ccmap.containsKey(classname)) {
                ConfigurableComponent cc = this._ccmap.get(classname);
                if (cc.containsProperty(propname)) {
                    return cc.getProperty(propname);
                }
                return null;
            }
            return null;
        }

        private boolean isComponentProperty(String classname, String propname) {
            PropertyType type;
            ConfigurableProperty cp = this.getProperty(classname, propname);
            return cp != null && (type = cp.getType()) != null && type.toString().startsWith("Component");
        }

        private boolean isListProperty(String classname, String propname) {
            ConfigurableProperty cp = this.getProperty(classname, propname);
            if (cp != null) {
                PropertyType type = cp.getType();
                if (type == null) {
                    return true;
                }
                return type.toString().trim().endsWith("List");
            }
            return true;
        }

        private Iterator<?> getPropertyValue(String classname, String setName, String propname) {
            if (this._ccmap.containsKey(classname)) {
                ConfigurableComponent cc = this._ccmap.get(classname);
                Object propval = cc.getConfigurationPropValue(setName, propname);
                if (propval != null) {
                    if (propval instanceof String) {
                        ArrayList<String> retlist = new ArrayList<String>();
                        retlist.add((String)propval);
                        return retlist.iterator();
                    }
                    return ((List)propval).iterator();
                }
                return null;
            }
            return null;
        }

        private void changePropertyValue(String classname, String setName, String propname, String propval) throws PanelMediatorException {
            ConfigurableComponent cc = this._ccmap.get(classname);
            cc.changeConfigurationPropValue(setName, propname, propval);
        }

        private void changePropertyValue(String classname, String setName, String propname, List<String> propval) throws PanelMediatorException {
            ConfigurableComponent cc = this._ccmap.get(classname);
            cc.changeConfigurationPropValue(setName, propname, propval);
        }

        private boolean allowChangePropertyValue(String classname, String setName, String propname, Object propval) throws PanelMediatorException {
            if (this._ccmap.containsKey(classname)) {
                ConfigurableComponent cc = this._ccmap.get(classname);
                if (cc.containsConfigurationSet(setName) && cc.containsProperty(propname)) {
                    if (this.isValidPropertyValue(classname, propname, propval)) {
                        return true;
                    }
                    throw new PanelMediatorException(5, "Invalid property value");
                }
                if (!cc.containsConfigurationSet(setName)) {
                    throw new PanelMediatorException(3, "Invalid configuration set name");
                }
                throw new PanelMediatorException(4, "Invalid property name");
            }
            throw new PanelMediatorException(1, "Invalid class name");
        }

        private boolean isValidPropertyValue(String classname, String propname, Object propval) {
            ConfigurableComponent cc;
            if (this._ccmap.containsKey(classname) && (cc = this._ccmap.get(classname)).containsProperty(propname)) {
                ConfigurableProperty cp = cc.getProperty(propname);
                return cp.getType() == null || cp.getType().isValid(propval);
            }
            return false;
        }

        private String getSource(String classname) {
            return this._gmediator.getModelBuilder().getSourceCode(classname);
        }

        private List<String> getComponentList(String classname, String prop) {
            Map<String, String> mymap;
            String classtype;
            ConfigurableProperty cp = this.getProperty(classname, prop);
            if (cp != null && (classtype = cp.getClassType()) != null && !classtype.isEmpty() && (mymap = this._gmediator.getModelBuilder().getclasslist(classtype)) != null && !mymap.isEmpty()) {
                ArrayList<String> myreturn = new ArrayList<String>();
                for (Map.Entry<String, String> me : mymap.entrySet()) {
                    String setname = me.getKey();
                    String fullname = me.getValue();
                    int index = fullname.lastIndexOf(46);
                    String localname = fullname.substring(index + 1);
                    String packagename = fullname.substring(0, index);
                    String myitem = setname + '-' + localname + '(' + packagename + ')';
                    myreturn.add(myitem);
                }
                return myreturn;
            }
            return null;
        }
    }
}

