/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.batch;

import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.frontend.DataProcessor;
import edu.cmu.sphinx.linguist.language.grammar.BatchForcedAlignerGrammar;
import edu.cmu.sphinx.linguist.language.grammar.ForcedAlignerGrammar;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.tools.batch.BatchNISTRecognizer;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

public class BatchForcedAlignerRecognizer
extends BatchNISTRecognizer {
    String segFile;
    ForcedAlignerGrammar forcedAlignerGrammar;
    public BatchForcedAlignerGrammar bfaGrammar;

    @Override
    protected void setInputStream(BatchNISTRecognizer.CTLUtterance utt) throws IOException {
        super.setInputStream(utt);
        this.bfaGrammar.setUtterance(utt.getName());
    }

    @Override
    protected void handleResult(DataOutputStream out, BatchNISTRecognizer.CTLUtterance utt, Result result) throws IOException {
        System.out.println(utt + " --> " + result);
        Token token = result.getBestToken();
        this.dumpTokenTimes(token);
    }

    void dumpTokenTimes(Token token) {
        if (token != null) {
            this.dumpTokenTimes(token.getPredecessor());
            System.out.println(token.getWord() + " " + token.getFrameNumber());
        }
    }

    public BatchForcedAlignerRecognizer(BatchForcedAlignerGrammar bfaGrammar, Recognizer recognizer, List<DataProcessor> inputDataProcessors, String ctlFile, String dataDir, String refFile, String ctmFile, int bitsPerSample, int samplesPerSecond, int framesPerSecond, int channelCount) {
        super(recognizer, inputDataProcessors, ctlFile, dataDir, refFile, ctmFile, bitsPerSample, samplesPerSecond, framesPerSecond, channelCount);
        this.bfaGrammar = bfaGrammar;
    }

    public BatchForcedAlignerRecognizer() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.bfaGrammar = (BatchForcedAlignerGrammar)ps.getComponent("forcedAlignerGrammar");
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.out.println("Usage: BatchForcedAlignerRecognizer propertiesFile");
            System.exit(1);
        }
        BatchNISTRecognizer.main(argv);
    }
}

