/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.audio;

import edu.cmu.sphinx.tools.audio.Downsampler;
import edu.cmu.sphinx.tools.audio.RawReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;

public class RawRecorder {
    final Object lock = new Object();
    RecordThread recorder;
    AudioFormat inFormat;
    final AudioFormat outFormat;
    TargetDataLine microphone;
    boolean downsample;

    public RawRecorder(AudioFormat audioFormat) throws LineUnavailableException {
        this.inFormat = audioFormat;
        this.outFormat = audioFormat;
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.inFormat);
        if (!AudioSystem.isLineSupported(info)) {
            this.downsample = true;
            this.inFormat = new AudioFormat(44100.0f, 16, 1, true, true);
            info = new DataLine.Info(TargetDataLine.class, this.inFormat);
            if (!AudioSystem.isLineSupported(info)) {
                throw new LineUnavailableException("Unsupported format: " + audioFormat);
            }
        }
        this.microphone = (TargetDataLine)AudioSystem.getLine(info);
        this.microphone.open(audioFormat, this.microphone.getBufferSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.recorder != null) {
                this.recorder.stopRecording();
            }
            this.recorder = new RecordThread();
            this.recorder.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short[] stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.recorder == null) {
                return new short[0];
            }
            ByteArrayOutputStream out = this.recorder.stopRecording();
            this.microphone.close();
            this.recorder = null;
            byte[] audioBytes = out.toByteArray();
            ByteArrayInputStream in = new ByteArrayInputStream(audioBytes);
            try {
                short[] samples = RawReader.readAudioData(in, this.inFormat);
                if (this.downsample) {
                    samples = Downsampler.downsample(samples, (int)(this.inFormat.getSampleRate() / 1000.0f), (int)(this.outFormat.getSampleRate() / 1000.0f));
                }
                return samples;
            }
            catch (IOException e) {
                e.printStackTrace();
                return new short[0];
            }
        }
    }

    class RecordThread
    extends Thread {
        boolean done;
        final Object lock = new Object();
        ByteArrayOutputStream out;

        RecordThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteArrayOutputStream stopRecording() {
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.done = true;
                    this.lock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] data = new byte[RawRecorder.this.microphone.getBufferSize()];
            this.out = new ByteArrayOutputStream();
            try {
                int numBytesRead;
                RawRecorder.this.microphone.flush();
                RawRecorder.this.microphone.start();
                while (!this.done && (numBytesRead = RawRecorder.this.microphone.read(data, 0, data.length)) != -1) {
                    this.out.write(data, 0, numBytesRead);
                }
                RawRecorder.this.microphone.stop();
                this.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
    }
}

