/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.audio;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FrontEnd;
import edu.cmu.sphinx.frontend.util.Microphone;
import edu.cmu.sphinx.frontend.util.StreamDataSource;
import edu.cmu.sphinx.tools.audio.AudioData;
import edu.cmu.sphinx.tools.audio.AudioPanel;
import edu.cmu.sphinx.tools.audio.AudioPlayer;
import edu.cmu.sphinx.tools.audio.Downsampler;
import edu.cmu.sphinx.tools.audio.SpectrogramPanel;
import edu.cmu.sphinx.tools.audio.Utils;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class AudioTool {
    static final String CONTEXT = "AudioTool";
    static final String PREFS_CONTEXT = "/edu/cmu/sphinx/tools/audio/AudioTool";
    static final String FILENAME_PREFERENCE = "filename";
    static final String MICROPHONE = "microphone";
    static final String FRONT_END = "frontEnd";
    static final String DATA_SOURCE = "streamDataSource";
    static final String WINDOWER = "windower";
    static AudioData audio;
    static JFrame jframe;
    static AudioPanel audioPanel;
    static SpectrogramPanel spectrogramPanel;
    static JFileChooser fileChooser;
    static String filename;
    static File file;
    static AudioPlayer player;
    static Microphone recorder;
    static boolean recording;
    static Preferences prefs;
    static float zoom;
    private static JMenuItem saveMenuItem;
    private static JButton playButton;
    private static JButton recordButton;
    private static JButton zoomInButton;
    private static JButton zoomOutButton;
    private static JButton zoomResetButton;
    private static ActionListener recordListener;

    private static void dumpLineInfo(String indent, Line.Info[] lineInfo) {
        int numDumped = 0;
        if (lineInfo != null) {
            for (Line.Info info : lineInfo) {
                if (info instanceof DataLine.Info) {
                    AudioFormat[] formats;
                    for (AudioFormat format : formats = ((DataLine.Info)info).getFormats()) {
                        System.out.println(indent + format);
                    }
                    ++numDumped;
                    continue;
                }
                if (!(info instanceof Port.Info)) continue;
                System.out.println(indent + info);
                ++numDumped;
            }
        }
        if (numDumped == 0) {
            System.out.println(indent + "none");
        }
    }

    private static void dumpMixers() {
        Mixer.Info[] mixerInfo = AudioSystem.getMixerInfo();
        for (int i = 0; i < mixerInfo.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(mixerInfo[i]);
            System.out.println("Mixer[" + i + "]: \"" + mixerInfo[i].getName() + '\"');
            System.out.println("    Description: " + mixerInfo[i].getDescription());
            System.out.println("    SourceLineInfo (e.g., speakers):");
            AudioTool.dumpLineInfo("        ", mixer.getSourceLineInfo());
            System.out.println("    TargetLineInfo (e.g., microphones):");
            AudioTool.dumpLineInfo("        ", mixer.getTargetLineInfo());
        }
    }

    public static void getFilename(String title, int type) {
        fileChooser.setDialogTitle(title);
        fileChooser.setCurrentDirectory(file);
        fileChooser.setDialogType(type);
        int returnVal = type == 0 ? fileChooser.showOpenDialog(jframe) : fileChooser.showSaveDialog(jframe);
        if (returnVal == 0) {
            file = fileChooser.getSelectedFile();
            filename = file.getAbsolutePath();
            prefs.put(FILENAME_PREFERENCE, filename);
        }
    }

    public static void populateAudio(String filename) {
        try {
            AudioData newAudio = Utils.readAudioFile(filename);
            if (newAudio == null) {
                newAudio = Utils.readRawFile(filename);
            }
            AudioTool.zoomReset();
            audio.setAudioData(newAudio.getAudioData());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void getAudioFromFile(String filename) throws IOException {
        if (filename.endsWith(".align")) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
            AudioTool.populateAudio(reader.readLine());
            int numPoints = Integer.parseInt(reader.readLine());
            float[] times = new float[numPoints];
            String[] labels = new String[numPoints];
            for (int i = 0; i < numPoints; ++i) {
                StringTokenizer tokenizer = new StringTokenizer(reader.readLine());
                while (tokenizer.hasMoreTokens()) {
                    times[i] = Float.parseFloat(tokenizer.nextToken());
                    labels[i] = tokenizer.nextToken();
                }
            }
            audioPanel.setLabels(times, labels);
            reader.close();
        } else {
            AudioTool.populateAudio(filename);
        }
    }

    private static short[] getRecordedAudio(Microphone recorder) {
        short[] shorts = new short[]{};
        int sampleRate = 16000;
        while (recorder.hasMoreData()) {
            try {
                Data data = recorder.getData();
                if (!(data instanceof DoubleData)) continue;
                sampleRate = ((DoubleData)data).getSampleRate();
                double[] values = ((DoubleData)data).getValues();
                short[] newShorts = Arrays.copyOf(shorts, shorts.length + values.length);
                for (int i = 0; i < values.length; ++i) {
                    newShorts[shorts.length + i] = (short)values[i];
                }
                shorts = newShorts;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (sampleRate > 16000) {
            System.out.println("Downsampling from " + sampleRate + " to 16000.");
            shorts = Downsampler.downsample(shorts, sampleRate / 1000, 16);
        }
        return shorts;
    }

    private static void zoomPanels() {
        if (audioPanel != null) {
            audioPanel.zoomSet(zoom);
        }
        if (spectrogramPanel != null) {
            spectrogramPanel.zoomSet(zoom);
        }
    }

    private static void zoomIn() {
        zoom *= 2.0f;
        AudioTool.zoomPanels();
    }

    private static void zoomOut() {
        zoom /= 2.0f;
        AudioTool.zoomPanels();
    }

    private static void zoomReset() {
        zoom = 1.0f;
        AudioTool.zoomPanels();
    }

    private static void createMenuBar(JFrame jframe) {
        JMenuBar menuBar = new JMenuBar();
        jframe.setJMenuBar(menuBar);
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Open...");
        menuItem.setAccelerator(KeyStroke.getKeyStroke("control O"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AudioTool.getFilename("Open...", 0);
                if (filename == null || filename.isEmpty()) {
                    return;
                }
                try {
                    AudioTool.getAudioFromFile(filename);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        menu.add(menuItem);
        saveMenuItem = new JMenuItem("Save");
        saveMenuItem.setAccelerator(KeyStroke.getKeyStroke("control S"));
        saveMenuItem.setEnabled(false);
        saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (filename != null && !filename.isEmpty()) {
                    try {
                        Utils.writeRawFile(audio, filename);
                        saveMenuItem.setEnabled(false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        menu.add(saveMenuItem);
        menuItem = new JMenuItem("Save As...");
        menuItem.setAccelerator(KeyStroke.getKeyStroke("control V"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AudioTool.getFilename("Save As...", 1);
                if (filename == null || filename.isEmpty()) {
                    return;
                }
                try {
                    Utils.writeRawFile(audio, filename);
                    saveMenuItem.setEnabled(false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Quit");
        menuItem.setAccelerator(KeyStroke.getKeyStroke("control Q"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                System.exit(0);
            }
        });
        menu.add(menuItem);
        menu = new JMenu("Edit");
        menuBar.add(menu);
        menuItem = new JMenuItem("Select All");
        menuItem.setAccelerator(KeyStroke.getKeyStroke("control A"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                audioPanel.selectAll();
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Crop");
        menuItem.setAccelerator(KeyStroke.getKeyStroke("control X"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                audioPanel.crop();
            }
        });
        menu.add(menuItem);
        menu = new JMenu("View");
        menuBar.add(menu);
        menuItem = new JMenuItem("Zoom In");
        menuItem.setAccelerator(KeyStroke.getKeyStroke('>'));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AudioTool.zoomIn();
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Zoom Out");
        menuItem.setAccelerator(KeyStroke.getKeyStroke('<'));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AudioTool.zoomOut();
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Original Size");
        menuItem.setAccelerator(KeyStroke.getKeyStroke('!'));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AudioTool.zoomReset();
            }
        });
        menu.add(menuItem);
        menu = new JMenu("Audio");
        menuBar.add(menu);
        menuItem = new JMenuItem("Play");
        menuItem.setAccelerator(KeyStroke.getKeyStroke("control P"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                player.play(audioPanel.getSelectionStart(), audioPanel.getSelectionEnd());
            }
        });
        menu.add(menuItem);
        recordListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!recording) {
                    recording = true;
                    recorder.startRecording();
                    recordButton.setText("Stop");
                    saveMenuItem.setEnabled(true);
                } else {
                    recording = false;
                    recorder.stopRecording();
                    audio.setAudioData(AudioTool.getRecordedAudio(recorder));
                    recordButton.setText("Record");
                    player.play(audioPanel.getSelectionStart(), audioPanel.getSelectionEnd());
                }
            }
        };
        menuItem = new JMenuItem("Record Start/Stop");
        menuItem.setAccelerator(KeyStroke.getKeyStroke("control R"));
        menuItem.addActionListener(recordListener);
        menu.add(menuItem);
    }

    private static JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(0);
        buttonPanel.setLayout(layout);
        playButton = new JButton("Play");
        playButton.setEnabled(true);
        playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                player.play(audioPanel.getSelectionStart(), audioPanel.getSelectionEnd());
            }
        });
        recordButton = new JButton("Record");
        recordButton.setEnabled(true);
        recordButton.addActionListener(recordListener);
        zoomInButton = new JButton("Zoom In");
        zoomInButton.setEnabled(true);
        zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioTool.zoomIn();
            }
        });
        zoomOutButton = new JButton("Zoom Out");
        zoomOutButton.setEnabled(true);
        zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioTool.zoomOut();
            }
        });
        zoomResetButton = new JButton("Reset Size");
        zoomResetButton.setEnabled(true);
        zoomResetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioTool.zoomReset();
            }
        });
        JButton exitButton = new JButton("Exit");
        exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        buttonPanel.add(recordButton);
        buttonPanel.add(playButton);
        buttonPanel.add(zoomInButton);
        buttonPanel.add(zoomOutButton);
        buttonPanel.add(zoomResetButton);
        buttonPanel.add(exitButton);
        return buttonPanel;
    }

    public static void main(String[] args) {
        prefs = Preferences.userRoot().node(PREFS_CONTEXT);
        filename = prefs.get(FILENAME_PREFERENCE, "untitled.raw");
        file = new File(filename);
        if (args.length == 1 && args[0].equals("-dumpMixers")) {
            AudioTool.dumpMixers();
            System.exit(0);
        }
        try {
            if (args.length > 0) {
                filename = args[0];
            }
            URL url = args.length == 2 ? new File(args[1]).toURI().toURL() : AudioTool.class.getResource("spectrogram.config.xml");
            ConfigurationManager cm = new ConfigurationManager(url);
            recorder = (Microphone)cm.lookup(MICROPHONE);
            recorder.initialize();
            audio = new AudioData();
            FrontEnd frontEnd = (FrontEnd)cm.lookup(FRONT_END);
            StreamDataSource dataSource = (StreamDataSource)cm.lookup(DATA_SOURCE);
            PropertySheet ps = cm.getPropertySheet(WINDOWER);
            float windowShiftInMs = ps.getFloat("windowShiftInMs");
            JFrame jframe = new JFrame(CONTEXT);
            fileChooser = new JFileChooser();
            AudioTool.createMenuBar(jframe);
            float windowShiftInSamples = windowShiftInMs * audio.getAudioFormat().getSampleRate() / 1000.0f;
            audioPanel = new AudioPanel(audio, 1.0f / windowShiftInSamples, 0.004f);
            spectrogramPanel = new SpectrogramPanel(frontEnd, dataSource, audio);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)audioPanel, "Center");
            panel.add((Component)spectrogramPanel, "South");
            JScrollPane scroller = new JScrollPane(panel);
            JPanel outerPanel = new JPanel(new BorderLayout());
            outerPanel.add((Component)AudioTool.createButtonPanel(), "North");
            outerPanel.add(scroller);
            player = new AudioPlayer(audio);
            player.start();
            AudioTool.getAudioFromFile(filename);
            jframe.setDefaultCloseOperation(3);
            jframe.setContentPane(outerPanel);
            jframe.pack();
            jframe.setSize(640, 540);
            jframe.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        zoom = 1.0f;
    }
}

