/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.audio;

import edu.cmu.sphinx.tools.audio.AudioData;
import edu.cmu.sphinx.tools.audio.Utils;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;

public class AudioDataInputStream
extends InputStream {
    AudioFormat format;
    int currentIndex;
    int markIndex;
    final short[] shorts;
    final byte[] bytes;

    public AudioDataInputStream(AudioData audio) {
        this.shorts = audio.getAudioData();
        this.bytes = new byte[2 * this.shorts.length];
        byte[] sample = new byte[2];
        for (int i = 0; i < this.shorts.length; ++i) {
            Utils.toBytes(this.shorts[i], sample, true);
            this.bytes[i * 2] = sample[0];
            this.bytes[i * 2 + 1] = sample[1];
        }
    }

    @Override
    public int read() throws IOException {
        if (this.currentIndex >= this.bytes.length) {
            return -1;
        }
        return this.bytes[this.currentIndex++];
    }

    @Override
    public int read(byte[] buf) throws IOException {
        int count = 0;
        for (int i = 0; i < buf.length && this.currentIndex < this.bytes.length; ++i) {
            buf[i] = this.bytes[this.currentIndex++];
            ++count;
        }
        return count == 0 ? -1 : count;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int count = 0;
        for (int i = 0; i < len && i + off < buf.length && this.currentIndex < this.bytes.length; ++i) {
            buf[i + off] = this.bytes[this.currentIndex++];
            ++count;
        }
        return count == 0 ? -1 : count;
    }

    public long skip(int n) throws IOException {
        int actual = n;
        if (this.currentIndex + n > this.bytes.length) {
            actual = this.bytes.length - this.currentIndex;
        }
        this.currentIndex += actual;
        return actual;
    }

    @Override
    public int available() throws IOException {
        return this.bytes.length - this.currentIndex;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public void mark(int readLimit) {
        this.markIndex = this.currentIndex;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void reset() throws IOException {
        this.currentIndex = this.markIndex;
    }
}

