/*
 * Decompiled with CFR 0.152.
 */
package javaFlacEncoder;

public class UTF8Modified {
    static final long oneByteLimit = (long)Math.pow(2.0, 7.0);
    static final long twoByteLimit = (long)Math.pow(2.0, 11.0);
    static final long threeByteLimit = (long)Math.pow(2.0, 16.0);
    static final long fourByteLimit = (long)Math.pow(2.0, 21.0);
    static final long fiveByteLimit = (long)Math.pow(2.0, 26.0);
    static final long sixByteLimit = (long)Math.pow(2.0, 31.0);
    static final long sevenByteLimit = (long)Math.pow(2.0, 36.0);
    static long[] limits = new long[]{oneByteLimit, twoByteLimit, threeByteLimit, fourByteLimit, fiveByteLimit, sixByteLimit, sevenByteLimit};
    public static int DEBUG_LEV = 0;

    public static long decodeFromExtendedUTF8(byte[] input) {
        int leadOnes = 0;
        int leadMask = 128;
        int work = input[0];
        while ((work & leadMask) > 0) {
            ++leadOnes;
            work <<= 1;
        }
        int valMask = 255 >>> leadOnes + 1;
        long val = input[0] & valMask;
        for (int i = 1; i < leadOnes; ++i) {
            int midMask = 63;
            val <<= 6;
            val = (long)(input[i] & midMask) | val;
        }
        return val;
    }

    public static byte[] convertToExtendedUTF8(long value) {
        int bytesNeeded = 1;
        for (int i = 0; i < 7; ++i) {
            if (value < limits[i]) continue;
            ++bytesNeeded;
        }
        byte[] result = new byte[bytesNeeded];
        int byteIndex = 0;
        int inputIndex = 0;
        for (int bytesLeft = bytesNeeded; bytesLeft > 1; --bytesLeft) {
            int midByteMarker = 128;
            int midByteMask = 63;
            int val = (int)(value >>> inputIndex) & midByteMask | midByteMarker;
            result[byteIndex++] = (byte)val;
            inputIndex += 6;
        }
        int onesNeeded = inputIndex / 6;
        if (onesNeeded > 0) {
            ++onesNeeded;
        }
        int startMask = 255 >>> onesNeeded + 1;
        int ones = 255 << 8 - onesNeeded;
        int val = (int)(value >>> inputIndex) & startMask | ones;
        result[byteIndex++] = (byte)val;
        byte[] finalResult = new byte[bytesNeeded];
        int i = 0;
        while (i < bytesNeeded) {
            int sourceIndex = bytesNeeded - 1 - i;
            int destIndex = i++;
            finalResult[destIndex] = result[sourceIndex];
        }
        if (DEBUG_LEV > 10) {
            System.err.print("input:result_length:result :: " + value + ":" + finalResult.length + "::");
            for (i = 0; i < finalResult.length; ++i) {
                System.err.print(Integer.toHexString(finalResult[i]) + ":");
            }
            System.err.println();
        }
        return finalResult;
    }
}

