/*
 * Decompiled with CFR 0.152.
 */
package javaFlacEncoder;

import javaFlacEncoder.EncodedElement;
import javaFlacEncoder.EncodingConfiguration;
import javaFlacEncoder.StreamConfiguration;
import javaFlacEncoder.Subframe;

public class Subframe_Verbatim
extends Subframe {
    public static int DEBUG_LEV = 0;
    public static final EncodingConfiguration.SubframeType type = EncodingConfiguration.SubframeType.VERBATIM;

    Subframe_Verbatim(StreamConfiguration sc) {
        super(sc);
    }

    public boolean registerConfiguration(EncodingConfiguration ec) {
        super.registerConfiguration(ec);
        return true;
    }

    public int encodeSamples(int[] samples, int count, int start, int skip, EncodedElement data, int offset, int bitsPerSample) {
        if (DEBUG_LEV > 0) {
            System.err.println("Subframe_Verbatim::encodeSamples(...)");
        }
        int encodedSamples = count;
        int bits = bitsPerSample * count + offset + 8;
        int bytesNeeded = bits / 8;
        if (bits % 8 != 0) {
            ++bytesNeeded;
        }
        byte[] dataArray = new byte[bytesNeeded];
        int writePosition = offset;
        EncodedElement.addInt(0, 1, writePosition, dataArray);
        EncodedElement.addInt(1, 6, ++writePosition, dataArray);
        EncodedElement.addInt(0, 1, writePosition += 6, dataArray);
        EncodedElement.packInt(samples, bitsPerSample, ++writePosition, start, skip, count, dataArray);
        this.lastEncodedSize = bits - offset;
        data.setData(dataArray);
        data.setUsableBits(bits);
        if (DEBUG_LEV > 0) {
            System.err.println("Subframe_Verbatim::encodeSamples(...): End");
        }
        if (DEBUG_LEV > 10) {
            System.err.println("--: bitsUsed : " + bits + "  : Bytes : " + bytesNeeded);
        }
        return encodedSamples;
    }
}

