/*
 * Decompiled with CFR 0.152.
 */
package javaFlacEncoder;

import javaFlacEncoder.EncodedElement;
import javaFlacEncoder.EncodedElement_32;
import javaFlacEncoder.EncodingConfiguration;
import javaFlacEncoder.LPC;
import javaFlacEncoder.RiceEncoder;
import javaFlacEncoder.StreamConfiguration;
import javaFlacEncoder.Subframe;

public class Subframe_LPC
extends Subframe {
    public static long totalTime = 0L;
    private static final double LOGE_2 = Math.log(2.0);
    private static final double SQRT_2 = Math.sqrt(2.0);
    public static final int MAX_LPC_ORDER = 32;
    public static int DEBUG_LEV = 0;
    public static final EncodingConfiguration.SubframeType type = EncodingConfiguration.SubframeType.LPC;
    int sampleSize = 0;
    RiceEncoder rice = null;
    int _lpcOrder = 0;
    int _lowOrderBits = 0;
    long _totalBits = 0L;
    int _precision = 15;
    int _lastCount = 0;
    int[] _errors = null;
    int[] _quantizedCoeffs = null;
    int _shift = 0;
    LPC[] lpcs = null;
    int[] _samples = null;
    int _offset = 0;
    int _frameSampleSize;
    int _start = 0;
    int _increment = 0;
    long[] correlations = null;
    int[] _windowedSamples = null;

    Subframe_LPC(StreamConfiguration sc) {
        super(sc);
        this.sampleSize = sc.getBitsPerSample();
        this.rice = new RiceEncoder();
        this.lpcs = new LPC[33];
        for (int i = 0; i < 33; ++i) {
            this.lpcs[i] = new LPC(i);
        }
        this._lastCount = -1;
        this._quantizedCoeffs = new int[33];
    }

    public boolean registerConfiguration(EncodingConfiguration ec) {
        return super.registerConfiguration(ec);
    }

    public int encodeSamples(int[] samples, int count, int start, int skip, int offset, int unencSampleSize) {
        int encodedSamples = count;
        if (DEBUG_LEV > 0) {
            System.err.println("Subframe_LPC::encodeSamples(...) : Begin");
            if (DEBUG_LEV > 10) {
                System.err.println("--count : " + count);
                System.err.println("start:skip:offset:::" + start + ":" + skip + ":" + offset);
            }
        }
        int increment = skip + 1;
        if (count != this._lastCount) {
            this._errors = new int[count];
            this._lastCount = count;
            this._windowedSamples = new int[count];
        }
        int minOrder = this.ec.getMinLPCOrder();
        int maxOrder = this.ec.getMaxLPCOrder();
        int frameSampleSize = unencSampleSize;
        int order = -1;
        long totalBits = 0L;
        long[] R = null;
        if (this.correlations == null || this.correlations.length < maxOrder + 1) {
            R = new long[maxOrder + 1];
            this.correlations = R;
        } else {
            R = this.correlations;
        }
        LPC.window(samples, count, start, increment, this._windowedSamples);
        LPC.createAutoCorrelation(R, this._windowedSamples, count, 0, 1, maxOrder);
        int[] coefficients = new int[33];
        int[] errors = new int[count];
        int lowOrderBits = 0;
        int precision = 0;
        int shift = 0;
        int watchCount = 2;
        for (int i = maxOrder; i >= minOrder; --i) {
            LPC.calculate(this.lpcs[i], R);
            int tempTotalBits = Subframe_LPC.partialEncodeLPC(samples, count, start, increment, this.lpcs[i], this, frameSampleSize);
            if ((long)tempTotalBits < totalBits || order == -1) {
                order = i;
                totalBits = tempTotalBits;
                lowOrderBits = this._lowOrderBits;
                precision = this._precision;
                shift = this._shift;
                int[] temp = coefficients;
                coefficients = this._quantizedCoeffs;
                this._quantizedCoeffs = temp;
                temp = errors;
                errors = this._errors;
                this._errors = temp;
                watchCount = 2;
                continue;
            }
            if (--watchCount == 0) break;
        }
        this._lowOrderBits = lowOrderBits;
        this._precision = precision;
        this._shift = shift;
        this._quantizedCoeffs = coefficients;
        this._errors = errors;
        this._samples = samples;
        this._offset = offset;
        this._frameSampleSize = unencSampleSize;
        this._start = start;
        this._increment = increment;
        this._totalBits = totalBits;
        this._lpcOrder = order;
        return encodedSamples;
    }

    public long estimatedSize() {
        return this._totalBits;
    }

    public EncodedElement getData() {
        int totalBits;
        EncodedElement result = new EncodedElement();
        result.clear((int)this._totalBits + 1, this._offset);
        Subframe_LPC.writeLPC(this._samples, this._lastCount, this._start, this._increment, result, this._frameSampleSize, this._lowOrderBits, this._precision, this._shift, this._quantizedCoeffs, this._errors, this._lpcOrder, this.rice);
        this.lastEncodedSize = totalBits = result.getTotalBits();
        if (DEBUG_LEV > 0) {
            System.err.println("lastencodedSize set: " + this.lastEncodedSize);
            System.err.println("Subframe_LPC::getData(...): End");
        }
        return result;
    }

    public int encodeSamples(int[] samples, int count, int start, int skip, EncodedElement dataEle, int offset, int unencSampleSize) {
        this.encodeSamples(samples, count, start, skip, offset, unencSampleSize);
        EncodedElement result = this.getData();
        int totalBits = result.getTotalBits();
        dataEle.data = result.data;
        dataEle.usableBits = result.usableBits;
        dataEle.offset = result.offset;
        dataEle.previous = result.previous;
        dataEle.next = result.next;
        this.lastEncodedSize = totalBits;
        return count;
    }

    private static void writeHeadersAndData(EncodedElement dataEle, int order, int[] coeff, int precision, int shift, int[] samples, int sampleSize, int start, int skip) {
        int encodedType = 0x20 | order - 1;
        dataEle.addInt(0, 1);
        dataEle.addInt(encodedType, 6);
        dataEle.addInt(0, 1);
        if (order > 0) {
            dataEle.packInt(samples, sampleSize, start, skip, order);
        }
        dataEle.addInt(precision - 1, 4);
        dataEle.addInt(shift, 5);
        for (int i = 1; i <= order; ++i) {
            int val = -coeff[i];
            dataEle.addInt(val, precision);
        }
    }

    private static int quantizeCoefficients(double[] coefficients, int[] dest, int order, int precision) {
        int temp;
        double temp2;
        int i;
        int shiftApplied = 0;
        int maxValAllowed = 1 << precision - 1 - 1;
        double maxVal = 0.0;
        for (i = 1; i <= order; ++i) {
            temp2 = coefficients[i];
            if (temp2 < 0.0) {
                temp2 *= -1.0;
            }
            if (!(temp2 > maxVal)) continue;
            maxVal = temp2;
        }
        for (shiftApplied = 15; shiftApplied > 0 && (temp = (int)(maxVal * (double)(1 << shiftApplied))) > maxValAllowed; --shiftApplied) {
        }
        if (maxVal > (double)maxValAllowed) {
            for (i = 1; i <= order; ++i) {
                temp2 = coefficients[i];
                if (temp2 < 0.0) {
                    temp2 *= -1.0;
                }
                dest[i] = temp2 > (double)maxValAllowed ? maxValAllowed : (int)coefficients[i];
            }
        } else {
            for (i = 1; i <= order; ++i) {
                temp2 = coefficients[i] * (double)(1 << shiftApplied);
                temp2 = temp2 > 0.0 ? temp2 + 0.5 : temp2 - 0.5;
                dest[i] = (int)temp2;
            }
        }
        return shiftApplied;
    }

    private static void writeLPC(int[] samples, int count, int start, int increment, EncodedElement ele, int frameSampleSize, int riceParam, int precision, int shift, int[] coeffs, int[] errors, int order, RiceEncoder rice) {
        Subframe_LPC.writeHeadersAndData(ele, order, coeffs, precision, shift, samples, frameSampleSize, start, increment - 1);
        int paramSize = riceParam > 14 ? 5 : 4;
        boolean fiveBitParam = paramSize >= 5;
        RiceEncoder.beginResidual(fiveBitParam, (byte)0, ele);
        EncodedElement_32 temp = new EncodedElement_32(ele.data.length / 4 + 1, ele.getUsableBits() % 8);
        rice.encodeRicePartition(errors, order, 1, count - order, temp, riceParam, fiveBitParam);
        ele.attachEnd(temp.convertToEncodedElement());
    }

    private static int getParam(int[] vals, int end, int start, int max) {
        long sum = 0L;
        for (int i = start; i < end; ++i) {
            int temp = vals[i];
            temp = temp < 0 ? -temp : temp;
            sum += (long)temp;
        }
        float mean = (float)sum / (float)(end - start);
        double temp = LOGE_2 * (double)mean;
        temp = temp < 1.0 ? 0.0 : Math.ceil(Math.log(temp) / LOGE_2);
        int param = (int)temp;
        if (++param < 0) {
            System.err.println("end:start:sum:mean " + end + ":" + start + ":" + sum + ":" + mean);
            param = 1;
            System.err.println("param negative?");
            System.exit(0);
        } else if (param > max) {
            param = max;
        }
        return param;
    }

    private static int partialEncodeLPC(int[] samples, int count, int start, int increment, LPC lpc, Subframe_LPC lpcSubframe, int frameSampleSize) {
        int order = lpc.order;
        double tempLowOrderBits = 0.0;
        int precision = 15;
        int headerSize = order * frameSampleSize + precision * order + 9 + 8;
        int[] coeffs = lpcSubframe._quantizedCoeffs;
        int shift = Subframe_LPC.quantizeCoefficients(lpc.rawCoefficients, coeffs, order, precision);
        int coeff1 = coeffs[1];
        int coeff2 = coeffs[2];
        int coeff3 = coeffs[3];
        int coeff4 = coeffs[4];
        int coeff5 = coeffs[5];
        int coeff6 = coeffs[6];
        int coeff7 = coeffs[7];
        int coeff8 = coeffs[8];
        int coeff9 = coeffs[9];
        int coeff10 = coeffs[10];
        int coeff11 = coeffs[11];
        int coeff12 = coeffs[12];
        int baseIndex = start;
        int targetSampleBase = start + order * increment - increment;
        int tempOrder = order;
        for (int i = order; i < count; ++i) {
            int temp = 0;
            targetSampleBase += increment;
            int sampleIndex = baseIndex;
            baseIndex += increment;
            if (order > 12) {
                switch (order) {
                    case 32: {
                        temp -= coeffs[32] * samples[sampleIndex];
                        sampleIndex += increment;
                    }
                    case 31: {
                        temp -= coeffs[31] * samples[sampleIndex];
                        sampleIndex += increment;
                    }
                    case 30: {
                        temp -= coeffs[30] * samples[sampleIndex];
                        sampleIndex += increment;
                    }
                    case 29: {
                        temp -= coeffs[29] * samples[sampleIndex];
                        sampleIndex += increment;
                    }
                    case 28: {
                        temp -= coeffs[28] * samples[sampleIndex];
                        sampleIndex += increment;
                    }
                    case 27: {
                        temp -= coeffs[27] * samples[sampleIndex];
                        sampleIndex += increment;
                    }
                    case 26: {
                        temp -= coeffs[26] * samples[sampleIndex];
                        sampleIndex += increment;
                    }
                    case 25: {
                        temp -= coeffs[25] * samples[sampleIndex];
                        sampleIndex += increment;
                    }
                    case 24: {
                        temp -= coeffs[24] * samples[sampleIndex];
                        sampleIndex += increment;
                    }
                    case 23: {
                        temp -= coeffs[23] * samples[sampleIndex];
                        sampleIndex += increment;
                    }
                    case 22: {
                        temp -= coeffs[22] * samples[sampleIndex];
                        sampleIndex += increment;
                    }
                    case 21: {
                        temp -= coeffs[21] * samples[sampleIndex];
                        sampleIndex += increment;
                    }
                    case 20: {
                        temp -= coeffs[20] * samples[sampleIndex];
                        sampleIndex += increment;
                    }
                    case 19: {
                        temp -= coeffs[19] * samples[sampleIndex];
                        sampleIndex += increment;
                    }
                    case 18: {
                        temp -= coeffs[18] * samples[sampleIndex];
                        sampleIndex += increment;
                    }
                    case 17: {
                        temp -= coeffs[17] * samples[sampleIndex];
                        sampleIndex += increment;
                    }
                    case 16: {
                        temp -= coeffs[16] * samples[sampleIndex];
                        sampleIndex += increment;
                    }
                    case 15: {
                        temp -= coeffs[15] * samples[sampleIndex];
                        sampleIndex += increment;
                    }
                    case 14: {
                        temp -= coeffs[14] * samples[sampleIndex];
                        sampleIndex += increment;
                    }
                    case 13: {
                        temp -= coeffs[13] * samples[sampleIndex];
                        sampleIndex += increment;
                    }
                }
                tempOrder = 12;
            }
            switch (tempOrder) {
                case 12: {
                    temp -= coeff12 * samples[sampleIndex];
                    sampleIndex += increment;
                }
                case 11: {
                    temp -= coeff11 * samples[sampleIndex];
                    sampleIndex += increment;
                }
                case 10: {
                    temp -= coeff10 * samples[sampleIndex];
                    sampleIndex += increment;
                }
                case 9: {
                    temp -= coeff9 * samples[sampleIndex];
                    sampleIndex += increment;
                }
                case 8: {
                    temp -= coeff8 * samples[sampleIndex];
                    sampleIndex += increment;
                }
                case 7: {
                    temp -= coeff7 * samples[sampleIndex];
                    sampleIndex += increment;
                }
                case 6: {
                    temp -= coeff6 * samples[sampleIndex];
                    sampleIndex += increment;
                }
                case 5: {
                    temp -= coeff5 * samples[sampleIndex];
                    sampleIndex += increment;
                }
                case 4: {
                    temp -= coeff4 * samples[sampleIndex];
                    sampleIndex += increment;
                }
                case 3: {
                    temp -= coeff3 * samples[sampleIndex];
                    sampleIndex += increment;
                }
                case 2: {
                    temp -= coeff2 * samples[sampleIndex];
                    sampleIndex += increment;
                }
                case 1: {
                    temp -= coeff1 * samples[sampleIndex];
                    sampleIndex += increment;
                    break;
                }
            }
            lpcSubframe._errors[i] = samples[targetSampleBase] - (temp >>= shift);
        }
        tempLowOrderBits = Subframe_LPC.getParam(lpcSubframe._errors, count, order, frameSampleSize);
        int riceSize = RiceEncoder.calculateEncodeSize(lpcSubframe._errors, order, 1, count - order, (int)tempLowOrderBits);
        int totalSize = headerSize + riceSize;
        lpcSubframe._precision = precision;
        lpcSubframe._lowOrderBits = (int)tempLowOrderBits;
        lpcSubframe._shift = shift;
        lpcSubframe._totalBits = totalSize;
        return totalSize;
    }

    private class PartialResult {
        int[] samples;
        int start;
        int increment;
        int count;
        int subframeSampleSize;
        int lpcOrder;
        int lowOrderBits;
        int totalBits;
        int precision;
        int lastCount;

        private PartialResult() {
        }
    }
}

