/*
 * Decompiled with CFR 0.152.
 */
package javaFlacEncoder;

import javaFlacEncoder.EncodedElement;
import javaFlacEncoder.EncodingConfiguration;
import javaFlacEncoder.RiceEncoder;
import javaFlacEncoder.StreamConfiguration;
import javaFlacEncoder.Subframe;

public class Subframe_Fixed
extends Subframe {
    public static int DEBUG_LEV = 0;
    public static final EncodingConfiguration.SubframeType type = EncodingConfiguration.SubframeType.FIXED;
    int sampleSize = 0;
    RiceEncoder rice = null;
    int[] bits;
    int[] lowOrderBits;
    long[] sum;
    int[] _error1 = null;
    int[] _error2 = null;
    int[] _error3 = null;
    int[] _error4 = null;
    int _lastCount = 0;
    int _order;
    int[] _errors = null;
    int _offset = 0;
    int _start = 0;
    int _skip = 0;
    int _errorStep = 0;
    int _totalBits;
    int[] _samples = null;
    int _errorOffset = 0;
    int _errorCount = 0;
    int _frameSampleSize = 0;
    private static final double LOG_2 = Math.log(2.0);

    public Subframe_Fixed(StreamConfiguration sc) {
        super(sc);
        this.sampleSize = sc.getBitsPerSample();
        this.rice = new RiceEncoder();
        this.bits = new int[5];
        this.lowOrderBits = new int[5];
        this.sum = new long[5];
        this._lastCount = -1;
    }

    public boolean registerConfiguration(EncodingConfiguration ec) {
        super.registerConfiguration(ec);
        return true;
    }

    public int encodeSamples(int[] samples, int count, int start, int skip, int offset, int unencSampleSize) {
        int tempI;
        int i;
        int encodedSamples = count;
        if (DEBUG_LEV > 0) {
            System.err.println("Subframe_Fixed::encodeSamples(...) : Begin");
            if (DEBUG_LEV > 10) {
                System.err.println("--count : " + count);
                System.err.println("start:skip:offset:::" + start + ":" + skip + ":" + offset);
            }
        }
        int increment = skip + 1;
        if (count != this._lastCount) {
            this._error1 = new int[count];
            this._error2 = new int[count];
            this._error3 = new int[count];
            this._error4 = new int[count];
            this._lastCount = count;
        }
        int[] error1 = this._error1;
        int[] error2 = this._error2;
        int[] error3 = this._error3;
        int[] error4 = this._error4;
        long sum0 = 0L;
        long sum1 = 0L;
        long sum2 = 0L;
        long sum3 = 0L;
        long sum4 = 0L;
        int index = start;
        for (i = 0; i < count; ++i) {
            tempI = samples[index];
            if (tempI < 0) {
                tempI = -tempI;
            }
            sum0 += (long)tempI;
            index += increment;
        }
        for (i = 1; i < 5; ++i) {
            error1[i] = samples[start + i * increment] - samples[start + (i - 1) * increment];
            tempI = error1[i];
            tempI = tempI < 0 ? -tempI : tempI;
            sum1 += (long)tempI;
            if (i > 1) {
                error2[i] = error1[i] - error1[i - 1];
                tempI = error2[i];
                tempI = tempI < 0 ? -tempI : tempI;
                sum2 += (long)tempI;
            }
            if (i > 2) {
                error3[i] = error2[i] - error2[i - 1];
                tempI = error3[i];
                tempI = tempI < 0 ? -tempI : tempI;
                sum3 += (long)tempI;
            }
            if (i <= 3) continue;
            error4[i] = error3[i] - error3[i - 1];
            tempI = error4[i];
            tempI = tempI < 0 ? -tempI : tempI;
            sum4 += (long)tempI;
        }
        index = start + 5 * increment;
        for (i = 5; i < count; ++i) {
            error1[i] = samples[index] - samples[index - increment];
            tempI = error1[i];
            tempI = tempI < 0 ? -tempI : tempI;
            sum1 += (long)tempI;
            error2[i] = error1[i] - error1[i - 1];
            tempI = error2[i];
            tempI = tempI < 0 ? -tempI : tempI;
            sum2 += (long)tempI;
            error3[i] = error2[i] - error2[i - 1];
            tempI = error3[i];
            tempI = tempI < 0 ? -tempI : tempI;
            sum3 += (long)tempI;
            error4[i] = error3[i] - error3[i - 1];
            tempI = error4[i];
            tempI = tempI < 0 ? -tempI : tempI;
            sum4 += (long)tempI;
            index += increment;
        }
        int order = 0;
        for (int i2 = 0; i2 < 5; ++i2) {
            long sumsX = i2 == 0 ? sum0 : (i2 == 1 ? sum1 : (i2 == 2 ? sum2 : (i2 == 3 ? sum3 : sum4)));
            double tempLowOrderBits = LOG_2 * (double)(sumsX / (long)(count - i2));
            this.lowOrderBits[i2] = (int)Math.ceil(Math.log(tempLowOrderBits) / LOG_2);
            if (this.lowOrderBits[i2] < 1) {
                this.lowOrderBits[i2] = 1;
            } else if (this.lowOrderBits[i2] > this.sampleSize) {
                this.lowOrderBits[i2] = this.sampleSize;
            }
            this.bits[i2] = this.lowOrderBits[i2] * (count - i2) + this.sampleSize * i2 + 1;
            order = this.bits[i2] < this.bits[order] ? i2 : order;
        }
        int[] errors = null;
        int errorCount = count - order;
        int errorOffset = order;
        int errorStep = 1;
        switch (order) {
            case 0: {
                errors = samples;
                errorStep += skip;
                errorOffset = start;
                break;
            }
            case 1: {
                errors = error1;
                break;
            }
            case 2: {
                errors = error2;
                break;
            }
            case 3: {
                errors = error3;
                break;
            }
            case 4: {
                errors = error4;
            }
        }
        this._order = order;
        this._offset = offset;
        this._start = start;
        this._errorStep = errorStep;
        this._errorOffset = errorOffset;
        this._errorCount = errorCount;
        this._skip = skip;
        this._samples = samples;
        this._frameSampleSize = unencSampleSize;
        this._errors = errors;
        this._totalBits = unencSampleSize * order + 8 + RiceEncoder.calculateEncodeSize(errors, errorOffset, errorStep, errorCount, this.lowOrderBits[order]);
        return encodedSamples;
    }

    public int estimatedSize() {
        return this._totalBits;
    }

    public EncodedElement getData() {
        EncodedElement dataEle = new EncodedElement();
        dataEle.clear(this._totalBits, this._offset);
        int unencSampleSize = this._frameSampleSize;
        int encodedType = 8 | this._order;
        dataEle.addInt(0, 1);
        dataEle.addInt(encodedType, 6);
        dataEle.addInt(0, 1);
        if (this._order > 0) {
            dataEle.packInt(this._samples, unencSampleSize, this._start, this._skip, this._order);
        }
        int paramSize = this.lowOrderBits[this._order] > 14 ? 5 : 4;
        boolean fiveBitParam = paramSize >= 5;
        RiceEncoder.beginResidual(fiveBitParam, (byte)0, dataEle);
        this.rice.encodeRicePartition(this._errors, this._errorOffset, this._errorStep, this._errorCount, dataEle, this.lowOrderBits[this._order], fiveBitParam);
        this.lastEncodedSize = dataEle.getTotalBits();
        if (DEBUG_LEV > 0) {
            System.err.println("Subframe_Fixed::encodeSamples(...): End");
        }
        return dataEle;
    }

    public int encodeSamples(int[] samples, int count, int start, int skip, EncodedElement dataEle, int offset, int unencSampleSize) {
        int tempI;
        int i;
        int encodedSamples = count;
        if (DEBUG_LEV > 0) {
            System.err.println("Subframe_Fixed::encodeSamples(...) : Begin");
            if (DEBUG_LEV > 10) {
                System.err.println("--count : " + count);
                System.err.println("start:skip:offset:::" + start + ":" + skip + ":" + offset);
            }
        }
        int increment = skip + 1;
        if (count != this._lastCount) {
            this._error1 = new int[count];
            this._error2 = new int[count];
            this._error3 = new int[count];
            this._error4 = new int[count];
            this._lastCount = count;
        }
        int[] error1 = this._error1;
        int[] error2 = this._error2;
        int[] error3 = this._error3;
        int[] error4 = this._error4;
        for (int i2 = 0; i2 < 5; ++i2) {
            this.sum[i2] = 0L;
        }
        for (i = 0; i < count; ++i) {
            tempI = samples[start + i * increment];
            if (tempI < 0) {
                tempI = -tempI;
            }
            this.sum[0] = this.sum[0] + (long)tempI;
        }
        for (i = 1; i < 5; ++i) {
            error1[i] = samples[start + i * increment] - samples[start + (i - 1) * increment];
            tempI = error1[i];
            tempI = tempI < 0 ? -tempI : tempI;
            this.sum[1] = this.sum[1] + (long)tempI;
            if (i > 1) {
                error2[i] = error1[i] - error1[i - 1];
                tempI = error2[i];
                tempI = tempI < 0 ? -tempI : tempI;
                this.sum[2] = this.sum[2] + (long)tempI;
            }
            if (i > 2) {
                error3[i] = error2[i] - error2[i - 1];
                tempI = error3[i];
                tempI = tempI < 0 ? -tempI : tempI;
                this.sum[3] = this.sum[3] + (long)tempI;
            }
            if (i <= 3) continue;
            error4[i] = error3[i] - error3[i - 1];
            tempI = error4[i];
            tempI = tempI < 0 ? -tempI : tempI;
            this.sum[4] = this.sum[4] + (long)tempI;
        }
        for (i = 5; i < count; ++i) {
            error1[i] = samples[start + i * increment] - samples[start + (i - 1) * increment];
            tempI = error1[i];
            tempI = tempI < 0 ? -tempI : tempI;
            this.sum[1] = this.sum[1] + (long)tempI;
            error2[i] = error1[i] - error1[i - 1];
            tempI = error2[i];
            tempI = tempI < 0 ? -tempI : tempI;
            this.sum[2] = this.sum[2] + (long)tempI;
            error3[i] = error2[i] - error2[i - 1];
            tempI = error3[i];
            tempI = tempI < 0 ? -tempI : tempI;
            this.sum[3] = this.sum[3] + (long)tempI;
            error4[i] = error3[i] - error3[i - 1];
            tempI = error4[i];
            tempI = tempI < 0 ? -tempI : tempI;
            this.sum[4] = this.sum[4] + (long)tempI;
        }
        int order = 0;
        for (int i3 = 0; i3 < 5; ++i3) {
            double tempLowOrderBits = Math.log(2.0) * (double)(this.sum[i3] / (long)(count - i3));
            this.lowOrderBits[i3] = (int)Math.ceil(Math.log(tempLowOrderBits) / Math.log(2.0));
            if (this.lowOrderBits[i3] < 0) {
                this.lowOrderBits[i3] = 0;
            } else if (this.lowOrderBits[i3] > this.sampleSize) {
                this.lowOrderBits[i3] = this.sampleSize;
            }
            int n = i3;
            this.lowOrderBits[n] = this.lowOrderBits[n] + 1;
            this.bits[i3] = this.lowOrderBits[i3] * (count - i3) + this.sampleSize * i3 + 1;
            order = this.bits[i3] < this.bits[order] ? i3 : order;
        }
        byte[] data = new byte[this.bits[order] / 8 + 10];
        int[] errors = null;
        int errorCount = count - order;
        int errorOffset = order;
        int errorStep = 1;
        switch (order) {
            case 0: {
                errors = samples;
                errorStep += skip;
                errorOffset = start;
                break;
            }
            case 1: {
                errors = error1;
                break;
            }
            case 2: {
                errors = error2;
                break;
            }
            case 3: {
                errors = error3;
                break;
            }
            case 4: {
                errors = error4;
            }
        }
        dataEle.setData(data);
        dataEle.setUsableBits(offset);
        dataEle.offset = offset;
        int encodedType = 8 | order;
        dataEle.addInt(0, 1);
        dataEle.addInt(encodedType, 6);
        dataEle.addInt(0, 1);
        if (order > 0) {
            dataEle.packInt(samples, unencSampleSize, start, skip, order);
        }
        int paramSize = this.lowOrderBits[order] > 14 ? 5 : 4;
        boolean fiveBitParam = paramSize >= 5;
        RiceEncoder.beginResidual(fiveBitParam, (byte)0, dataEle);
        this.rice.encodeRicePartition(errors, errorOffset, errorStep, errorCount, dataEle, this.lowOrderBits[order], fiveBitParam);
        this.lastEncodedSize = dataEle.getTotalBits();
        if (DEBUG_LEV > 0) {
            System.err.println("Subframe_Fixed::encodeSamples(...): End");
        }
        return encodedSamples;
    }
}

