/*
 * Decompiled with CFR 0.152.
 */
package javaFlacEncoder;

import javaFlacEncoder.EncodingConfiguration;

public class StreamConfiguration
implements Cloneable {
    public static final int MAX_BLOCK_SIZE = 65535;
    public static final int MIN_BLOCK_SIZE = 16;
    public static final int MAX_CHANNEL_COUNT = 8;
    public static final int MIN_SAMPLE_RATE = 1;
    public static final int MAX_SAMPLE_RATE = 655350;
    public static final int MIN_BITS_PER_SAMPLE = 4;
    public static final int MAX_BITS_PER_SAMPLE = 24;
    public static final int DEFAULT_CHANNEL_COUNT = 2;
    public static final int DEFAULT_MAX_BLOCK_SIZE = 4096;
    public static final int DEFAULT_MIN_BLOCK_SIZE = 4096;
    public static final int DEFAULT_SAMPLE_RATE = 44100;
    public static final int DEFAULT_BITS_PER_SAMPLE = 16;
    int channelCount;
    int maxBlockSize;
    int minBlockSize;
    int sampleRate;
    int bitsPerSample;
    boolean validConfig = false;

    public StreamConfiguration() {
        this.channelCount = 2;
        this.maxBlockSize = 4096;
        this.minBlockSize = 4096;
        this.sampleRate = 44100;
        this.bitsPerSample = 16;
        this.validConfig = true;
    }

    public StreamConfiguration(StreamConfiguration sc) {
        this.channelCount = sc.channelCount;
        this.maxBlockSize = sc.maxBlockSize;
        this.minBlockSize = sc.minBlockSize;
        this.sampleRate = sc.sampleRate;
        this.bitsPerSample = sc.bitsPerSample;
        this.validConfig = sc.validConfig;
    }

    public StreamConfiguration(int channelCount, int minBlock, int maxBlock, int sampleRate, int bitsPerSample) {
        this.validConfig = true;
        this.validConfig &= this.setChannelCount(channelCount);
        this.validConfig &= this.setSampleRate(sampleRate);
        this.validConfig &= this.setBitsPerSample(bitsPerSample);
        this.setMaxBlockSize(maxBlock);
        this.setMinBlockSize(minBlock);
    }

    public boolean isValid() {
        this.validConfig = true;
        this.setMinBlockSize(this.minBlockSize);
        this.setMaxBlockSize(this.maxBlockSize);
        this.validConfig &= this.minBlockSize <= this.maxBlockSize;
        this.validConfig &= this.setChannelCount(this.channelCount);
        this.validConfig &= this.setSampleRate(this.sampleRate);
        this.validConfig &= this.setBitsPerSample(this.bitsPerSample);
        return this.validConfig;
    }

    public boolean setChannelCount(int count) {
        boolean result = count > 0 && count <= 8;
        this.channelCount = count;
        return result;
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public int getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public int getMinBlockSize() {
        return this.minBlockSize;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public boolean setSampleRate(int rate) {
        boolean result = rate <= 655350 && rate >= 1;
        this.sampleRate = rate;
        return result;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public boolean setBitsPerSample(int bitsPerSample) {
        boolean result = bitsPerSample <= 24 && bitsPerSample >= 4;
        this.bitsPerSample = bitsPerSample;
        return result;
    }

    public int setMaxBlockSize(int size) {
        this.maxBlockSize = size <= 65535 ? size : 65535;
        this.maxBlockSize = this.maxBlockSize >= 16 ? this.maxBlockSize : 16;
        return this.maxBlockSize;
    }

    public int setMinBlockSize(int size) {
        this.minBlockSize = size <= 65535 ? size : 65535;
        this.minBlockSize = this.minBlockSize >= 16 ? this.maxBlockSize : 16;
        return this.minBlockSize;
    }

    public boolean isStreamSubsetCompliant() {
        boolean result = true;
        result &= this.maxBlockSize < 16384;
        if (this.sampleRate <= 48000) {
            result &= this.maxBlockSize < 4608;
        }
        switch (this.bitsPerSample) {
            case 8: 
            case 12: 
            case 16: 
            case 20: 
            case 24: {
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public boolean isEncodingSubsetCompliant(EncodingConfiguration ec) {
        boolean result = true;
        result = this.isStreamSubsetCompliant();
        if (this.sampleRate <= 48000) {
            result &= ec.maximumLPCOrder <= 12;
            result &= ec.maximumRicePartitionOrder <= 8;
        }
        return result;
    }
}

