/*
 * Decompiled with CFR 0.152.
 */
package javaFlacEncoder;

import javaFlacEncoder.EncodedElement;
import javaFlacEncoder.StreamConfiguration;

public class MetadataBlockStreamInfo {
    static int DEBUG_LEV = 0;

    public static EncodedElement getStreamInfo(StreamConfiguration sc, int minFrameSize, int maxFrameSize, long samplesInStream, byte[] md5Hash) {
        EncodedElement ele = new EncodedElement();
        int bytes = MetadataBlockStreamInfo.getByteSize();
        byte[] data = new byte[bytes];
        ele.setData(data);
        ele.setUsableBits(bytes * 8);
        int encodedBitsPerSample = sc.getBitsPerSample() - 1;
        int index = 0;
        EncodedElement.addInt(sc.getMinBlockSize(), 16, index, data);
        EncodedElement.addInt(sc.getMaxBlockSize(), 16, index += 16, data);
        EncodedElement.addInt(minFrameSize, 24, index += 16, data);
        EncodedElement.addInt(maxFrameSize, 24, index += 24, data);
        EncodedElement.addInt(sc.getSampleRate(), 20, index += 24, data);
        EncodedElement.addInt(sc.getChannelCount() - 1, 3, index += 20, data);
        EncodedElement.addInt(encodedBitsPerSample, 5, index += 3, data);
        EncodedElement.addLong(samplesInStream, 36, index += 5, data);
        index += 36;
        for (int i = 0; i < 16; ++i) {
            EncodedElement.addInt(md5Hash[i], 8, index, data);
            index += 8;
        }
        ele.setUsableBits(index);
        return ele;
    }

    public static int getByteSize() {
        int size = 0;
        size += 16;
        size += 16;
        size += 24;
        size += 24;
        size += 20;
        size += 3;
        size += 5;
        size += 36;
        size += 64;
        size += 64;
        return size /= 8;
    }
}

