/*
 * Decompiled with CFR 0.152.
 */
package javaFlacEncoder;

public class LPC {
    protected double rawError;
    protected double[] rawCoefficients;
    protected int order;

    public LPC(int order) {
        this.order = order;
        this.rawError = 0.0;
        this.rawCoefficients = null;
    }

    public int getOrder() {
        return this.order;
    }

    public double getError() {
        return this.rawError;
    }

    public double[] getCoefficients() {
        return this.rawCoefficients;
    }

    public static void calculate(LPC lpc, long[] R) {
        int coeffCount = lpc.order;
        double[] A = new double[coeffCount + 1];
        A[0] = 1.0;
        double E = R[0];
        if (R[0] == 0L) {
            for (int i = 0; i < coeffCount + 1; ++i) {
                A[i] = 0.0;
            }
        } else {
            double[] ATemp = new double[coeffCount + 1];
            for (int k = 0; k < coeffCount; ++k) {
                double lambda = 0.0;
                double temp = 0.0;
                for (int j = 0; j <= k; ++j) {
                    temp += A[j] * (double)R[k + 1 - j];
                }
                lambda = -temp / E;
                for (int i = 0; i <= k + 1; ++i) {
                    ATemp[i] = A[i] + lambda * A[k + 1 - i];
                }
                System.arraycopy(ATemp, 0, A, 0, coeffCount + 1);
                E = (1.0 - lambda * lambda) * E;
            }
        }
        lpc.rawCoefficients = A;
        lpc.rawError = E;
    }

    public static void calculateFromPrior(LPC lpc, long[] R, LPC priorLPC) {
        int coeffCount = lpc.order;
        double[] A = new double[coeffCount + 1];
        A[0] = 1.0;
        double E = R[0];
        int startIter = 0;
        if (priorLPC != null && priorLPC.order < lpc.order) {
            startIter = priorLPC.order;
            E = priorLPC.rawError;
            System.arraycopy(priorLPC.rawCoefficients, 0, A, 0, startIter + 1);
        }
        if (R[0] == 0L) {
            for (int i = 0; i < coeffCount + 1; ++i) {
                A[i] = 0.0;
            }
        } else {
            double[] ATemp = new double[coeffCount + 1];
            for (int k = startIter; k < coeffCount; ++k) {
                double lambda = 0.0;
                double temp = 0.0;
                for (int j = 0; j <= k; ++j) {
                    temp -= A[j] * (double)R[k - j + 1];
                }
                lambda = temp / E;
                for (int i = 0; i <= k + 1; ++i) {
                    ATemp[i] = A[i] + lambda * A[k + 1 - i];
                }
                System.arraycopy(ATemp, 0, A, 0, coeffCount + 1);
                E = (1.0 - lambda * lambda) * E;
            }
        }
        lpc.rawCoefficients = A;
        lpc.rawError = E;
    }

    public static void createAutoCorrelation(long[] R, int[] samples, int count, int start, int increment, int maxOrder) {
        if (increment == 1) {
            int i = 0;
            while (i <= maxOrder) {
                R[i] = 0L;
                long temp = 0L;
                int baseIndex = i;
                for (int j = 0; j < count - i; ++j) {
                    temp += (long)(samples[j] * samples[j + baseIndex]);
                }
                int n = i++;
                R[n] = R[n] + temp;
            }
        } else {
            int i = 0;
            while (i <= maxOrder) {
                R[i] = 0L;
                int baseIndex = increment * i;
                long temp = 0L;
                int innerLimit = (count - i) * increment;
                for (int j = start; j < innerLimit; j += increment) {
                    temp += (long)(samples[j] * samples[j + baseIndex]);
                }
                int n = i++;
                R[n] = R[n] + temp;
            }
        }
    }

    public static void window(int[] samples, int count, int start, int increment, int[] windowedSamples) {
        int[] values = windowedSamples;
        int loopCount = 0;
        float halfway = (float)count / 2.0f;
        float windowCount = -halfway;
        int limit = count * increment + start;
        for (int i = start; i < limit; i += increment) {
            float innerCount = windowCount < 0.0f ? -windowCount : windowCount;
            windowCount += 1.0f;
            float val = 1.0f - innerCount * innerCount / (halfway * halfway);
            double temp = (double)samples[i] * (double)val;
            temp = temp > 0.0 ? temp + 0.5 : temp - 0.5;
            values[loopCount++] = (int)temp;
        }
    }
}

