/*
 * Decompiled with CFR 0.152.
 */
package javaFlacEncoder;

import java.util.concurrent.locks.ReentrantLock;
import javaFlacEncoder.BlockEncodeRequest;
import javaFlacEncoder.BlockThreadManager2;
import javaFlacEncoder.Frame;

public class FrameThread2
implements Runnable {
    Frame frame = null;
    ReentrantLock runLock = null;
    BlockThreadManager2 manager = null;

    private FrameThread2() {
    }

    public FrameThread2(Frame f, BlockThreadManager2 manager) {
        if (f == null) {
            System.err.println("Frame is null. Error.");
        }
        this.frame = f;
        this.runLock = new ReentrantLock();
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean process = true;
        FrameThread2 frameThread2 = this;
        synchronized (frameThread2) {
            BlockEncodeRequest ber = this.manager.getWaitingRequest();
            if (ber != null && ber.frameNumber < 0L) {
                ber = null;
            }
            while (ber != null && process) {
                if (ber.frameNumber < 0L) {
                    process = false;
                    continue;
                }
                ber.encodedSamples = this.frame.encodeSamples(ber.samples, ber.count, ber.start, ber.skip, ber.result, ber.frameNumber);
                ber.valid = true;
                this.manager.returnFinishedRequest(ber);
                ber = this.manager.getWaitingRequest();
            }
            this.manager.notifyFrameThreadExit(this);
        }
    }
}

