/*
 * Decompiled with CFR 0.152.
 */
package javaFlacEncoder;

import javaFlacEncoder.CRC8;
import javaFlacEncoder.EncodedElement;
import javaFlacEncoder.EncodingConfiguration;
import javaFlacEncoder.UTF8Modified;

public class FrameHeader {
    public static int DEBUG_LEV = 0;
    private static final int[] definedBlockSizes = new int[]{-1, 192, 576, 1152, 2304, 4608, -1, -1, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768};
    private static final int[] definedSampleRates = new int[]{0, 88200, 176400, 192000, 8000, 16000, 22050, 24000, 32000, 44100, 48000, 96000, -1, -1, -1, -1};
    public static final int MAX_HEADER_SIZE = 128;
    public static final short syncCode = 16382;
    static final byte reserved = 0;
    byte blockingStrategy = 0;
    byte blockSize = (byte)12;
    byte sampleRate = (byte)4;
    byte sampleSize = (byte)4;
    static final byte reserved2 = 0;
    long frameNumber = 0L;
    int blockSizeMod = 0;
    int SampleRateMod = 0;
    byte crc8 = 0;
    CRC8 crcCalculator = new CRC8();

    public EncodedElement createHeader(boolean fixBlock, int blockSize, int sampleRate, EncodingConfiguration.ChannelConfig channelAssign, int sampleSize, long frameNumber, int channelCount) {
        int i;
        byte encodedSampleRate;
        int start;
        if (DEBUG_LEV > 0) {
            System.err.println("FrameHeader::createHeader : Begin");
        }
        EncodedElement result = new EncodedElement();
        boolean useEndBlockSize = false;
        boolean useEndSampleRate = false;
        byte[] data = new byte[128];
        int nextPos = start = 0;
        int blockingStrat = fixBlock ? 0 : 1;
        byte[] encodedFrameNumber = UTF8Modified.convertToExtendedUTF8(frameNumber);
        byte encodedBlockSize = FrameHeader.encodeBlockSize(blockSize);
        if (encodedBlockSize == 6 || encodedBlockSize == 7) {
            useEndBlockSize = true;
        }
        if ((encodedSampleRate = FrameHeader.encodeSampleRate(sampleRate)) >= 12 && encodedSampleRate <= 14) {
            useEndSampleRate = true;
        }
        int channelAssignment = 0;
        if (channelAssign == EncodingConfiguration.ChannelConfig.INDEPENDENT) {
            channelAssignment = channelCount - 1;
        } else if (channelAssign == EncodingConfiguration.ChannelConfig.LEFT_SIDE) {
            channelAssignment = 8;
        } else if (channelAssign == EncodingConfiguration.ChannelConfig.RIGHT_SIDE) {
            channelAssignment = 9;
        } else if (channelAssign == EncodingConfiguration.ChannelConfig.MID_SIDE) {
            channelAssignment = 10;
        }
        int encodedSampleSize = 0;
        switch (sampleSize) {
            case 8: {
                encodedSampleSize = 1;
                break;
            }
            case 12: {
                encodedSampleSize = 2;
                break;
            }
            case 16: {
                encodedSampleSize = 4;
                break;
            }
            case 20: {
                encodedSampleSize = 5;
                break;
            }
            case 24: {
                encodedSampleSize = 6;
                break;
            }
            default: {
                encodedSampleSize = 0;
            }
        }
        EncodedElement.addInt(16382, 14, nextPos, data);
        EncodedElement.addInt(0, 1, nextPos += 14, data);
        EncodedElement.addInt(blockingStrat, 1, ++nextPos, data);
        EncodedElement.addInt(encodedBlockSize, 4, ++nextPos, data);
        EncodedElement.addInt(encodedSampleRate, 4, nextPos += 4, data);
        EncodedElement.addInt(channelAssignment, 4, nextPos += 4, data);
        EncodedElement.addInt(encodedSampleSize, 3, nextPos += 4, data);
        EncodedElement.addInt(0, 1, nextPos += 3, data);
        ++nextPos;
        for (i = 0; i < encodedFrameNumber.length; ++i) {
            EncodedElement.addLong(encodedFrameNumber[i], 8, nextPos, data);
            nextPos += 8;
        }
        if (useEndBlockSize) {
            if (encodedBlockSize == 6) {
                EncodedElement.addInt(blockSize - 1, 8, nextPos, data);
                nextPos += 8;
            } else {
                EncodedElement.addInt(blockSize - 1, 16, nextPos, data);
                nextPos += 16;
            }
        }
        if (useEndSampleRate) {
            switch (encodedSampleRate) {
                case 12: {
                    EncodedElement.addInt(sampleRate / 1000, 8, nextPos, data);
                    nextPos += 8;
                    break;
                }
                case 13: {
                    EncodedElement.addInt(sampleRate, 16, nextPos, data);
                    nextPos += 16;
                    break;
                }
                case 14: {
                    EncodedElement.addInt(sampleRate / 10, 16, nextPos, data);
                    nextPos += 16;
                }
            }
        }
        if (DEBUG_LEV > 20) {
            System.err.println("FrameHeader::createHeader : pre-CRC");
        }
        this.crcCalculator.reset();
        this.crcCalculator.updateCRC8(data, 0, nextPos / 8);
        this.crc8 = this.crcCalculator.checksum();
        if (DEBUG_LEV > 20) {
            System.err.println("FrameHeader::createHeader : post-CRC");
        }
        if (DEBUG_LEV > 50) {
            System.err.println("Checksum : " + this.crc8);
            for (i = 0; i < nextPos / 8; ++i) {
                System.err.print(data[i] + ":");
            }
        }
        EncodedElement.addInt(this.crc8, 8, nextPos, data);
        result.setUsableBits(nextPos += 8);
        result.setData(data);
        if (DEBUG_LEV > 0) {
            System.err.println("FrameHeader::createHeader : End");
        }
        return result;
    }

    private static byte encodeBlockSize(int blockSize) {
        int i;
        if (DEBUG_LEV > 0) {
            System.err.println("FrameHeader::encodeBlockSize : Begin");
        }
        byte value = 0;
        for (i = 0; i < definedBlockSizes.length; ++i) {
            if (blockSize != definedBlockSizes[i]) continue;
            value = (byte)i;
            break;
        }
        if (i >= definedBlockSizes.length) {
            value = blockSize <= 255 ? (byte)6 : (byte)7;
        }
        if (DEBUG_LEV > 0) {
            System.err.println("FrameHeader::encodeBlockSize : End");
        }
        return value;
    }

    private static byte encodeSampleRate(int sampleRate) {
        int i;
        if (DEBUG_LEV > 0) {
            System.err.println("FrameHeader::encodeSampleRate : Begin");
        }
        byte value = 0;
        for (i = 0; i < definedSampleRates.length; ++i) {
            if (sampleRate != definedSampleRates[i]) continue;
            value = (byte)i;
            break;
        }
        if (i >= definedSampleRates.length) {
            value = sampleRate % 1000 == 0 && sampleRate < 256000 ? (byte)12 : (sampleRate < 65536 ? (byte)13 : (sampleRate % 10 == 0 && sampleRate <= 655350 ? (byte)14 : (byte)0));
        }
        if (DEBUG_LEV > 0) {
            System.err.println("FrameHeader::encodeSampleRate : End");
        }
        return value;
    }
}

