/*
 * Decompiled with CFR 0.152.
 */
package javaFlacEncoder;

import javaFlacEncoder.CRC16;
import javaFlacEncoder.EncodedElement;
import javaFlacEncoder.EncodingConfiguration;
import javaFlacEncoder.FrameHeader;
import javaFlacEncoder.StreamConfiguration;
import javaFlacEncoder.Subframe;
import javaFlacEncoder.Subframe_Constant;
import javaFlacEncoder.Subframe_Fixed;
import javaFlacEncoder.Subframe_LPC;
import javaFlacEncoder.Subframe_Verbatim;

public class Frame {
    public static int DEBUG_LEV = 0;
    private int lastEncodeSize;
    EncodingConfiguration ec;
    StreamConfiguration sc;
    int channels;
    int bitsPerSample;
    FrameHeader frameHeader;
    CRC16 crc16;
    Subframe verbatimSubframe;
    Subframe fixedSubframe;
    Subframe lpcSubframe;
    Subframe constantSubframe;
    boolean testConstant;

    private Frame() {
    }

    public Frame(StreamConfiguration sc) {
        this.lastEncodeSize = 0;
        this.channels = sc.getChannelCount();
        this.sc = sc;
        this.frameHeader = new FrameHeader();
        this.crc16 = new CRC16();
        this.ec = null;
        this.verbatimSubframe = new Subframe_Verbatim(sc);
        this.fixedSubframe = new Subframe_Fixed(sc);
        this.lpcSubframe = new Subframe_LPC(sc);
        this.constantSubframe = new Subframe_Constant(sc);
        this.bitsPerSample = sc.getBitsPerSample();
        this.testConstant = true;
        this.registerConfiguration(new EncodingConfiguration());
    }

    boolean registerConfiguration(EncodingConfiguration ec) {
        boolean changed = false;
        if (this.sc.getChannelCount() != 2) {
            ec.setChannelConfig(EncodingConfiguration.ChannelConfig.INDEPENDENT);
        }
        this.ec = new EncodingConfiguration(ec);
        this.verbatimSubframe.registerConfiguration(this.ec);
        this.fixedSubframe.registerConfiguration(this.ec);
        this.lpcSubframe.registerConfiguration(this.ec);
        this.constantSubframe.registerConfiguration(this.ec);
        changed = true;
        return changed;
    }

    int encodeSamples(int[] samples, int count, int start, int skip, EncodedElement result, long frameNumber) {
        if (DEBUG_LEV > 0) {
            System.err.println("FRAME::encodeSamples(...)");
            if (DEBUG_LEV > 10) {
                System.err.println("\tsamples.length:" + samples.length + ":count:" + count + ":start:" + start + ":skip:" + skip + ":frameNumber:" + frameNumber);
            }
        }
        int samplesEncoded = count;
        this.testConstant = true;
        EncodedElement data = null;
        EncodingConfiguration.ChannelConfig chConf = this.ec.getChannelConfig();
        if (chConf == EncodingConfiguration.ChannelConfig.INDEPENDENT) {
            data = new EncodedElement();
            int size = this.encodeIndependent(samples, count, start, skip, data, 0);
        } else if (chConf == EncodingConfiguration.ChannelConfig.LEFT_SIDE) {
            data = new EncodedElement();
            int size = this.encodeLeftSide(samples, count, start, skip, data, 0);
        } else if (chConf == EncodingConfiguration.ChannelConfig.MID_SIDE) {
            data = new EncodedElement();
            int size = Frame.encodeMidSide(samples, count, start, skip, data, 0, this);
        } else if (chConf == EncodingConfiguration.ChannelConfig.RIGHT_SIDE) {
            data = new EncodedElement();
            int size = this.encodeRightSide(samples, count, start, skip, data, 0);
        } else if (chConf == EncodingConfiguration.ChannelConfig.ENCODER_CHOICE) {
            data = new EncodedElement();
            int size = Frame.allChannelDecorrelation(samples, count, start, skip, data, 0, this);
            chConf = this.ec.channelConfig;
            this.ec.channelConfig = EncodingConfiguration.ChannelConfig.ENCODER_CHOICE;
        } else if (chConf == EncodingConfiguration.ChannelConfig.EXHAUSTIVE) {
            EncodedElement dataLeftSide = new EncodedElement();
            this.ec.channelConfig = EncodingConfiguration.ChannelConfig.LEFT_SIDE;
            int sizeLeft = this.encodeLeftSide(samples, count, start, skip, dataLeftSide, 0);
            this.ec.channelConfig = EncodingConfiguration.ChannelConfig.MID_SIDE;
            EncodedElement dataMidSide = new EncodedElement();
            int sizeMid = Frame.encodeMidSide(samples, count, start, skip, dataMidSide, 0, this);
            this.ec.channelConfig = EncodingConfiguration.ChannelConfig.INDEPENDENT;
            EncodedElement dataIndependent = new EncodedElement();
            int sizeInd = this.encodeIndependent(samples, count, start, skip, dataIndependent, 0);
            this.ec.channelConfig = chConf;
            if (sizeLeft <= sizeMid && sizeLeft <= sizeInd) {
                data = dataLeftSide;
                chConf = EncodingConfiguration.ChannelConfig.LEFT_SIDE;
            } else if (sizeMid <= sizeInd) {
                data = dataMidSide;
                chConf = EncodingConfiguration.ChannelConfig.MID_SIDE;
            } else {
                data = dataIndependent;
                chConf = EncodingConfiguration.ChannelConfig.INDEPENDENT;
            }
        }
        EncodedElement header = this.frameHeader.createHeader(true, count, this.sc.getSampleRate(), chConf, this.sc.getBitsPerSample(), frameNumber, this.channels);
        result.setNext(header);
        header.attachEnd(data);
        data.padToByte();
        EncodedElement crc16Ele = this.getCRC16(header);
        data.attachEnd(crc16Ele);
        if (DEBUG_LEV > 0) {
            System.err.println("Frame::encodeSamples(...): End");
        }
        return samplesEncoded;
    }

    EncodedElement getCRC16(EncodedElement header) {
        EncodedElement crc16Ele = new EncodedElement(2, 0);
        short val = CRC16.getCRC16(header, this.crc16);
        crc16Ele.addInt(val, 16);
        return crc16Ele;
    }

    EncodedElement getCRC16OldWorking(EncodedElement header) {
        if (DEBUG_LEV > 0) {
            System.err.println("Frame::getCRC16 : Begin");
        }
        EncodedElement crc16Ele = new EncodedElement();
        this.crc16.reset();
        byte[] crc16Data = new byte[2];
        int offset = 0;
        int currentByte = 0;
        byte[] unfullByte = new byte[]{0};
        byte[] eleData = null;
        int usableBits = 0;
        int lastByte = 0;
        for (EncodedElement current = header; current != null; current = current.getNext()) {
            eleData = current.getData();
            usableBits = current.getUsableBits();
            currentByte = 0;
            if (offset != 0) {
                unfullByte[0] = (byte)(unfullByte[0] | eleData[currentByte++]);
                CRC16.updateCRC16(unfullByte, 0, 1, this.crc16);
            }
            lastByte = usableBits / 8;
            CRC16.updateCRC16(eleData, currentByte, lastByte, this.crc16);
            offset = usableBits % 8;
            if (offset == 0) continue;
            unfullByte[0] = eleData[lastByte];
        }
        if (offset > 0) {
            System.err.println("ERROR: frame was not properly bit padded");
            System.exit(0);
        }
        short crc16Val = this.crc16.checksum();
        EncodedElement.addInt(crc16Val, 16, 0, crc16Data);
        crc16Ele.setData(crc16Data);
        crc16Ele.setUsableBits(16);
        if (DEBUG_LEV > 0) {
            if (DEBUG_LEV > 10) {
                System.err.println("Frame::getCRC16: crc16 : " + Integer.toHexString(crc16Val));
            }
            System.err.println("Frame::getCRC16 : End");
        }
        return crc16Ele;
    }

    int encodeIndependent(int[] samples, int count, int start, int skip, EncodedElement result, int offset) {
        int i;
        if (DEBUG_LEV > 0) {
            System.err.println("Frame::encodeIndependent : Begin");
            System.err.println("start:skip:offset::" + start + ":" + skip + ":" + offset);
        }
        int totalSize = 0;
        int channelLength = 0;
        int channelCount = skip + 1;
        int inputOffset = offset;
        EncodedElement[] subframes = new EncodedElement[channelCount];
        EncodingConfiguration.ChannelConfig chConf = this.ec.channelConfig;
        for (i = 0; i < channelCount; ++i) {
            int channelBitsPerSample = this.bitsPerSample;
            if (i == 1 && chConf == EncodingConfiguration.ChannelConfig.LEFT_SIDE) {
                ++channelBitsPerSample;
            } else if (i == 1 && chConf == EncodingConfiguration.ChannelConfig.MID_SIDE) {
                ++channelBitsPerSample;
            } else if (i == 0 && chConf == EncodingConfiguration.ChannelConfig.RIGHT_SIDE) {
                ++channelBitsPerSample;
            }
            subframes[i] = new EncodedElement();
            channelLength = this.encodeChannel(samples, count, start + i, skip, offset, subframes[i], channelBitsPerSample);
            offset = (inputOffset + (totalSize += channelLength)) % 8;
        }
        result.attachEnd(subframes[0]);
        for (i = 1; i < channelCount; ++i) {
            subframes[i - 1].attachEnd(subframes[i]);
        }
        if (DEBUG_LEV > 0) {
            System.err.println("Frame::encodeIndependent : End");
        }
        return totalSize;
    }

    int encodeChannel(int[] samples, int count, int start, int skip, int offset, EncodedElement data, int channelBitsPerSample) {
        if (DEBUG_LEV > 0) {
            System.err.println("Frame::encodeChannel : Begin");
        }
        int size = 0;
        EncodingConfiguration.SubframeType subframeType = this.ec.getSubframeType();
        if (subframeType == EncodingConfiguration.SubframeType.VERBATIM) {
            this.verbatimSubframe.encodeSamples(samples, count, start, skip, data, offset, channelBitsPerSample);
            size = this.verbatimSubframe.getEncodedSize();
        } else if (subframeType == EncodingConfiguration.SubframeType.FIXED) {
            this.fixedSubframe.encodeSamples(samples, count, start, skip, data, offset, channelBitsPerSample);
            size = this.fixedSubframe.getEncodedSize();
        } else if (subframeType == EncodingConfiguration.SubframeType.LPC) {
            this.lpcSubframe.encodeSamples(samples, count, start, skip, data, offset, channelBitsPerSample);
            size = this.lpcSubframe.getEncodedSize();
        } else if (subframeType == EncodingConfiguration.SubframeType.EXHAUSTIVE) {
            int conCount = -1;
            if (this.testConstant) {
                conCount = this.constantSubframe.encodeSamples(samples, count, start, skip, data, offset, channelBitsPerSample);
            }
            if (conCount == count) {
                size = this.constantSubframe.getEncodedSize();
            } else {
                ((Subframe_Fixed)this.fixedSubframe).encodeSamples(samples, count, start, skip, offset, channelBitsPerSample);
                int fixedSize = ((Subframe_Fixed)this.fixedSubframe).estimatedSize();
                ((Subframe_LPC)this.lpcSubframe).encodeSamples(samples, count, start, skip, offset, channelBitsPerSample);
                int lpcSize = (int)((Subframe_LPC)this.lpcSubframe).estimatedSize();
                if (lpcSize < fixedSize) {
                    EncodedElement lpcEle = ((Subframe_LPC)this.lpcSubframe).getData();
                    data.data = lpcEle.data;
                    data.next = lpcEle.next;
                    data.usableBits = lpcEle.usableBits;
                    data.offset = lpcEle.offset;
                    size = this.lpcSubframe.getEncodedSize();
                    if (size > lpcSize) {
                        System.err.println("Lpc size wrong: exp:real : " + lpcSize + ":" + size);
                    }
                } else {
                    EncodedElement fixEle = ((Subframe_Fixed)this.fixedSubframe).getData();
                    size = fixedSize;
                    data.data = fixEle.data;
                    data.next = fixEle.next;
                    data.usableBits = fixEle.usableBits;
                    data.offset = fixEle.offset;
                    size = this.fixedSubframe.getEncodedSize();
                    if (size > fixedSize) {
                        System.err.println("Fixed size wrong: exp:real : " + fixedSize + ":" + size);
                    }
                }
            }
        }
        if (DEBUG_LEV > 0) {
            System.err.println("Frame::encodeChannel : End");
        }
        return size;
    }

    int getEncodedSize() {
        if (DEBUG_LEV > 0) {
            System.err.println("Frame::getEncodedSize : Begin");
        }
        return this.lastEncodeSize;
    }

    private int encodeRightSide(int[] samples, int count, int start, int skip, EncodedElement data, int offset) {
        int[] rightSide = new int[samples.length];
        for (int i = 0; i < count; ++i) {
            rightSide[2 * i] = samples[2 * i] - samples[2 * i + 1];
            rightSide[2 * i + 1] = samples[2 * i + 1];
        }
        return this.encodeIndependent(rightSide, count, start, skip, data, offset);
    }

    private int encodeLeftSide(int[] samples, int count, int start, int skip, EncodedElement data, int offset) {
        int[] leftSide = new int[samples.length];
        for (int i = 0; i < count; ++i) {
            leftSide[2 * i] = samples[2 * i];
            leftSide[2 * i + 1] = samples[2 * i] - samples[2 * i + 1];
        }
        return this.encodeIndependent(leftSide, count, start, skip, data, offset);
    }

    private static int encodeMidSide(int[] samples, int count, int start, int skip, EncodedElement data, int offset, Frame f) {
        int[] midSide = new int[samples.length];
        for (int i = 0; i < count; ++i) {
            int temp;
            midSide[2 * i] = temp = samples[2 * i] + samples[2 * i + 1] >> 1;
            midSide[2 * i + 1] = samples[2 * i] - samples[2 * i + 1];
        }
        return f.encodeIndependent(midSide, count, start, skip, data, offset);
    }

    private static double getVariance(double mean, int[] samples, int count, int start, int increment) {
        double var = 0.0;
        for (int i = 0; i < count; ++i) {
            int loc = start + i * increment;
            double val = mean - (double)samples[loc];
            var += val * val;
        }
        return var;
    }

    private static int allChannelDecorrelation(int[] samples, int count, int start, int skip, EncodedElement data, int offset, Frame f) {
        int i;
        int i2;
        if (DEBUG_LEV > 0) {
            System.err.println("Frame::allChannelDecorrelation(...)");
        }
        long sums0 = 0L;
        long sums1 = 0L;
        long sums2 = 0L;
        long sums3 = 0L;
        boolean[] constantCandidate = new boolean[4];
        for (int i3 = 0; i3 < 4; ++i3) {
            constantCandidate[i3] = false;
        }
        int[] midSideSamples = new int[samples.length];
        int index = 0;
        for (i2 = 0; i2 < count; ++i2) {
            int temp;
            midSideSamples[index] = temp = samples[index] + samples[index + 1] >> 1;
            midSideSamples[index + 1] = samples[index] - samples[index + 1];
            index += 2;
        }
        index = 0;
        for (i2 = 0; i2 < count; ++i2) {
            long temp = samples[index];
            if (temp < 0L) {
                temp = -temp;
            }
            sums0 += temp;
            temp = samples[index + 1];
            if (temp < 0L) {
                temp = -temp;
            }
            sums1 += temp;
            temp = midSideSamples[index];
            if (temp < 0L) {
                temp = -temp;
            }
            sums2 += temp;
            temp = midSideSamples[index + 1];
            if (temp < 0L) {
                temp = -temp;
            }
            sums3 += temp;
            index += 2;
        }
        constantCandidate[0] = (long)samples[0] == (sums0 /= (long)count);
        constantCandidate[1] = (long)samples[1] == (sums1 /= (long)count);
        constantCandidate[2] = (long)midSideSamples[2] == (sums2 /= (long)count);
        constantCandidate[3] = (long)midSideSamples[3] == (sums3 /= (long)count);
        long[] results = new long[]{sums0 + sums1, sums2 + sums3, sums0 + sums3, sums3 + sums1};
        int choice = 0;
        for (i = 0; i < 4; ++i) {
            if (results[choice] <= results[i]) continue;
            choice = i;
        }
        if (choice == 0) {
            f.testConstant = constantCandidate[0] || constantCandidate[1];
            f.ec.channelConfig = EncodingConfiguration.ChannelConfig.INDEPENDENT;
            return f.encodeIndependent(samples, count, start, skip, data, offset);
        }
        if (choice == 1) {
            f.testConstant = constantCandidate[2] || constantCandidate[3];
            f.ec.channelConfig = EncodingConfiguration.ChannelConfig.MID_SIDE;
            return f.encodeIndependent(midSideSamples, count, start, skip, data, offset);
        }
        if (choice == 2) {
            f.testConstant = constantCandidate[0] || constantCandidate[3];
            f.ec.channelConfig = EncodingConfiguration.ChannelConfig.LEFT_SIDE;
            for (i = 0; i < count; ++i) {
                midSideSamples[2 * i] = samples[2 * i];
            }
            return f.encodeIndependent(midSideSamples, count, start, skip, data, offset);
        }
        f.testConstant = constantCandidate[1] || constantCandidate[3];
        f.ec.channelConfig = EncodingConfiguration.ChannelConfig.RIGHT_SIDE;
        for (i = 0; i < count; ++i) {
            midSideSamples[2 * i] = midSideSamples[2 * i + 1];
            midSideSamples[2 * i + 1] = samples[2 * i + 1];
        }
        return f.encodeIndependent(midSideSamples, count, start, skip, data, offset);
    }
}

