/*
 * Decompiled with CFR 0.152.
 */
package javaFlacEncoder;

import java.io.File;
import java.io.IOException;
import javaFlacEncoder.EncodingConfiguration;
import javaFlacEncoder.FLACEncoder;
import javaFlacEncoder.FLACFileOutputStream;
import javaFlacEncoder.StreamConfiguration;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class FLAC_FileEncoder {
    private static final int MAX_READ = 16384;
    FLACEncoder flac = new FLACEncoder();
    StreamConfiguration sc = new StreamConfiguration();
    EncodingConfiguration ec = new EncodingConfiguration();
    File outFile = null;
    int lastTotalSamples = 0;
    boolean useThreads = true;

    public void useThreads(boolean val) {
        this.useThreads = val;
    }

    private void adjustConfigurations(AudioFormat format) {
        int sampleRate = (int)format.getSampleRate();
        int sampleSize = format.getSampleSizeInBits();
        int channels = format.getChannels();
        this.sc.setSampleRate(sampleRate);
        this.sc.setBitsPerSample(sampleSize);
        this.sc.setChannelCount(channels);
    }

    public void setStreamConfig(StreamConfiguration config) {
        this.sc = config;
    }

    public void setEncodingConfig(EncodingConfiguration config) {
        this.ec = config;
    }

    private Status openStream() {
        Status status = Status.OK;
        boolean result = this.flac.setStreamConfiguration(this.sc);
        if (!(result &= this.flac.setEncodingConfiguration(this.ec))) {
            status = Status.INTERNAL_ERROR;
        } else {
            FLACFileOutputStream fout = new FLACFileOutputStream(this.outFile.getPath());
            if (fout.isValid()) {
                this.flac.setOutputStream(fout);
                try {
                    this.flac.openFLACStream();
                }
                catch (IOException e) {
                    status = Status.INTERNAL_ERROR;
                }
            } else {
                status = Status.OUTPUT_FILE_ERROR;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status encode(File inputFile, File outputFile) {
        Status status;
        block21: {
            AudioFormat format;
            AudioInputStream sin;
            block20: {
                status = Status.FULL_ENCODE;
                this.outFile = outputFile;
                sin = null;
                format = null;
                try {
                    sin = AudioSystem.getAudioInputStream(inputFile);
                }
                catch (IOException e) {
                    status = Status.FILE_IO_ERROR;
                    return status;
                }
                catch (UnsupportedAudioFileException e) {
                    status = Status.UNSUPPORTED_FILE;
                    return status;
                }
                finally {
                    if (status == Status.FULL_ENCODE) break block20;
                    return status;
                }
            }
            try {
                int samplesRead;
                format = sin.getFormat();
                this.adjustConfigurations(format);
                this.openStream();
                int frameSize = format.getFrameSize();
                int sampleSize = format.getSampleSizeInBits();
                int bytesPerSample = sampleSize / 8;
                if (sampleSize % 8 != 0) {
                    Exception newEx = new Exception(Status.UNSUPPORTED_SAMPLE_SIZE.name());
                    throw newEx;
                }
                int channels = format.getChannels();
                boolean bigEndian = format.isBigEndian();
                byte[] samplesIn = new byte[16384];
                int[] sampleData = new int[16384 * channels / frameSize];
                int blockSize = this.sc.getMaxBlockSize();
                int unencodedSamples = 0;
                int totalSamples = 0;
                while ((samplesRead = sin.read(samplesIn, 0, 16384)) != -1) {
                    int upShift;
                    int x;
                    int totalTemp;
                    int temp;
                    int lower8Mask;
                    int i;
                    int framesRead = samplesRead / frameSize;
                    if (bigEndian) {
                        for (i = 0; i < framesRead * channels; ++i) {
                            lower8Mask = 255;
                            temp = 0;
                            totalTemp = 0;
                            for (x = bytesPerSample - 1; x >= 0; ++x) {
                                upShift = 8 * x;
                                temp = x == 0 ? samplesIn[bytesPerSample * i + x] << upShift : (samplesIn[bytesPerSample * i + x] & lower8Mask) << upShift;
                                totalTemp |= temp;
                            }
                            sampleData[i] = totalTemp;
                        }
                    } else {
                        for (i = 0; i < framesRead * channels; ++i) {
                            lower8Mask = 255;
                            temp = 0;
                            totalTemp = 0;
                            for (x = 0; x < bytesPerSample; ++x) {
                                upShift = 8 * x;
                                temp = x == bytesPerSample - 1 ? samplesIn[bytesPerSample * i + x] << upShift : (samplesIn[bytesPerSample * i + x] & lower8Mask) << upShift;
                                totalTemp |= temp;
                            }
                            sampleData[i] = totalTemp;
                        }
                    }
                    if (framesRead > 0) {
                        this.flac.addSamples(sampleData, framesRead);
                        unencodedSamples += framesRead;
                    }
                    unencodedSamples = this.useThreads ? (unencodedSamples -= this.flac.t_encodeSamples(unencodedSamples, false)) : (unencodedSamples -= this.flac.encodeSamples(unencodedSamples, false));
                    totalSamples += unencodedSamples;
                }
                totalSamples += unencodedSamples;
                unencodedSamples = this.useThreads ? (unencodedSamples -= this.flac.t_encodeSamples(unencodedSamples, true)) : (unencodedSamples -= this.flac.encodeSamples(unencodedSamples, true));
                this.lastTotalSamples = totalSamples;
            }
            catch (IOException e) {
                status = Status.FILE_IO_ERROR;
            }
            catch (Exception e) {
                status = Status.GENERAL_ERROR;
                String message = e.getMessage();
                if (message == null) {
                    e.printStackTrace();
                }
                if (!message.equals(Status.UNSUPPORTED_SAMPLE_SIZE.name())) break block21;
                status = Status.UNSUPPORTED_SAMPLE_SIZE;
            }
        }
        return status;
    }

    public int getLastTotalSamplesEncoded() {
        return this.lastTotalSamples;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        UNKNOWN,
        FULL_ENCODE,
        GENERAL_ERROR,
        INTERNAL_ERROR,
        UNSUPPORTED_FILE,
        FILE_IO_ERROR,
        UNSUPPORTED_SAMPLE_SIZE,
        OUTPUT_FILE_ERROR,
        OK;

    }
}

