/*
 * Decompiled with CFR 0.152.
 */
package javaFlacEncoder;

import java.io.File;
import java.io.IOException;
import javaFlacEncoder.EncodingConfiguration;
import javaFlacEncoder.FLAC_FileEncoder;
import javaFlacEncoder.StreamConfiguration;

public class FLAC_ConsoleFileEncoder {
    public static String HELP = "-h";
    public static String MIN_BLOCK = "-bmin";
    public static String MAX_BLOCK = "-bmax";
    public static String MIN_LPC = "-lpcmin";
    public static String MAX_LPC = "-lpcmax";
    public static String THREADS = "-Threads";
    public static String SUBFRAME_TYPE = "-sf";
    public static String TYPE_LPC = "lpc";
    public static String TYPE_FIXED = "fixed";
    public static String TYPE_EXHAUSTIVE = "exhaustive";
    public static String TYPE_VERBATIM = "verbatim";
    public static final String MIN_BLOCK_ERROR = "Error with minimum block size: integer value between 16 & 65535 must follow \"" + MIN_BLOCK + "\"";
    public static final String MAX_BLOCK_ERROR = "Error with maximum block size: integer value between 16 & 65535 must follow \"" + MIN_BLOCK + "\"";
    public static final String MIN_LPC_ERROR = "MIN_LPC ERROR";
    public static final String MAX_LPC_ERROR = "MAX_LPC Error";
    public static final String THREADS_ERROR = "Error setting threads: \"" + THREADS + "\" must be followed by an integer(max number of EXTRA" + " threads to use)";
    private File inputFile = null;
    private File outputFile = null;
    private boolean canEncode = false;
    private boolean useThreads = true;
    int threadCount = 2;
    EncodingConfiguration encodingConfig;
    StreamConfiguration streamConfig;
    private boolean attemptEncode = true;

    public static void main(String[] args) {
        FLAC_ConsoleFileEncoder cfe = new FLAC_ConsoleFileEncoder(args);
    }

    public FLAC_ConsoleFileEncoder(String[] args) {
        boolean valid = this.handleArguments(args);
        if (this.attemptEncode) {
            this.printSmallCopyright();
        }
        FLAC_FileEncoder enc = new FLAC_FileEncoder();
        enc.setStreamConfig(this.streamConfig);
        enc.setEncodingConfig(this.encodingConfig);
        enc.useThreads(this.useThreads);
        FLAC_FileEncoder.Status st = FLAC_FileEncoder.Status.UNKNOWN;
        if (this.inputFile != null && this.outputFile != null && this.attemptEncode) {
            st = enc.encode(this.inputFile, this.outputFile);
        } else if (this.inputFile == null && this.attemptEncode) {
            System.err.println("error: inputFile not given or an error occured");
            this.attemptEncode = false;
        } else if (this.attemptEncode) {
            System.err.println(this.inputFile.getName());
            System.err.println("error: outputFile not given or an error occured");
            this.attemptEncode = false;
        }
        if (this.attemptEncode) {
            System.err.println("Status: " + st.toString());
        }
    }

    private void printSmallCopyright() {
        String message = "javaFlacEncoder Copyright (C) 2010  Preston Lacey\njavaFlacEncoder comes with ABSOLUTELY NO WARRANTY. This is free software,\nyou may redistribute it under the terms of the Lesser GPL. For more details\nor usage help, use option \"-h\"\n\n";
        System.out.println(message);
    }

    private void printCopyright() {
        String copyrightNotice = "Copyright (C) 2010  Preston Lacey\nAll Rights Reserved.\n\nThis library is free software; you can redistribute it and/or\nmodify it under the terms of the GNU Lesser General Public\nLicense as published by the Free Software Foundation; either\nversion 2.1 of the License, or (at your option) any later version.\n\nThis library is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\nLesser General Public License for more details.\n\nYou should have received a copy of the GNU Lesser General Public\nLicense along with this library; if not, write to the Free Software\nFoundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301\nUSA\n";
        System.out.println(copyrightNotice);
    }

    private void printVersion() {
    }

    private void printUsage() {
        this.printCopyright();
        String output = "Usage:\n  <commandName> [options] inputFilename outputFilename\noptions:\n  -bmin <x>     minimum block size, where <x> is an integer in range (16-65535)\n  -bmax <x>     maximum block size, where <x> is an integer in range (16-65535)\n  -lpcmin <x>   minimum LPC order, where <x> is an integer in range (1-32)\n  -lpcmax <x>   maximum LPC order, where <x> is an integer in range (1-32)\n  -Threads <x>  Specify whether to use threads. 0 turns threading off, greater\n                than 0 turns threading on\n  -sf <type>    Specify which subframe type to use, where <type> may be:\n      exhaustive(this is default and recommended)\n      fixed\n      lpc\n      verbatim";
        System.err.println(output);
    }

    private boolean handleArguments(String[] args) {
        boolean valid = true;
        this.encodingConfig = new EncodingConfiguration();
        this.streamConfig = new StreamConfiguration();
        int intArg = -1;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(MIN_BLOCK)) {
                if (valid &= (intArg = this.getInt(args, ++i)) >= 0) {
                    this.streamConfig.setMinBlockSize(intArg);
                } else {
                    System.err.println(MIN_BLOCK_ERROR);
                }
            } else if (args[i].equals(MAX_BLOCK)) {
                if (valid &= (intArg = this.getInt(args, ++i)) >= 0) {
                    this.streamConfig.setMaxBlockSize(intArg);
                } else {
                    System.err.println(MAX_BLOCK_ERROR);
                }
            } else if (args[i].equals(MIN_LPC)) {
                if (valid &= (intArg = this.getInt(args, ++i)) >= 0) {
                    this.encodingConfig.setMinLPCOrder(intArg);
                } else {
                    System.err.println(MIN_LPC_ERROR);
                }
            } else if (args[i].equals(MAX_LPC)) {
                if (valid &= (intArg = this.getInt(args, ++i)) >= 0) {
                    this.encodingConfig.setMaxLPCOrder(intArg);
                } else {
                    System.err.println(MAX_LPC_ERROR);
                }
            } else if (args[i].equals(SUBFRAME_TYPE)) {
                String type = ++i < args.length ? args[i] : "";
                EncodingConfiguration.SubframeType subType = EncodingConfiguration.SubframeType.EXHAUSTIVE;
                if (type.equals(TYPE_LPC)) {
                    subType = EncodingConfiguration.SubframeType.LPC;
                } else if (type.equals(TYPE_FIXED)) {
                    subType = EncodingConfiguration.SubframeType.FIXED;
                } else if (type.equals(TYPE_EXHAUSTIVE)) {
                    subType = EncodingConfiguration.SubframeType.EXHAUSTIVE;
                } else if (type.equals(TYPE_VERBATIM)) {
                    subType = EncodingConfiguration.SubframeType.VERBATIM;
                } else {
                    valid = false;
                    System.err.println("Incorrect subframe type");
                }
                this.encodingConfig.setSubframeType(subType);
            } else if (args[i].equals(THREADS)) {
                if (valid &= (intArg = this.getInt(args, ++i)) >= 0) {
                    this.useThreads = intArg > 0;
                    this.threadCount = intArg;
                } else {
                    valid = false;
                    System.err.println(THREADS_ERROR);
                }
            } else if (args[i].equals(HELP)) {
                this.attemptEncode = false;
                this.printUsage();
                valid = false;
            } else if (this.inputFile == null) {
                valid &= this.getInputFile(args[i]);
            } else if (this.outputFile == null) {
                valid &= this.getOutputFile(args[i]);
            } else {
                System.err.println("Invalid command switch");
            }
            if (valid) continue;
            if (i <= args.length) break;
            i = args.length - 1;
            break;
        }
        return valid;
    }

    private boolean getOutputFile(String filename) {
        boolean result = true;
        File file = new File(filename);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            if (!(result &= file.canWrite())) {
                System.err.println("Error, can't write to output file: " + filename);
            } else {
                this.outputFile = file;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return result;
    }

    private boolean getInputFile(String filename) {
        boolean result = true;
        File file = new File(filename);
        result = file.exists();
        if (!result) {
            System.err.println("Error, input file not found: " + filename);
        } else {
            result = file.isFile();
            if (!result) {
                System.err.println("Error, input is not a file: " + filename);
            } else {
                result = file.canRead();
                if (!result) {
                    System.err.println("Error, can't read input file: " + filename);
                } else {
                    this.inputFile = file;
                }
            }
        }
        return result;
    }

    int getInt(String[] args, int index) {
        int result = -1;
        if (index >= 0 && index < args.length) {
            try {
                result = Integer.parseInt(args[index]);
            }
            catch (NumberFormatException e) {
                result = -1;
            }
        }
        return result;
    }

    private void fileEncoderTest() {
        File fIn = new File("input.wav");
        File fOut = new File("fileEncoderTest.flac");
        FLAC_FileEncoder enc = new FLAC_FileEncoder();
        enc.encode(fIn, fOut);
    }
}

