/*
 * Decompiled with CFR 0.152.
 */
package javaFlacEncoder;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import javaFlacEncoder.FLACOutputStream;

public class FLACFileOutputStream
implements FLACOutputStream {
    FileOutputStream fos = null;
    long position = 0L;
    long size = 0L;
    boolean valid;

    public FLACFileOutputStream(String filename) {
        try {
            this.fos = new FileOutputStream(filename);
            this.valid = true;
        }
        catch (FileNotFoundException e) {
            System.err.println("Error creating file");
            this.valid = false;
        }
        catch (IOException e) {
            System.err.println("Error handling file");
            this.valid = false;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public long seek(long pos) {
        FileChannel fc = this.fos.getChannel();
        try {
            fc.position(pos);
        }
        catch (IOException e) {
            System.err.print(e.toString());
        }
        return pos;
    }

    public void write(byte data) throws IOException {
        this.fos.write(data);
        if (this.position + 1L > this.size) {
            this.size = this.position + 1L;
        }
        ++this.position;
    }

    public int write(byte[] data, int offset, int count) throws IOException {
        int result = count;
        this.fos.write(data, offset, count);
        if (this.position + (long)count > this.size) {
            this.size = this.position + (long)count;
        }
        this.position += (long)count;
        return result;
    }

    public long size() {
        return this.size;
    }

    public boolean canSeek() {
        return true;
    }

    public long getPos() {
        return this.position;
    }
}

