/*
 * Decompiled with CFR 0.152.
 */
package javaFlacEncoder;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import javaFlacEncoder.BlockEncodeRequest;
import javaFlacEncoder.BlockThreadManager2;
import javaFlacEncoder.EncodedElement;
import javaFlacEncoder.EncodingConfiguration;
import javaFlacEncoder.FLACOutputStream;
import javaFlacEncoder.FLACStreamIdentifier;
import javaFlacEncoder.Frame;
import javaFlacEncoder.MetadataBlockHeader;
import javaFlacEncoder.MetadataBlockStreamInfo;
import javaFlacEncoder.StreamConfiguration;

public class FLACEncoder {
    int DEBUG_LEV = 0;
    public int MAX_THREADED_FRAMES = 2;
    EncodingConfiguration encodingConfig = null;
    StreamConfiguration streamConfig = null;
    volatile Boolean isEncoding = false;
    private final Object configWriteLock = new Object();
    private Vector<int[]> blockQueue = null;
    private int[] unfinishedBlock = null;
    private int unfinishedBlockUsed = 0;
    private FLACOutputStream out = null;
    EncodedElement FLAC_id = FLACStreamIdentifier.getIdentifier();
    Frame frame = null;
    MessageDigest md = null;
    BlockThreadManager2 threadManager = null;
    Frame[] threadedFrames = null;
    int minFrameSize = Integer.MAX_VALUE;
    int maxFrameSize = 0;
    int minBlockSize = Integer.MAX_VALUE;
    int maxBlockSize = 0;
    volatile long samplesInStream;
    long nextFrameNumber = 0L;
    long streamHeaderPos = 0L;
    boolean error = false;
    LinkedBlockingQueue<BlockEncodeRequest> usedBlockEncodeRequests = new LinkedBlockingQueue();
    LinkedBlockingQueue<int[]> usedIntArrays = new LinkedBlockingQueue();

    public FLACEncoder() {
        this.blockQueue = new Vector();
        StreamConfiguration defaultStreamConfig = new StreamConfiguration();
        this.encodingConfig = new EncodingConfiguration();
        this.frame = new Frame(defaultStreamConfig);
        this.frame.registerConfiguration(this.encodingConfig);
        this.threadManager = new BlockThreadManager2(this);
        this.threadedFrames = new Frame[this.MAX_THREADED_FRAMES];
        for (int i = 0; i < this.MAX_THREADED_FRAMES; ++i) {
            this.threadedFrames[i] = new Frame(defaultStreamConfig);
            this.threadManager.addFrameThread(this.threadedFrames[i]);
        }
        try {
            this.md = MessageDigest.getInstance("md5");
            this.reset();
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("Critical Error: No md5 algorithm exists. This encoder can not function.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setEncodingConfiguration(EncodingConfiguration ec) {
        boolean changed = false;
        if (!this.isEncoding.booleanValue() && ec != null) {
            Object object = this.configWriteLock;
            synchronized (object) {
                this.encodingConfig = ec;
                this.frame.registerConfiguration(ec);
                for (int i = 0; i < this.MAX_THREADED_FRAMES; ++i) {
                    this.threadedFrames[i].registerConfiguration(ec);
                }
            }
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setStreamConfiguration(StreamConfiguration sc) {
        boolean changed = false;
        if (!this.isEncoding.booleanValue() && sc != null) {
            Object object = this.configWriteLock;
            synchronized (object) {
                this.streamConfig = sc;
                this.frame = new Frame(sc);
                this.threadManager = new BlockThreadManager2(this);
                this.threadedFrames = new Frame[this.MAX_THREADED_FRAMES];
                for (int i = 0; i < this.MAX_THREADED_FRAMES; ++i) {
                    this.threadedFrames[i] = new Frame(sc);
                    this.threadManager.addFrameThread(this.threadedFrames[i]);
                }
                this.setEncodingConfiguration(this.encodingConfig);
            }
            changed = true;
        }
        return changed;
    }

    private void reset() {
        this.md.reset();
        this.minFrameSize = Integer.MAX_VALUE;
        this.minFrameSize = Integer.MAX_VALUE;
        this.maxFrameSize = 0;
        this.minBlockSize = Integer.MAX_VALUE;
        this.maxBlockSize = 0;
        this.samplesInStream = 0L;
        this.streamHeaderPos = 0L;
        this.unfinishedBlock = null;
        this.unfinishedBlockUsed = 0;
        this.blockQueue.clear();
        this.nextFrameNumber = 0L;
    }

    private void closeFLACStream() {
        if (this.DEBUG_LEV > 0) {
            System.err.println("FLACEncoder::closeFLACStream : Begin");
        }
        this.streamConfig.setMaxBlockSize(this.maxBlockSize);
        this.streamConfig.setMinBlockSize(this.minBlockSize);
        byte[] md5 = this.md.digest();
        EncodedElement streamInfo = MetadataBlockStreamInfo.getStreamInfo(this.streamConfig, this.minFrameSize, this.maxFrameSize, this.samplesInStream, md5);
        this.out.seek(this.streamHeaderPos);
        try {
            this.writeDataToOutput(streamInfo);
        }
        catch (IOException e) {
            System.err.println("FLACEncoder::closeFLACStream():  ERROR WRiting to output");
        }
    }

    public void openFLACStream() throws IOException {
        this.reset();
        this.out.write(this.FLAC_id.getData(), 0, this.FLAC_id.getUsableBits() / 8);
        byte[] md5Hash = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        EncodedElement streamInfo = MetadataBlockStreamInfo.getStreamInfo(this.streamConfig, this.minFrameSize, this.maxFrameSize, this.samplesInStream, md5Hash);
        int size = streamInfo.getUsableBits() / 8;
        EncodedElement metadataBlockHeader = MetadataBlockHeader.getMetadataBlockHeader(true, MetadataBlockHeader.MetadataBlockType.STREAMINFO, size);
        this.writeDataToOutput(metadataBlockHeader);
        this.streamHeaderPos = this.out.getPos();
        this.out.write(streamInfo.getData(), 0, size);
    }

    public boolean addSamples(int[] samples, int count) {
        boolean added = false;
        int channels = this.streamConfig.getChannelCount();
        int maxFrames = samples.length / channels;
        int validSamples = count * channels;
        if (this.DEBUG_LEV > 0) {
            System.err.println("addSamples(...): ");
            System.err.println("maxFrames: " + maxFrames);
            System.err.println("validSamples: " + validSamples);
            if (this.DEBUG_LEV > 10) {
                System.err.println("count:" + count + ":channels:" + channels);
            }
        }
        if (count <= maxFrames) {
            int[] block;
            int blockSize;
            added = true;
            int samplesUsed = 0;
            if (this.unfinishedBlock != null) {
                int i;
                int nextSampleStop;
                if (this.DEBUG_LEV > 10) {
                    System.err.println("addSamples(...): filling unfinishedBlock");
                }
                blockSize = this.streamConfig.getMaxBlockSize();
                block = this.unfinishedBlock;
                int unfinishedBlockRemaining = blockSize * channels - this.unfinishedBlockUsed;
                if (unfinishedBlockRemaining <= 0) {
                    System.err.println("MAJOR ERROR HERE. Unfinsihed block remaining invalid: " + unfinishedBlockRemaining);
                    System.exit(-1);
                }
                if ((nextSampleStop = samplesUsed + unfinishedBlockRemaining) > validSamples) {
                    nextSampleStop = validSamples;
                }
                for (i = 0; i < unfinishedBlockRemaining && i < nextSampleStop; ++i) {
                    block[this.unfinishedBlockUsed + i] = samples[samplesUsed + i];
                }
                this.unfinishedBlockUsed += i;
                samplesUsed = nextSampleStop;
                if (this.unfinishedBlockUsed == blockSize * channels) {
                    this.blockQueue.add(block);
                    this.unfinishedBlockUsed = 0;
                    this.unfinishedBlock = null;
                } else if (this.unfinishedBlockUsed > blockSize * channels) {
                    System.err.println("Error: FLACEncoder.addSamples(...) unfinished block = " + this.unfinishedBlockUsed);
                    System.exit(-1);
                }
            }
            while (samplesUsed < validSamples) {
                if (this.DEBUG_LEV > 20) {
                    System.err.println("addSamples(...): creating new block");
                }
                blockSize = this.streamConfig.getMaxBlockSize();
                block = this.getBlock(blockSize * channels);
                int nextSampleStop = samplesUsed + blockSize * channels;
                if (nextSampleStop > validSamples) {
                    if (this.DEBUG_LEV > 20) {
                        System.err.println("addSamples(...): setting partial Block");
                    }
                    nextSampleStop = validSamples;
                    this.unfinishedBlock = block;
                    this.unfinishedBlockUsed = validSamples - samplesUsed;
                } else {
                    this.blockQueue.add(block);
                }
                for (int i = 0; i < nextSampleStop - samplesUsed; ++i) {
                    block[i] = samples[samplesUsed + i];
                }
                samplesUsed = nextSampleStop;
            }
        } else {
            System.err.println("Error: FLACEncoder.addSamples given count out of bounds");
        }
        if (this.DEBUG_LEV > 20) {
            System.err.println("Blocks stored: " + this.blockQueue.size());
            System.err.println("Samples in partial block: " + this.unfinishedBlockUsed);
        }
        return added;
    }

    private void outputBlockToFile(int[] block, int count, int iter) {
        try {
            FileOutputStream fout = new FileOutputStream("samples.txt");
            PrintWriter pOut = new PrintWriter(fout);
            for (int i = 0; i < count; ++i) {
                String temp = Integer.toString(i) + ":";
                temp = temp + Integer.toString(block[i * iter]);
                System.err.print(temp);
                pOut.println(temp);
            }
            pOut.flush();
            pOut.close();
            fout.close();
            System.exit(0);
            System.err.println("sample file written:");
        }
        catch (FileNotFoundException e) {
            System.err.println("Error creating file");
        }
        catch (IOException e) {
            System.err.println("Error handling file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockFinished(BlockEncodeRequest ber) {
        BlockEncodeRequest blockEncodeRequest = ber;
        synchronized (blockEncodeRequest) {
            int frameSize;
            try {
                this.writeDataToOutput(ber.result.getNext());
            }
            catch (IOException e) {
                System.err.println("blockFinished: Error writing to output");
                e.printStackTrace();
                this.error = true;
            }
            if (ber.count != ber.encodedSamples) {
                System.err.println("Error encoding frame number: " + ber.frameNumber + ", FLAC stream potentially invalid");
            }
            this.samplesInStream += (long)ber.encodedSamples;
            if (ber.encodedSamples > this.maxBlockSize) {
                this.maxBlockSize = ber.encodedSamples;
            }
            if (ber.encodedSamples < this.minBlockSize) {
                this.minBlockSize = ber.encodedSamples;
            }
            if ((frameSize = ber.result.getTotalBits() % 8) > this.maxFrameSize) {
                this.maxFrameSize = frameSize;
            }
            if (frameSize < this.minFrameSize) {
                this.minFrameSize = frameSize;
            }
            this.addSamplesToMD5(ber.samples, ber.encodedSamples, ber.skip + 1, this.streamConfig.getBitsPerSample());
            this.usedIntArrays.add(ber.samples);
            ber.samples = null;
            ber.result = null;
            this.usedBlockEncodeRequests.add(ber);
        }
    }

    public int t_encodeSamples(int count, boolean end) throws IOException {
        EncodedElement result;
        int encodedSamples;
        int[] block;
        int encodedCount = 0;
        int blocksLeft = this.blockQueue.size();
        int channels = this.streamConfig.getChannelCount();
        while (count > 0 && blocksLeft > 0) {
            if (this.DEBUG_LEV > 20) {
                System.err.println("while: count:blocksLeft  : " + count + ":" + blocksLeft);
            }
            if ((block = this.blockQueue.elementAt(0)).length <= count * channels) {
                encodedSamples = block.length / channels;
                result = new EncodedElement();
                BlockEncodeRequest ber = this.usedBlockEncodeRequests.poll();
                if (ber == null) {
                    ber = new BlockEncodeRequest();
                }
                ber.setAll(block, encodedSamples, 0, channels - 1, this.nextFrameNumber++, result);
                this.threadManager.addRequest(ber);
                this.blockQueue.remove(0);
                --blocksLeft;
                count -= encodedSamples;
                encodedCount += encodedSamples;
                continue;
            }
            System.err.println("Error with block in queue?");
            break;
        }
        this.threadManager.blockWhileQueueExceeds(5);
        if (end) {
            this.threadManager.stop();
            this.threadManager.blockWhileQueueExceeds(0);
        }
        if (end && count >= 0 && this.samplesAvailableToEncode() >= count) {
            if (count > 0 && this.unfinishedBlockUsed >= count) {
                block = null;
                block = this.blockQueue.size() > 0 ? this.blockQueue.elementAt(0) : this.unfinishedBlock;
                int encoded = this.frame.encodeSamples(block, encodedSamples = count, 0, channels - 1, result = new EncodedElement(), this.nextFrameNumber);
                if (encoded != encodedSamples) {
                    System.err.println("FLACEncoder::encodeSamples : (end)Error in encoding");
                    count = -1;
                } else {
                    int frameSize;
                    this.writeDataToOutput(result.getNext());
                    encodedCount += encodedSamples;
                    count -= encodedSamples;
                    this.addSamplesToMD5(block, encodedSamples, channels, this.streamConfig.getBitsPerSample());
                    this.samplesInStream += (long)encodedSamples;
                    ++this.nextFrameNumber;
                    if (encodedSamples > this.maxBlockSize) {
                        this.maxBlockSize = encodedSamples;
                    }
                    if (encodedSamples < this.minBlockSize) {
                        this.minBlockSize = encodedSamples;
                    }
                    if ((frameSize = result.getTotalBits() % 8) > this.maxFrameSize) {
                        this.maxFrameSize = frameSize;
                    }
                    if (frameSize < this.minFrameSize) {
                        this.minFrameSize = frameSize;
                    }
                }
            }
            if (count == 0) {
                this.closeFLACStream();
            }
        } else if (end) {
            System.err.println("End set but not done. Error likely. This can happen if number of samples requested to encode exeeds available samples");
        }
        return encodedCount;
    }

    public int encodeSamples(int count, boolean end) throws IOException {
        int frameSize;
        int encoded;
        EncodedElement result;
        int encodedSamples;
        int[] block;
        int encodedCount = 0;
        int blocksLeft = this.blockQueue.size();
        int channels = this.streamConfig.getChannelCount();
        while (count > 0 && blocksLeft > 0) {
            if (this.DEBUG_LEV > 20) {
                System.err.println("while: count:blocksLeft  : " + count + ":" + blocksLeft);
            }
            if ((block = this.blockQueue.elementAt(0)).length <= count * channels) {
                encodedSamples = block.length / channels;
                result = new EncodedElement();
                encoded = this.frame.encodeSamples(block, encodedSamples, 0, channels - 1, result, this.nextFrameNumber);
                if (encoded != encodedSamples) {
                    System.err.println("FLACEncoder::encodeSamples : Error in encoding");
                    count = -1;
                    break;
                }
                this.writeDataToOutput(result.getNext());
                this.blockQueue.remove(0);
                --blocksLeft;
                encodedCount += encodedSamples;
                count -= encodedSamples;
                this.samplesInStream += (long)encodedSamples;
                ++this.nextFrameNumber;
                if (encodedSamples > this.maxBlockSize) {
                    this.maxBlockSize = encodedSamples;
                }
                if (encodedSamples < this.minBlockSize) {
                    this.minBlockSize = encodedSamples;
                }
                if ((frameSize = result.getTotalBits() % 8) > this.maxFrameSize) {
                    this.maxFrameSize = frameSize;
                }
                if (frameSize < this.minFrameSize) {
                    this.minFrameSize = frameSize;
                }
                this.addSamplesToMD5(block, encodedSamples, channels, this.streamConfig.getBitsPerSample());
                this.usedIntArrays.add(block);
                continue;
            }
            if (this.blockQueue.size() <= 0) break;
            System.err.println("Can't encode full but blocksize != 0");
            System.err.println("Blockqueue size: " + this.blockQueue.size());
            System.err.println("Block size: " + block.length);
            System.err.println("Count: " + count);
            break;
        }
        if (end) {
            this.threadManager.stop();
        }
        if (end && count >= 0 && this.samplesAvailableToEncode() >= count) {
            if (count > 0 && this.unfinishedBlockUsed >= count) {
                block = null;
                block = this.blockQueue.size() > 0 ? this.blockQueue.elementAt(0) : this.unfinishedBlock;
                encoded = this.frame.encodeSamples(block, encodedSamples = count, 0, channels - 1, result = new EncodedElement(), this.nextFrameNumber);
                if (encoded != encodedSamples) {
                    System.err.println("FLACEncoder::encodeSamples : (end)Error in encoding");
                    count = -1;
                } else {
                    this.writeDataToOutput(result.getNext());
                    encodedCount += encodedSamples;
                    count -= encodedSamples;
                    this.addSamplesToMD5(block, encodedSamples, channels, this.streamConfig.getBitsPerSample());
                    this.samplesInStream += (long)encodedSamples;
                    ++this.nextFrameNumber;
                    if (encodedSamples > this.maxBlockSize) {
                        this.maxBlockSize = encodedSamples;
                    }
                    if (encodedSamples < this.minBlockSize) {
                        this.minBlockSize = encodedSamples;
                    }
                    if ((frameSize = result.getTotalBits() % 8) > this.maxFrameSize) {
                        this.maxFrameSize = frameSize;
                    }
                    if (frameSize < this.minFrameSize) {
                        this.minFrameSize = frameSize;
                    }
                    System.err.println("Count: " + count);
                }
            }
            if (count == 0) {
                this.closeFLACStream();
            }
        } else if (end) {
            System.err.println("End set but not done. Error likely.");
        }
        return encodedCount;
    }

    private void addSamplesToMD5(int[] samples, int count, int channels, int sampleSize) {
        int bytesPerSample = sampleSize / 8;
        if (sampleSize % 8 != 0) {
            ++bytesPerSample;
        }
        byte[] dataMD5 = new byte[count * bytesPerSample * channels];
        for (int i = 0; i < count * channels; ++i) {
            for (int x = 0; x < bytesPerSample; ++x) {
                dataMD5[i * bytesPerSample + x] = (byte)(samples[i] >> x * 8);
            }
        }
        this.md.update(dataMD5, 0, count * bytesPerSample * channels);
    }

    private int writeDataToOutput(EncodedElement data) throws IOException {
        int writtenBytes = 0;
        int offset = 0;
        int currentByte = 0;
        byte unfullByte = 0;
        byte[] eleData = null;
        int usableBits = 0;
        int lastByte = 0;
        for (EncodedElement current = data; current != null; current = current.getNext()) {
            eleData = current.getData();
            usableBits = current.getUsableBits();
            currentByte = 0;
            if (offset != 0) {
                unfullByte = (byte)(unfullByte | eleData[currentByte++]);
                this.out.write(unfullByte);
            }
            if ((lastByte = usableBits / 8) > 0) {
                this.out.write(eleData, currentByte, lastByte - currentByte);
            }
            if ((offset = usableBits % 8) == 0) continue;
            unfullByte = eleData[lastByte];
        }
        if (offset != 0) {
            this.out.write(eleData, lastByte, 1);
        }
        return writtenBytes;
    }

    public int fullBlockSamplesAvailableToEncode() {
        int available = 0;
        int channels = this.streamConfig.getChannelCount();
        for (int[] block : this.blockQueue) {
            available += block.length / channels;
        }
        return available;
    }

    public int samplesAvailableToEncode() {
        int available = 0;
        int channels = this.streamConfig.getChannelCount();
        for (int[] block : this.blockQueue) {
            available += block.length / channels;
        }
        return available += this.unfinishedBlockUsed;
    }

    public void setOutputStream(FLACOutputStream fos) {
        this.out = fos;
    }

    public int[] getBlock(int size) {
        int[] result = this.usedIntArrays.poll();
        if (result == null) {
            result = new int[size];
        } else if (result.length < size) {
            this.usedIntArrays.offer(result);
            result = new int[size];
        }
        return result;
    }
}

