/*
 * Decompiled with CFR 0.152.
 */
package javaFlacEncoder;

public class EncodedElement {
    static int DEBUG_LEV = 0;
    EncodedElement previous = null;
    EncodedElement next = null;
    byte[] data = null;
    int usableBits = 0;
    protected int offset;

    public EncodedElement() {
        this.offset = 0;
        this.usableBits = 0;
        this.data = new byte[100];
    }

    public EncodedElement(int size, int off) {
        this.data = new byte[size];
        this.usableBits = off;
        this.offset = off;
    }

    public void clear(int size, int off) {
        this.next = null;
        this.previous = null;
        this.data = new byte[size];
        this.offset = off;
        this.usableBits = off;
    }

    void setPrevious(EncodedElement ele) {
        this.previous = ele;
    }

    void setNext(EncodedElement ele) {
        this.next = ele;
    }

    EncodedElement getPrevious() {
        return this.previous;
    }

    EncodedElement getNext() {
        return this.next;
    }

    void setData(byte[] data) {
        this.data = data;
    }

    void setUsableBits(int bits) {
        this.usableBits = bits;
    }

    byte[] getData() {
        return this.data;
    }

    int getUsableBits() {
        return this.usableBits;
    }

    protected static EncodedElement getEnd_S(EncodedElement e) {
        if (e == null) {
            return null;
        }
        EncodedElement temp = e.next;
        EncodedElement end = e;
        while (temp != null) {
            end = temp;
            temp = temp.next;
        }
        return end;
    }

    public EncodedElement getEnd() {
        EncodedElement temp = this.next;
        EncodedElement end = this;
        while (temp != null) {
            end = temp;
            temp = temp.next;
        }
        return end;
    }

    public boolean attachEnd(EncodedElement e) {
        if (DEBUG_LEV > 0) {
            System.err.println("EncodedElement::attachEnd : Begin");
        }
        boolean attached = true;
        EncodedElement current = this;
        while (current.getNext() != null) {
            current = current.getNext();
        }
        current.setNext(e);
        e.setPrevious(current);
        if (DEBUG_LEV > 0) {
            System.err.println("EncodedElement::attachEnd : End");
        }
        return attached;
    }

    public EncodedElement addLong(long input, int bitCount) {
        if (this.next != null) {
            EncodedElement end = EncodedElement.getEnd_S(this.next);
            return end.addLong(input, bitCount);
        }
        if (this.data.length * 8 <= this.usableBits + bitCount) {
            int tOff = this.usableBits % 8;
            int size = this.data.length / 2 + 1;
            if (size < bitCount) {
                size = bitCount * 10;
            }
            this.next = new EncodedElement(size, tOff);
            return this.next.addLong(input, bitCount);
        }
        int startPos = this.usableBits;
        byte[] dest = this.data;
        EncodedElement.addLong(input, bitCount, startPos, dest);
        this.usableBits += bitCount;
        return this;
    }

    public EncodedElement addInt(int input, int bitCount) {
        if (this.next != null) {
            EncodedElement end = EncodedElement.getEnd_S(this.next);
            return end.addInt(input, bitCount);
        }
        if (this.data.length * 8 < this.usableBits + bitCount) {
            int tOff = this.usableBits % 8;
            int size = 1000;
            this.next = new EncodedElement(size, tOff);
            System.err.println("creating next node of size:bitCount " + size + ":" + bitCount + ":" + this.usableBits + ":" + this.data.length);
            System.err.println("value: " + input);
            return this.next.addInt(input, bitCount);
        }
        int startPos = this.usableBits;
        byte[] dest = this.data;
        EncodedElement.addInt(input, bitCount, startPos, dest);
        this.usableBits += bitCount;
        return this;
    }

    public EncodedElement packInt(int[] inputArray, int bitSize, int start, int skip, int countA) {
        if (this.next != null) {
            EncodedElement end = EncodedElement.getEnd_S(this.next);
            return end.packInt(inputArray, bitSize, start, skip, countA);
        }
        int writeCount = (this.data.length * 8 - this.usableBits) / bitSize;
        if (writeCount > countA) {
            writeCount = countA;
        }
        EncodedElement.packInt(inputArray, bitSize, this.usableBits, start, skip, countA, this.data);
        this.usableBits += writeCount * bitSize;
        if ((countA -= writeCount) > 0) {
            int tOff = this.usableBits % 8;
            int size = this.data.length / 2 + 1;
            if (size < bitSize * countA) {
                size = bitSize * countA + 10;
            }
            this.next = new EncodedElement(size, tOff);
            return this.next.packInt(inputArray, bitSize, start + writeCount * (skip + 1), skip, countA);
        }
        return this;
    }

    public EncodedElement packIntByBits(int[] inputA, int[] inputBits, int inputOffset, int countA) {
        if (this.next != null) {
            EncodedElement end = EncodedElement.getEnd_S(this.next);
            return end.packIntByBits(inputA, inputBits, inputOffset, countA);
        }
        int writeBitsRemaining = this.data.length * 8 - this.usableBits;
        int willWrite = 0;
        int writeCount = 0;
        for (int i = 0; i < countA && (writeBitsRemaining -= inputBits[inputOffset + i]) >= 0; ++i) {
            ++writeCount;
            willWrite += inputBits[inputOffset + i];
        }
        if (writeCount > 0) {
            EncodedElement.packIntByBits(inputA, inputBits, inputOffset, writeCount, this.usableBits, this.data);
            this.usableBits += willWrite;
        }
        if ((countA -= writeCount) > 0) {
            inputOffset += writeCount;
            int tOff = this.usableBits % 8;
            int size = this.data.length / 2 + 1;
            int remainingToWrite = 0;
            for (int i = 0; i < countA; ++i) {
                remainingToWrite += inputBits[inputOffset + i];
            }
            if (size < (remainingToWrite = remainingToWrite / 8 + 1)) {
                size = remainingToWrite + 10;
            }
            this.next = new EncodedElement(size, tOff);
            return this.next.packIntByBits(inputA, inputBits, inputOffset, countA);
        }
        return this;
    }

    public int getTotalBits() {
        int total = 0;
        EncodedElement iter = this;
        while (iter != null) {
            total += iter.usableBits - iter.offset;
            iter = iter.next;
        }
        return total;
    }

    public static void addInt(int value, int count, int startPos, byte[] dest) {
        int currentByte = startPos / 8;
        int currentOffset = startPos % 8;
        int upShift = 40 - count - currentOffset;
        long upperMask = -1 >>> 63 - count;
        long val = (long)value & upperMask;
        int[] bs = new int[5];
        bs[4] = (byte)(val <<= upShift);
        bs[3] = (byte)(val >>= 8);
        bs[2] = (byte)(val >>= 8);
        bs[1] = (byte)(val >>= 8);
        bs[0] = (byte)(val >>= 8);
        int bIndex = 0;
        if (currentOffset > 0) {
            int b1Mask = 255 >> currentOffset;
            int bitRoom = 8 - currentOffset;
            int lowerRoom = bitRoom - count;
            if (lowerRoom > 0) {
                b1Mask >>>= lowerRoom;
                b1Mask <<= lowerRoom;
            }
            bs[0] = bs[0] & b1Mask;
            int b1d = dest[currentByte] & ~b1Mask;
            dest[currentByte++] = (byte)(bs[0] | b1d);
            count -= bitRoom;
            ++bIndex;
        }
        int midCount = count / 8;
        switch (midCount) {
            case 4: {
                dest[currentByte++] = (byte)bs[bIndex++];
            }
            case 3: {
                dest[currentByte++] = (byte)bs[bIndex++];
            }
            case 2: {
                dest[currentByte++] = (byte)bs[bIndex++];
            }
            case 1: {
                dest[currentByte++] = (byte)bs[bIndex++];
            }
        }
        if ((count -= midCount * 8) > 0) {
            int lastMask = 255 << 8 - count;
            dest[currentByte] = (byte)(dest[currentByte] & ~lastMask);
            dest[currentByte] = (byte)(bs[bIndex] | dest[currentByte]);
        }
    }

    public static void addLong(long input, int count, int startPos, byte[] dest) {
        if (DEBUG_LEV > 30) {
            System.err.println("EncodedElement::addLong : Begin");
        }
        int currentByte = startPos / 8;
        int currentOffset = startPos % 8;
        while (count > 0) {
            int bitRoom = 8 - currentOffset;
            int downShift = count - bitRoom;
            long upMask = 255 >>> currentOffset;
            int upShift = 0;
            if (downShift < 0) {
                upShift = bitRoom - count;
                upMask = 255 >>> currentOffset + upShift;
                downShift = 0;
            }
            if (DEBUG_LEV > 30) {
                System.err.println("count:offset:bitRoom:downShift:upShift:" + count + ":" + currentOffset + ":" + bitRoom + ":" + downShift + ":" + upShift);
            }
            long currentBits = input >>> downShift & upMask;
            upMask = (byte)upMask << upShift;
            dest[currentByte] = (byte)((long)dest[currentByte] & (upMask ^ 0xFFFFFFFFFFFFFFFFL));
            dest[currentByte] = (byte)((long)dest[currentByte] | (currentBits <<= upShift));
            count -= bitRoom;
            currentOffset = 0;
            ++currentByte;
        }
        if (DEBUG_LEV > 30) {
            System.err.println("EncodedElement::addLong : End");
        }
    }

    public static void packInt(int[] inputArray, int bitSize, int startPosIn, int start, int skip, int countA, byte[] dest) {
        if (DEBUG_LEV > 30) {
            System.err.println("EncodedElement::packInt : Begin");
        }
        for (int valI = 0; valI < countA; ++valI) {
            int input = inputArray[valI * (skip + 1) + start];
            int count = bitSize;
            int startPos = startPosIn + valI * bitSize;
            int currentByte = startPos / 8;
            int currentOffset = startPos % 8;
            while (count > 0) {
                int bitRoom = 8 - currentOffset;
                int downShift = count - bitRoom;
                int upMask = 255 >>> currentOffset;
                int upShift = 0;
                if (downShift < 0) {
                    upShift = bitRoom - count;
                    upMask = 255 >>> currentOffset + upShift;
                    downShift = 0;
                }
                if (DEBUG_LEV > 30) {
                    System.err.println("count:offset:bitRoom:downShift:upShift:" + count + ":" + currentOffset + ":" + bitRoom + ":" + downShift + ":" + upShift);
                }
                int currentBits = input >>> downShift & upMask;
                upMask = (byte)upMask << upShift;
                dest[currentByte] = (byte)(dest[currentByte] & ~upMask);
                dest[currentByte] = (byte)(dest[currentByte] | (currentBits <<= upShift));
                count -= bitRoom;
                currentOffset = 0;
                ++currentByte;
            }
        }
        if (DEBUG_LEV > 30) {
            System.err.println("EncodedElement::packInt: End");
        }
    }

    public static void packIntByBits(int[] inputA, int[] inputBits, int inputOffset, int countA, int startPosIn, byte[] dest) {
        if (DEBUG_LEV > 30) {
            System.err.println("EncodedElement::packIntByBits : Begin");
        }
        int inputIter = 0;
        int startPos = startPosIn;
        inputIter = inputOffset;
        int inputStop = countA + inputOffset;
        for (int valI = inputOffset; valI < inputStop; ++valI) {
            int currentBits;
            int upShift;
            int upMask;
            int downShift;
            int bitRoom;
            int input = inputA[valI];
            int count = inputBits[valI];
            int currentByte = startPos / 8;
            int currentOffset = startPos % 8;
            startPos += count;
            if (currentOffset != 0) {
                bitRoom = 8 - currentOffset;
                downShift = count - bitRoom;
                upMask = 255 >>> currentOffset;
                upShift = 0;
                if (downShift < 0) {
                    upShift = bitRoom - count;
                    upMask = 255 >>> currentOffset + upShift;
                    downShift = 0;
                }
                if (DEBUG_LEV > 30) {
                    System.err.println("count:offset:bitRoom:downShift:upShift:" + count + ":" + currentOffset + ":" + bitRoom + ":" + downShift + ":" + upShift);
                }
                currentBits = input >>> downShift & upMask;
                upMask = (byte)upMask << upShift;
                dest[currentByte] = (byte)(dest[currentByte] & ~upMask);
                dest[currentByte] = (byte)(dest[currentByte] | (currentBits <<= upShift));
                count -= bitRoom;
                currentOffset = 0;
                ++currentByte;
            }
            bitRoom = 8;
            upShift = 0;
            upMask = 255;
            while (count >= 8) {
                downShift = count - bitRoom;
                if (DEBUG_LEV > 30) {
                    System.err.println("count:offset:bitRoom:downShift:upShift:" + count + ":" + currentOffset + ":" + bitRoom + ":" + downShift + ":" + upShift);
                }
                currentBits = input >>> downShift & upMask;
                dest[currentByte] = (byte)currentBits;
                count -= bitRoom;
                ++currentByte;
            }
            if (count <= 0) continue;
            downShift = 0;
            upShift = bitRoom - count;
            upMask = 255 >>> upShift;
            if (DEBUG_LEV > 30) {
                System.err.println("count:offset:bitRoom:downShift:upShift:" + count + ":" + currentOffset + ":" + bitRoom + ":" + downShift + ":" + upShift);
            }
            currentBits = input & upMask;
            upMask = (byte)upMask << upShift;
            dest[currentByte] = (byte)(dest[currentByte] & ~upMask);
            dest[currentByte] = (byte)(dest[currentByte] | (currentBits <<= upShift));
            count -= bitRoom;
            currentOffset = 0;
            ++currentByte;
        }
        if (DEBUG_LEV > 30) {
            System.err.println("EncodedElement::addInt : End");
        }
    }

    public boolean padToByte() {
        boolean padded = false;
        EncodedElement end = EncodedElement.getEnd_S(this);
        int tempVal = end.usableBits;
        if (tempVal % 8 != 0) {
            int toWrite = 8 - tempVal % 8;
            end.addInt(0, toWrite);
            if ((this.getTotalBits() + this.offset) % 8 != 0) {
                System.err.println("EncodedElement::padToByte: SERIOUS ERROR! Algorithm implemented is incorrect!!!");
            }
            padded = true;
        }
        return padded;
    }
}

