/*
 * Decompiled with CFR 0.152.
 */
package javaFlacEncoder;

import javaFlacEncoder.EncodedElement;

public class CRC16 {
    public static int DEBUG_LEV = 0;
    static final int divisorCRC16 = -1073577984;
    protected int workingCRC16;
    protected int workingCRC16Count;

    public CRC16() {
        this.reset();
    }

    public short updateCRC16(byte[] inSet, int start, int end) {
        int current = start;
        int topBit = 0;
        int topMask = Integer.MIN_VALUE;
        int shiftMask = 65280;
        while (current < end) {
            topBit = this.workingCRC16 & topMask;
            while (this.workingCRC16Count > 16 && topBit == 0) {
                --this.workingCRC16Count;
                this.workingCRC16 <<= 1;
                topBit = this.workingCRC16 & topMask;
            }
            if (this.workingCRC16Count > 16) {
                this.workingCRC16 ^= 0xC0028000;
                continue;
            }
            int temp = inSet[current++];
            temp = temp << 8 & shiftMask;
            this.workingCRC16 |= temp;
            this.workingCRC16Count += 8;
        }
        return (short)(this.workingCRC16 >>> 16);
    }

    public short checksum() {
        byte[] fake = new byte[]{0};
        this.workingCRC16Count += 16;
        short val = this.updateCRC16(fake, 0, 1);
        return val;
    }

    public void reset() {
        this.workingCRC16 = 0;
        this.workingCRC16Count = 16;
    }

    public static short updateCRC16(byte[] inSet, int start, int end, CRC16 crc16) {
        int current = start;
        int topBit = 0;
        int topMask = Integer.MIN_VALUE;
        int shiftMask = 65280;
        int shiftMask2 = 255;
        int workingCRC16 = crc16.workingCRC16;
        int workingCRC16Count = crc16.workingCRC16Count;
        while (current < end) {
            topBit = workingCRC16 & topMask;
            while (workingCRC16Count > 16 && topBit == 0) {
                --workingCRC16Count;
                topBit = (workingCRC16 <<= 1) & topMask;
            }
            if (workingCRC16Count > 16) {
                workingCRC16 ^= 0xC0028000;
                continue;
            }
            int temp = inSet[current++];
            temp = temp << 8 & shiftMask;
            workingCRC16 |= temp;
            workingCRC16Count += 8;
            if (current >= end) continue;
            temp = inSet[current++];
            workingCRC16 |= (temp &= shiftMask2);
            workingCRC16Count += 8;
        }
        crc16.workingCRC16 = workingCRC16;
        crc16.workingCRC16Count = workingCRC16Count;
        return (short)(workingCRC16 >>> 16);
    }

    public static short getCRC16_noninlined(EncodedElement header, CRC16 crc16) {
        if (DEBUG_LEV > 0) {
            System.err.println("Frame::getCRC16 : Begin");
        }
        crc16.reset();
        int offset = 0;
        int currentByte = 0;
        byte[] unfullByte = new byte[]{0};
        byte[] eleData = null;
        int usableBits = 0;
        int lastByte = 0;
        for (EncodedElement currentEle = header; currentEle != null; currentEle = currentEle.getNext()) {
            eleData = currentEle.getData();
            usableBits = currentEle.getUsableBits();
            currentByte = 0;
            if (offset != 0) {
                unfullByte[0] = (byte)(unfullByte[0] | eleData[currentByte++]);
                CRC16.updateCRC16(unfullByte, 0, 1, crc16);
            }
            lastByte = usableBits / 8;
            CRC16.updateCRC16(eleData, currentByte, lastByte, crc16);
            offset = usableBits % 8;
            if (offset == 0) continue;
            unfullByte[0] = eleData[lastByte];
        }
        if (offset > 0) {
            System.err.println("ERROR: frame was not properly bit padded");
            System.exit(0);
        }
        short crc16Val = crc16.checksum();
        if (DEBUG_LEV > 0) {
            if (DEBUG_LEV > 10) {
                System.err.println("Frame::getCRC16: crc16 : " + Integer.toHexString(crc16Val));
            }
            System.err.println("Frame::getCRC16 : End");
        }
        return crc16Val;
    }

    public static short getCRC16(EncodedElement header, CRC16 crc16) {
        if (DEBUG_LEV > 0) {
            System.err.println("Frame::getCRC16 : Begin");
        }
        crc16.reset();
        int offset = 0;
        int currentByte = 0;
        byte[] unfullByte = new byte[]{0};
        byte[] eleData = null;
        int usableBits = 0;
        int lastByte = 0;
        for (EncodedElement currentEle = header; currentEle != null; currentEle = currentEle.getNext()) {
            int temp;
            int leading;
            int max;
            boolean process;
            int workingCRC16Count;
            int workingCRC16;
            int shiftMask2;
            int shiftMask;
            int current;
            byte[] inSet;
            int end;
            eleData = currentEle.getData();
            usableBits = currentEle.getUsableBits();
            currentByte = 0;
            if (offset != 0) {
                unfullByte[0] = (byte)(unfullByte[0] | eleData[currentByte++]);
                end = 1;
                inSet = unfullByte;
                current = 0;
                shiftMask = 65280;
                shiftMask2 = 255;
                workingCRC16 = crc16.workingCRC16;
                workingCRC16Count = crc16.workingCRC16Count;
                process = true;
                while (process) {
                    max = workingCRC16Count - 16;
                    leading = Integer.numberOfLeadingZeros(workingCRC16);
                    if (leading > max) {
                        leading = max;
                    }
                    workingCRC16 <<= leading;
                    if ((workingCRC16Count -= leading) > 16) {
                        workingCRC16 ^= 0xC0028000;
                        continue;
                    }
                    if (current < end) {
                        temp = inSet[current++];
                        temp = temp << 8 & shiftMask;
                        workingCRC16 |= temp;
                        workingCRC16Count += 8;
                        if (current >= end) continue;
                        temp = inSet[current++];
                        workingCRC16 |= (temp &= shiftMask2);
                        workingCRC16Count += 8;
                        continue;
                    }
                    process = false;
                }
                crc16.workingCRC16 = workingCRC16;
                crc16.workingCRC16Count = workingCRC16Count;
            }
            end = lastByte = usableBits / 8;
            inSet = eleData;
            current = currentByte;
            shiftMask = 65280;
            shiftMask2 = 255;
            workingCRC16 = crc16.workingCRC16;
            workingCRC16Count = crc16.workingCRC16Count;
            process = true;
            if (workingCRC16Count <= 16) {
                if (current < end) {
                    int temp2 = inSet[current++];
                    temp2 = temp2 << 8 & shiftMask;
                    workingCRC16 |= temp2;
                    workingCRC16Count += 8;
                    if (current < end) {
                        temp2 = inSet[current++];
                        workingCRC16 |= (temp2 &= shiftMask2);
                        workingCRC16Count += 8;
                    }
                }
                if (workingCRC16Count <= 16) {
                    process = false;
                }
            }
            while (process) {
                max = workingCRC16Count - 16;
                leading = Integer.numberOfLeadingZeros(workingCRC16);
                if (leading > max) {
                    leading = max;
                }
                workingCRC16 <<= leading;
                if ((workingCRC16Count -= leading) > 16) {
                    workingCRC16 ^= 0xC0028000;
                    continue;
                }
                if (current < end) {
                    temp = inSet[current++];
                    temp = temp << 8 & shiftMask;
                    workingCRC16 |= temp;
                    workingCRC16Count += 8;
                    if (current >= end) continue;
                    temp = inSet[current++];
                    workingCRC16 |= (temp &= shiftMask2);
                    workingCRC16Count += 8;
                    continue;
                }
                process = false;
            }
            crc16.workingCRC16 = workingCRC16;
            crc16.workingCRC16Count = workingCRC16Count;
            offset = usableBits % 8;
            if (offset == 0) continue;
            unfullByte[0] = eleData[lastByte];
        }
        if (offset > 0) {
            System.err.println("ERROR: frame was not properly bit padded");
            System.exit(0);
        }
        short crc16Val = crc16.checksum();
        if (DEBUG_LEV > 0) {
            if (DEBUG_LEV > 10) {
                System.err.println("Frame::getCRC16: crc16 : " + Integer.toHexString(crc16Val));
            }
            System.err.println("Frame::getCRC16 : End");
        }
        return crc16Val;
    }
}

