/*
 * Decompiled with CFR 0.152.
 */
package javaFlacEncoder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javaFlacEncoder.BlockEncodeRequest;
import javaFlacEncoder.FLACEncoder;
import javaFlacEncoder.Frame;
import javaFlacEncoder.FrameThread2;

public class BlockThreadManager2
implements Runnable {
    LinkedBlockingQueue<BlockEncodeRequest> unassignedEncodeRequests = null;
    LinkedBlockingQueue<BlockEncodeRequest> finishedEncodeRequests = null;
    LinkedBlockingQueue<BlockEncodeRequest> orderedEncodeRequests = null;
    Map<FrameThread2, Thread> frameThreadMap = null;
    volatile Thread managerThread = null;
    volatile FLACEncoder encoder = null;
    volatile boolean process = true;
    Vector<FrameThread2> inactiveFrameThreads = null;
    private final Object getLock = new Object();
    Vector<BlockEncodeRequest> finishedRequestStore = null;
    private final Object outstandingCountLock = new Object();
    volatile BlockEncodeRequest nextTarget = null;
    volatile int outstandingCount = 0;

    public BlockThreadManager2(FLACEncoder encoder) {
        this.encoder = encoder;
        this.unassignedEncodeRequests = new LinkedBlockingQueue();
        this.finishedEncodeRequests = new LinkedBlockingQueue();
        this.orderedEncodeRequests = new LinkedBlockingQueue();
        this.frameThreadMap = Collections.synchronizedMap(new HashMap());
        this.inactiveFrameThreads = new Vector();
        this.finishedRequestStore = new Vector();
        this.managerThread = null;
    }

    public synchronized int getTotalManagedCount() {
        return this.outstandingCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockWhileQueueExceeds(int count) {
        boolean loop = true;
        do {
            Object object = this.outstandingCountLock;
            synchronized (object) {
                if (this.outstandingCount > count) {
                    try {
                        this.outstandingCountLock.wait();
                    }
                    catch (InterruptedException e) {}
                } else {
                    loop = false;
                }
            }
        } while (loop);
    }

    public synchronized boolean addFrameThread(Frame frame) {
        FrameThread2 ft = new FrameThread2(frame, this);
        this.inactiveFrameThreads.add(ft);
        boolean r = true;
        this.startFrameThreads();
        return r;
    }

    private synchronized void startFrameThreads() {
        int frames;
        if (!this.process) {
            return;
        }
        int requests = this.unassignedEncodeRequests.size();
        frames = requests <= (frames = this.inactiveFrameThreads.size()) ? requests : frames;
        for (int i = 0; i < frames; ++i) {
            FrameThread2 ft = this.inactiveFrameThreads.remove(0);
            Thread thread = new Thread(ft);
            this.frameThreadMap.put(ft, thread);
            thread.start();
        }
    }

    public synchronized void notifyFrameThreadExit(FrameThread2 ft) {
        this.frameThreadMap.remove(ft);
        this.inactiveFrameThreads.add(ft);
        this.startFrameThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockEncodeRequest getWaitingRequest() {
        BlockEncodeRequest result = null;
        Object object = this.getLock;
        synchronized (object) {
            boolean loop = true;
            while (loop) {
                try {
                    result = this.unassignedEncodeRequests.poll(500L, TimeUnit.MILLISECONDS);
                    if (result != null) {
                        Object object2 = this.outstandingCountLock;
                        synchronized (object2) {
                            this.outstandingCountLock.notifyAll();
                        }
                        this.orderedEncodeRequests.add(result);
                    }
                    loop = false;
                }
                catch (InterruptedException e) {}
            }
        }
        return result;
    }

    public synchronized void stop() {
        this.process = false;
        BlockEncodeRequest temp = new BlockEncodeRequest();
        temp.setAll(null, -1, -1, -1, -1L, null);
        int count = this.frameThreadMap.size();
        for (int i = 0; i < count; ++i) {
            this.unassignedEncodeRequests.add(temp);
        }
    }

    public synchronized void returnFinishedRequest(BlockEncodeRequest ber) {
        try {
            this.finishedEncodeRequests.put(ber);
            this.restartManager();
        }
        catch (InterruptedException e) {
            this.returnFinishedRequest(ber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        boolean loop = true;
        while (loop) {
            try {
                if (this.nextTarget == null) {
                    this.nextTarget = this.orderedEncodeRequests.poll(500L, TimeUnit.MILLISECONDS);
                }
                if (this.nextTarget == null) {
                    loop = false;
                    continue;
                }
                if (this.nextTarget.frameNumber < 0L) {
                    loop = false;
                    this.nextTarget = null;
                    this.orderedEncodeRequests.clear();
                    continue;
                }
                if (this.finishedRequestStore.remove(this.nextTarget)) {
                    this.encoder.blockFinished(this.nextTarget);
                    this.nextTarget = null;
                    object = this.outstandingCountLock;
                    synchronized (object) {
                        --this.outstandingCount;
                        this.outstandingCountLock.notifyAll();
                        continue;
                    }
                }
                BlockEncodeRequest ber = this.finishedEncodeRequests.poll(500L, TimeUnit.MILLISECONDS);
                if (ber == null) {
                    loop = false;
                    continue;
                }
                if (this.nextTarget == ber) {
                    this.encoder.blockFinished(ber);
                    this.nextTarget = null;
                    Object object2 = this.outstandingCountLock;
                    synchronized (object2) {
                        --this.outstandingCount;
                        this.outstandingCountLock.notifyAll();
                        continue;
                    }
                }
                this.finishedRequestStore.add(ber);
            }
            catch (InterruptedException interruptedException) {}
        }
        object = this;
        synchronized (object) {
            this.managerThread = null;
            this.restartManager();
        }
    }

    private synchronized void restartManager() {
        if (this.managerThread == null && this.orderedEncodeRequests.size() > 0) {
            this.managerThread = new Thread(this);
            this.managerThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addRequest(BlockEncodeRequest ber) {
        this.process = true;
        boolean r = true;
        try {
            this.unassignedEncodeRequests.put(ber);
            Object object = this.outstandingCountLock;
            synchronized (object) {
                ++this.outstandingCount;
            }
            this.startFrameThreads();
        }
        catch (InterruptedException e) {
            r = false;
        }
        return r;
    }
}

