/*
 * Decompiled with CFR 0.152.
 */
package javaFlacEncoder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import javaFlacEncoder.BlockEncodeRequest;
import javaFlacEncoder.FLACEncoder;
import javaFlacEncoder.Frame;
import javaFlacEncoder.FrameThread;

public class BlockThreadManager
implements Runnable,
Thread.UncaughtExceptionHandler {
    LinkedBlockingQueue<Thread> activeFrames = null;
    LinkedBlockingQueue<FrameThread> inactiveFrames = null;
    LinkedBlockingQueue<BlockEncodeRequest> unassignedEncodeRequests = null;
    Map<Thread, FrameThread> frameThreadMap = null;
    volatile Thread managerThread = null;
    ReentrantLock encodingLock = null;
    volatile FLACEncoder encoder = null;

    public BlockThreadManager(FLACEncoder encoder) {
        this.encoder = encoder;
        this.activeFrames = new LinkedBlockingQueue();
        this.inactiveFrames = new LinkedBlockingQueue();
        this.unassignedEncodeRequests = new LinkedBlockingQueue();
        this.frameThreadMap = Collections.synchronizedMap(new HashMap());
        this.managerThread = null;
        this.encodingLock = new ReentrantLock();
    }

    public synchronized int getTotalManagedCount() {
        return this.activeFrames.size() + this.inactiveFrames.size() + this.unassignedEncodeRequests.size();
    }

    public void blockWhileQueueExceeds(int count) {
        int waitingCount = this.unassignedEncodeRequests.size();
        while (waitingCount > count) {
            Thread temp = this.activeFrames.peek();
            try {
                temp.join();
                waitingCount = this.unassignedEncodeRequests.size();
            }
            catch (InterruptedException e) {}
        }
    }

    public synchronized boolean addFrameThread(Frame frame) {
        FrameThread ft = new FrameThread(frame);
        boolean r = true;
        try {
            this.inactiveFrames.put(ft);
            if (this.managerThread == null) {
                this.restartManager();
            }
        }
        catch (InterruptedException e) {
            r = false;
        }
        return r;
    }

    private synchronized boolean assignRequest() {
        boolean result = false;
        BlockEncodeRequest request = this.unassignedEncodeRequests.peek();
        FrameThread frame = this.inactiveFrames.peek();
        if (request != null && frame != null) {
            request = this.unassignedEncodeRequests.poll();
            frame = this.inactiveFrames.poll();
            frame.prepareToEncodeFrame(request);
            Thread thread = new Thread(frame);
            thread.setUncaughtExceptionHandler(this);
            this.frameThreadMap.put(thread, frame);
            try {
                this.activeFrames.put(thread);
                thread.start();
                result = true;
            }
            catch (InterruptedException e) {
                System.err.println("assignRequest: Error! Interrupted");
            }
        }
        return result;
    }

    private synchronized void restartManager() {
        if (this.managerThread == null && (this.unassignedEncodeRequests.size() > 0 || this.activeFrames.size() > 0)) {
            this.managerThread = new Thread(this);
            this.managerThread.start();
        }
    }

    public synchronized boolean addRequest(BlockEncodeRequest ber) {
        boolean r = true;
        try {
            this.unassignedEncodeRequests.put(ber);
            this.assignRequest();
            if (this.managerThread == null) {
                this.restartManager();
            }
        }
        catch (InterruptedException e) {
            r = false;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread topThread = null;
        BlockThreadManager blockThreadManager = this;
        synchronized (blockThreadManager) {
            topThread = this.activeFrames.poll();
        }
        while (topThread != null) {
            try {
                topThread.join();
                blockThreadManager = this;
                synchronized (blockThreadManager) {
                    FrameThread frame = this.frameThreadMap.get(topThread);
                    this.frameThreadMap.remove(topThread);
                    BlockEncodeRequest ber = frame.ber;
                    frame.ber = null;
                    this.inactiveFrames.put(frame);
                    this.assignRequest();
                    this.encoder.blockFinished(ber);
                    topThread = this.activeFrames.poll();
                    if (topThread == null) {
                        this.managerThread = null;
                    }
                }
            }
            catch (InterruptedException e) {
                System.err.println("thread interrupted: ");
            }
        }
        blockThreadManager = this;
        synchronized (blockThreadManager) {
            this.managerThread = null;
            this.restartManager();
        }
    }

    public synchronized Thread getEncodingThread() {
        return this.managerThread;
    }

    public void uncaughtException(Thread t, Throwable e) {
        System.err.println("Exception in thread: " + t.toString());
        e.printStackTrace();
    }
}

