/*
 * Decompiled with CFR 0.152.
 */
package javax.speech.synthesis;

import javax.speech.SpeechEvent;

public class SpeakableEvent
extends SpeechEvent {
    public static final int TOP_OF_QUEUE = 601;
    public static final int SPEAKABLE_STARTED = 602;
    public static final int SPEAKABLE_ENDED = 603;
    public static final int SPEAKABLE_PAUSED = 604;
    public static final int SPEAKABLE_RESUMED = 605;
    public static final int SPEAKABLE_CANCELLED = 606;
    public static final int WORD_STARTED = 607;
    public static final int MARKER_REACHED = 608;
    public static final int ELEMENT_OPEN = 620;
    public static final int ELEMENT_CLOSE = 621;
    public static final int ELEMENT_EMPTY = 622;
    protected String text;
    protected int markerType;
    protected int wordStart;
    protected int wordEnd;

    public SpeakableEvent(Object object, int n) {
        super(object, n);
        this.text = null;
        this.markerType = -1;
        this.wordStart = -1;
        this.wordEnd = -1;
    }

    public SpeakableEvent(Object object, int n, String string, int n2) {
        super(object, n);
        this.text = string;
        this.markerType = n2;
        this.wordStart = -1;
        this.wordEnd = -1;
    }

    public SpeakableEvent(Object object, int n, String string, int n2, int n3) {
        super(object, n);
        this.text = string;
        this.markerType = -1;
        this.wordStart = n2;
        this.wordEnd = n3;
    }

    public int getMarkerType() {
        return this.markerType;
    }

    public String getText() {
        return this.text;
    }

    public int getWordEnd() {
        return this.wordEnd;
    }

    public int getWordStart() {
        return this.wordStart;
    }

    public String paramString() {
        switch (this.id) {
            case 601: {
                return "TOP_OF_QUEUE";
            }
            case 602: {
                return "SPEAKABLE_STARTED";
            }
            case 603: {
                return "SPEAKABLE_ENDED";
            }
            case 604: {
                return "SPEAKABLE_PAUSED";
            }
            case 605: {
                return "SPEAKABLE_RESUMED";
            }
            case 606: {
                return "SPEAKABLE_CANCELLED";
            }
            case 607: {
                return "WORD_STARTED \"" + this.text + "\" from: " + this.wordStart + " to: " + this.wordEnd;
            }
            case 608: {
                StringBuffer stringBuffer = new StringBuffer("MARKER_REACHED: ");
                stringBuffer.append("\"" + this.text + "\" at ");
                switch (this.markerType) {
                    case 620: {
                        stringBuffer.append("ELEMENT_OPEN");
                        break;
                    }
                    case 621: {
                        stringBuffer.append("ELEMENT_CLOSE");
                        break;
                    }
                    case 622: {
                        stringBuffer.append("ELEMENT_EMPTY");
                        break;
                    }
                    default: {
                        stringBuffer.append("unknown type");
                    }
                }
                return stringBuffer.toString();
            }
        }
        return super.paramString();
    }
}

