/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vietocr;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import net.sf.ghost4j.Ghostscript;
import net.sf.ghost4j.GhostscriptException;
import net.sourceforge.vietocr.ImageIOHelper;

public class PdfUtilities {
    public static final String GS_INSTALL = "\nPlease download, install GPL Ghostscript from http://sourceforge.net/projects/ghostscript/files\nand/or set the appropriate environment variable.";

    public static File convertPdf2Tiff(File file) throws IOException {
        File[] fileArray = null;
        try {
            fileArray = PdfUtilities.convertPdf2Png(file);
            File file2 = File.createTempFile("multipage", ".tif");
            ImageIOHelper.mergeTiff(fileArray, file2);
            File file3 = file2;
            return file3;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new RuntimeException(PdfUtilities.getMessage(unsatisfiedLinkError.getMessage()));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new RuntimeException(PdfUtilities.getMessage(noClassDefFoundError.getMessage()));
        }
        finally {
            if (fileArray != null) {
                for (File file4 : fileArray) {
                    file4.delete();
                }
            }
        }
    }

    public static File[] convertPdf2Png(File file) {
        Object object;
        File file2 = file.getParentFile();
        if (file2 == null) {
            object = System.getProperty("user.dir");
            file2 = new File((String)object);
        }
        object = Ghostscript.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-gs");
        arrayList.add("-dNOPAUSE");
        arrayList.add("-dBATCH");
        arrayList.add("-dSAFER");
        arrayList.add("-sDEVICE=pnggray");
        arrayList.add("-r300");
        arrayList.add("-dGraphicsAlphaBits=4");
        arrayList.add("-dTextAlphaBits=4");
        arrayList.add("-sOutputFile=" + file2.getPath() + "/workingimage%03d.png");
        arrayList.add(file.getPath());
        try {
            object.initialize(arrayList.toArray(new String[0]));
            object.exit();
        }
        catch (GhostscriptException ghostscriptException) {
            System.err.println("ERROR: " + ghostscriptException.getMessage());
        }
        File[] fileArray = file2.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.toLowerCase().matches("workingimage\\d{3}\\.png$");
            }
        });
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return file.getName().compareTo(file2.getName());
            }
        });
        return fileArray;
    }

    public static void splitPdf(String string, String string2, String string3, String string4) {
        Ghostscript ghostscript = Ghostscript.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-gs");
        arrayList.add("-dNOPAUSE");
        arrayList.add("-dQUIET");
        arrayList.add("-dBATCH");
        arrayList.add("-sDEVICE=pdfwrite");
        if (!string3.trim().isEmpty()) {
            arrayList.add("-dFirstPage=" + string3);
        }
        if (!string4.trim().isEmpty()) {
            arrayList.add("-dLastPage=" + string4);
        }
        arrayList.add("-sOutputFile=" + string2);
        arrayList.add(string);
        try {
            ghostscript.initialize(arrayList.toArray(new String[0]));
            ghostscript.exit();
        }
        catch (GhostscriptException ghostscriptException) {
            System.err.println("ERROR: " + ghostscriptException.getMessage());
            throw new RuntimeException(ghostscriptException.getMessage());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new RuntimeException(PdfUtilities.getMessage(unsatisfiedLinkError.getMessage()));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new RuntimeException(PdfUtilities.getMessage(noClassDefFoundError.getMessage()));
        }
    }

    public static int getPdfPageCount(String string) {
        Ghostscript ghostscript = Ghostscript.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-gs");
        arrayList.add("-dNOPAUSE");
        arrayList.add("-dQUIET");
        arrayList.add("-dBATCH");
        arrayList.add("-sPDFname=" + string);
        arrayList.add("lib/pdfpagecount.ps");
        int n = 0;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            ghostscript.setStdOut((OutputStream)byteArrayOutputStream);
            ghostscript.initialize(arrayList.toArray(new String[0]));
            n = Integer.parseInt(byteArrayOutputStream.toString().replace("%%Pages: ", ""));
            byteArrayOutputStream.close();
        }
        catch (GhostscriptException ghostscriptException) {
            System.err.println("ERROR: " + ghostscriptException.getMessage());
        }
        catch (Exception exception) {
            System.err.println("ERROR: " + exception.getMessage());
        }
        return n;
    }

    public static void mergePdf(File[] fileArray, File file) {
        Ghostscript ghostscript = Ghostscript.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-gs");
        arrayList.add("-dNOPAUSE");
        arrayList.add("-dQUIET");
        arrayList.add("-dBATCH");
        arrayList.add("-sDEVICE=pdfwrite");
        arrayList.add("-sOutputFile=" + file.getPath());
        for (File file2 : fileArray) {
            arrayList.add(file2.getPath());
        }
        try {
            ghostscript.initialize(arrayList.toArray(new String[0]));
            ghostscript.exit();
        }
        catch (GhostscriptException ghostscriptException) {
            System.err.println("ERROR: " + ghostscriptException.getMessage());
            throw new RuntimeException(ghostscriptException.getMessage());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new RuntimeException(PdfUtilities.getMessage(unsatisfiedLinkError.getMessage()));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new RuntimeException(PdfUtilities.getMessage(noClassDefFoundError.getMessage()));
        }
    }

    static String getMessage(String string) {
        if (string.contains("library 'gs") || string.contains("ghost4j")) {
            return string + GS_INSTALL;
        }
        return string;
    }
}

