/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vietocr;

import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFImageWriteParam;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import net.sourceforge.vietocr.PdfUtilities;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageIOHelper {
    static final String OUTPUT_FILE_NAME = "Tesstmp";
    static final String TIFF_EXT = ".tif";
    static final String TIFF_FORMAT = "tiff";

    public static List<File> createTiffFiles(File file, int n) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = file.getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string2);
        ImageReader imageReader = iterator.next();
        if (imageReader == null) {
            throw new RuntimeException("Need to install JAI Image I/O package.\nhttps://jai-imageio.dev.java.net");
        }
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
        imageReader.setInput(imageInputStream);
        TIFFImageWriteParam tIFFImageWriteParam = new TIFFImageWriteParam(Locale.US);
        tIFFImageWriteParam.setCompressionMode(0);
        Iterator<ImageWriter> iterator2 = ImageIO.getImageWritersByFormatName(TIFF_FORMAT);
        ImageWriter imageWriter = iterator2.next();
        IIOMetadata iIOMetadata = imageWriter.getDefaultStreamMetadata((ImageWriteParam)tIFFImageWriteParam);
        int n2 = imageReader.getNumImages(true);
        for (int i = 0; i < n2; ++i) {
            if (n != -1 && i != n) continue;
            IIOImage iIOImage = imageReader.readAll(i, imageReader.getDefaultReadParam());
            File file2 = File.createTempFile(OUTPUT_FILE_NAME, TIFF_EXT);
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file2);
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(iIOMetadata, iIOImage, (ImageWriteParam)tIFFImageWriteParam);
            imageOutputStream.close();
            arrayList.add(file2);
        }
        imageWriter.dispose();
        imageReader.dispose();
        return arrayList;
    }

    public static List<File> createTiffFiles(List<IIOImage> list, int n) throws IOException {
        return ImageIOHelper.createTiffFiles(list, n, 0, 0);
    }

    public static List<File> createTiffFiles(List<IIOImage> list, int n, int n2, int n3) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        TIFFImageWriteParam tIFFImageWriteParam = new TIFFImageWriteParam(Locale.US);
        tIFFImageWriteParam.setCompressionMode(0);
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(TIFF_FORMAT);
        ImageWriter imageWriter = iterator.next();
        if (imageWriter == null) {
            throw new RuntimeException("Need to install JAI Image I/O package.\nhttps://jai-imageio.dev.java.net");
        }
        IIOMetadata iIOMetadata = imageWriter.getDefaultStreamMetadata((ImageWriteParam)tIFFImageWriteParam);
        for (IIOImage iIOImage : n == -1 ? list : list.subList(n, n + 1)) {
            Object object;
            Object object2;
            if (n2 != 0 && n3 != 0) {
                object2 = ImageTypeSpecifier.createFromRenderedImage(iIOImage.getRenderedImage());
                object = imageWriter.getDefaultImageMetadata((ImageTypeSpecifier)object2, null);
                object = ImageIOHelper.setDPIViaAPI((IIOMetadata)object, n2, n3);
                iIOImage.setMetadata((IIOMetadata)object);
            }
            object2 = File.createTempFile(OUTPUT_FILE_NAME, TIFF_EXT);
            object = ImageIO.createImageOutputStream(object2);
            imageWriter.setOutput(object);
            imageWriter.write(iIOMetadata, iIOImage, (ImageWriteParam)tIFFImageWriteParam);
            object.close();
            arrayList.add((File)object2);
        }
        imageWriter.dispose();
        return arrayList;
    }

    private static IIOMetadata setDPIViaAPI(IIOMetadata iIOMetadata, int n, int n2) throws IIOInvalidTreeException {
        TIFFDirectory tIFFDirectory = TIFFDirectory.createFromMetadata((IIOMetadata)iIOMetadata);
        BaselineTIFFTagSet baselineTIFFTagSet = BaselineTIFFTagSet.getInstance();
        TIFFTag tIFFTag = baselineTIFFTagSet.getTag(282);
        TIFFTag tIFFTag2 = baselineTIFFTagSet.getTag(283);
        TIFFField tIFFField = new TIFFField(tIFFTag, 5, 1, (Object)new long[][]{{n, 1L}});
        TIFFField tIFFField2 = new TIFFField(tIFFTag2, 5, 1, (Object)new long[][]{{n2, 1L}});
        tIFFDirectory.addTIFFField(tIFFField);
        tIFFDirectory.addTIFFField(tIFFField2);
        return tIFFDirectory.getAsMetadata();
    }

    public static ByteBuffer getImageByteBuffer(IIOImage iIOImage) throws IOException {
        TIFFImageWriteParam tIFFImageWriteParam = new TIFFImageWriteParam(Locale.US);
        tIFFImageWriteParam.setCompressionMode(0);
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(TIFF_FORMAT);
        ImageWriter imageWriter = iterator.next();
        if (imageWriter == null) {
            throw new RuntimeException("Need to install JAI Image I/O package.\nhttps://jai-imageio.dev.java.net");
        }
        IIOMetadata iIOMetadata = imageWriter.getDefaultStreamMetadata((ImageWriteParam)tIFFImageWriteParam);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(iIOMetadata, new IIOImage(iIOImage.getRenderedImage(), null, null), (ImageWriteParam)tIFFImageWriteParam);
        imageWriter.dispose();
        imageOutputStream.seek(0L);
        BufferedImage bufferedImage = ImageIO.read(imageOutputStream);
        return ImageIOHelper.convertImageData(bufferedImage);
    }

    public static ByteBuffer convertImageData(BufferedImage bufferedImage) {
        byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.put(byArray);
        byteBuffer.flip();
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IIOImage> getIIOImageList(File file) throws IOException {
        File file2 = null;
        ImageReader imageReader = null;
        ImageInputStream imageInputStream = null;
        try {
            if (file.getName().toLowerCase().endsWith(".pdf")) {
                file = file2 = PdfUtilities.convertPdf2Tiff(file);
            }
            ArrayList<IIOImage> arrayList = new ArrayList<IIOImage>();
            String string = file.getName();
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            if (string2.matches("(pbm|pgm|ppm)")) {
                string2 = "pnm";
            } else if (string2.equals("jp2")) {
                string2 = "jpeg2000";
            }
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string2);
            imageReader = iterator.next();
            if (imageReader == null) {
                throw new RuntimeException("Need to install JAI Image I/O package.\nhttps://jai-imageio.dev.java.net");
            }
            imageInputStream = ImageIO.createImageInputStream(file);
            imageReader.setInput(imageInputStream);
            int n = imageReader.getNumImages(true);
            for (int i = 0; i < n; ++i) {
                IIOImage iIOImage = imageReader.readAll(i, imageReader.getDefaultReadParam());
                arrayList.add(iIOImage);
            }
            ArrayList<IIOImage> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            try {
                if (imageInputStream != null) {
                    imageInputStream.close();
                }
                if (imageReader != null) {
                    imageReader.dispose();
                }
            }
            catch (Exception exception) {}
            if (file2 != null && file2.exists()) {
                file2.delete();
            }
        }
    }

    public static void mergeTiff(File[] fileArray, File file) throws IOException {
        ArrayList<IIOImage> arrayList = new ArrayList<IIOImage>();
        for (int i = 0; i < fileArray.length; ++i) {
            arrayList.addAll(ImageIOHelper.getIIOImageList(fileArray[i]));
        }
        if (arrayList.isEmpty()) {
            return;
        }
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(TIFF_FORMAT);
        ImageWriter imageWriter = iterator.next();
        TIFFImageWriteParam tIFFImageWriteParam = new TIFFImageWriteParam(Locale.US);
        tIFFImageWriteParam.setCompressionMode(0);
        IIOMetadata iIOMetadata = imageWriter.getDefaultStreamMetadata((ImageWriteParam)tIFFImageWriteParam);
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file);
        imageWriter.setOutput(imageOutputStream);
        IIOImage iIOImage = (IIOImage)arrayList.remove(0);
        imageWriter.write(iIOMetadata, iIOImage, (ImageWriteParam)tIFFImageWriteParam);
        int n = 1;
        for (IIOImage iIOImage2 : arrayList) {
            imageWriter.writeInsert(n++, iIOImage2, (ImageWriteParam)tIFFImageWriteParam);
        }
        imageOutputStream.close();
        imageWriter.dispose();
    }

    public static Map<String, String> readImageData(IIOImage iIOImage) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        IIOMetadata iIOMetadata = iIOImage.getMetadata();
        if (iIOMetadata != null) {
            int n;
            int n2;
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree("javax_imageio_1.0");
            NodeList nodeList = iIOMetadataNode.getElementsByTagName("HorizontalPixelSize");
            if (nodeList.getLength() > 0) {
                float f = Float.parseFloat(nodeList.item(0).getAttributes().item(0).getNodeValue());
                n2 = Math.round(25.4f / f);
            } else {
                n2 = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            hashMap.put("dpiX", String.valueOf(n2));
            nodeList = iIOMetadataNode.getElementsByTagName("VerticalPixelSize");
            if (nodeList.getLength() > 0) {
                float f = Float.parseFloat(nodeList.item(0).getAttributes().item(0).getNodeValue());
                n = Math.round(25.4f / f);
            } else {
                n = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            hashMap.put("dpiY", String.valueOf(n));
        }
        return hashMap;
    }
}

