/*
 * Decompiled with CFR 0.152.
 */
package wiiusej.test;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import wiiusej.WiiUseApiManager;
import wiiusej.Wiimote;
import wiiusej.test.ClassicControllerGuiTest;
import wiiusej.test.CloseGuiTestCleanly;
import wiiusej.test.GuitarHero3GuiTest;
import wiiusej.test.NunchukGuiTest;
import wiiusej.utils.AccelerationPanel;
import wiiusej.utils.AccelerationWiimoteEventPanel;
import wiiusej.utils.ButtonsEventPanel;
import wiiusej.utils.GForcePanel;
import wiiusej.utils.GForceWiimoteEventPanel;
import wiiusej.utils.IRPanel;
import wiiusej.utils.OrientationPanel;
import wiiusej.utils.OrientationWiimoteEventPanel;
import wiiusej.wiiusejevents.physicalevents.ExpansionEvent;
import wiiusej.wiiusejevents.physicalevents.IREvent;
import wiiusej.wiiusejevents.physicalevents.MotionSensingEvent;
import wiiusej.wiiusejevents.physicalevents.WiimoteButtonsEvent;
import wiiusej.wiiusejevents.utils.WiimoteListener;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.ClassicControllerRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.DisconnectionEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.GuitarHeroRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukInsertedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.NunchukRemovedEvent;
import wiiusej.wiiusejevents.wiiuseapievents.StatusEvent;

public class WiiuseJGuiTest
extends JFrame
implements WiimoteListener {
    private Wiimote wiimote;
    private Robot robot = null;
    private boolean statusMotionRequested = false;
    private boolean statusIRRequested = false;
    private JFrame expansionFrame = null;
    private boolean isFirstStatusGot = false;
    private WindowListener buttonSetter = new WindowListener(){

        public void windowOpened(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
            WiiuseJGuiTest.this.showExpansionWiimoteButton.setEnabled(false);
            if (WiiuseJGuiTest.this.expansionFrame instanceof NunchukGuiTest) {
                WiiuseJGuiTest.this.showExpansionWiimoteButton.setText("Hide Nunchuk");
            } else if (WiiuseJGuiTest.this.expansionFrame instanceof GuitarHero3GuiTest) {
                WiiuseJGuiTest.this.showExpansionWiimoteButton.setText("Hide Guitar");
            } else if (WiiuseJGuiTest.this.expansionFrame instanceof ClassicControllerGuiTest) {
                WiiuseJGuiTest.this.showExpansionWiimoteButton.setText("Hide Classic Controller");
            }
        }

        public void windowDeactivated(WindowEvent e) {
            WiiuseJGuiTest.this.showExpansionWiimoteButton.setEnabled(true);
            if (WiiuseJGuiTest.this.expansionFrame instanceof NunchukGuiTest) {
                WiiuseJGuiTest.this.showExpansionWiimoteButton.setText("Show Nunchuk");
            } else if (WiiuseJGuiTest.this.expansionFrame instanceof GuitarHero3GuiTest) {
                WiiuseJGuiTest.this.showExpansionWiimoteButton.setText("Show Guitar");
            } else if (WiiuseJGuiTest.this.expansionFrame instanceof ClassicControllerGuiTest) {
                WiiuseJGuiTest.this.showExpansionWiimoteButton.setText("Show Classic controller");
            }
        }
    };
    private JPanel accelerationPanel;
    private JButton accelerationThresholdButton;
    private JTextField accelerationThresholdTextField;
    private JPanel activateMotionSensingPanel;
    private JPanel activateRumbleIRPanel;
    private JPanel activateSmoothingContinuousPanel;
    private JButton alphaSmoothingButton;
    private JTextField alphaSmoothingTextField;
    private JLabel batteryLevelText;
    private JLabel batteryText;
    private JPanel buttonsPanel;
    private JPanel controlsPanel;
    private JPanel exPansionPanel;
    private JPanel expansionButtonPanel;
    private JSpinner expansionHandshakeTimeoutSpinner;
    private JLabel expansionHandshakeTimeoutText;
    private JLabel expansionText;
    private JPanel fixedWiimotePanel;
    private JPanel gForcePanel;
    private JButton getStatusButton;
    private JPanel getStatusPanel;
    private JPanel irViewPanel;
    private JTabbedPane jTabbedPane1;
    private JButton led1Button;
    private JButton led2Button;
    private JButton led3Button;
    private JButton led4Button;
    private JPanel leftPanel;
    private JLabel messageLabelText;
    private JLabel messageText;
    private JPanel messagesPanel;
    private JPanel motionSensingPanel;
    private JButton mouseIRControlButton;
    private JSpinner normalTimeoutSpinner;
    private JLabel normalTimeoutText;
    private JButton orientationThresholdButton;
    private JTextField orientationThresholdTextField;
    private JButton reconnectWiimotesButton;
    private JPanel rightPanel;
    private JPanel setAccelerationThresholdPanel;
    private JPanel setAlphaSmoothingPanel;
    private JPanel setIRConfPanel;
    private JButton setIrSensitivyButton;
    private JPanel setIrSensitivyPanel;
    private JSpinner setIrSensitivySpinner;
    private JButton setLedsButton;
    private JPanel setLedsPanel;
    private JPanel setOrientationThresholdPanel;
    private JButton setTimeoutButton;
    private JPanel setTimeoutPanel;
    private JButton setVirtualResolutionButton;
    private JPanel setVirtualResolutionPanel;
    private JButton showExpansionWiimoteButton;
    private JPanel startMouseControlPanel;
    private JButton toggleContinuousButton;
    private JButton toggleIRTrackingButton;
    private JButton toggleMotionSensingTrackingButton;
    private JButton toggleRumbleButton;
    private JButton toggleScreenAspectRatioButton;
    private JButton toggleSensorBarPositionButton;
    private JButton toggleSmoothingButton;
    private JLabel xLabel;
    private JTextField xResolutionTextField;
    private JLabel yLabel;
    private JTextField yResolutionTextField;

    public WiiuseJGuiTest() {
        this.initComponents();
        this.addWindowListener(new CloseGuiTestCleanly());
    }

    public WiiuseJGuiTest(Wiimote wiimote) {
        this.initComponents();
        this.addWindowListener(new CloseGuiTestCleanly());
        if (wiimote != null) {
            this.wiimote = wiimote;
            this.registerListeners();
            this.initWiimote();
            this.isFirstStatusGot = false;
            this.getStatusButtonMousePressed(null);
        }
    }

    private void clearViews() {
        ((IRPanel)this.irViewPanel).clearView();
        ((ButtonsEventPanel)this.buttonsPanel).clearView();
        ((OrientationPanel)this.motionSensingPanel).clearView();
        ((GForcePanel)this.gForcePanel).clearView();
        ((AccelerationPanel)this.accelerationPanel).clearView();
    }

    private void unregisterListeners() {
        this.wiimote.removeWiiMoteEventListeners((IRPanel)this.irViewPanel);
        this.wiimote.removeWiiMoteEventListeners((ButtonsEventPanel)this.buttonsPanel);
        this.wiimote.removeWiiMoteEventListeners((OrientationPanel)this.motionSensingPanel);
        this.wiimote.removeWiiMoteEventListeners((GForcePanel)this.gForcePanel);
        this.wiimote.removeWiiMoteEventListeners((AccelerationPanel)this.accelerationPanel);
        this.wiimote.removeWiiMoteEventListeners(this);
    }

    private void initWiimote() {
        this.wiimote.deactivateContinuous();
        this.wiimote.deactivateSmoothing();
        this.wiimote.setScreenAspectRatio169();
        this.wiimote.setSensorBarBelowScreen();
    }

    private void registerListeners() {
        this.wiimote.addWiiMoteEventListeners((IRPanel)this.irViewPanel);
        this.wiimote.addWiiMoteEventListeners((ButtonsEventPanel)this.buttonsPanel);
        this.wiimote.addWiiMoteEventListeners((OrientationPanel)this.motionSensingPanel);
        this.wiimote.addWiiMoteEventListeners((GForcePanel)this.gForcePanel);
        this.wiimote.addWiiMoteEventListeners((AccelerationPanel)this.accelerationPanel);
        this.wiimote.addWiiMoteEventListeners(this);
    }

    public void onButtonsEvent(WiimoteButtonsEvent arg0) {
        if (this.robot != null) {
            if (arg0.isButtonAPressed()) {
                this.robot.mousePress(16);
            }
            if (arg0.isButtonBPressed()) {
                this.robot.mousePress(8);
            }
            if (arg0.isButtonOnePressed()) {
                this.robot.mousePress(4);
            }
            if (arg0.isButtonAJustReleased()) {
                this.robot.mouseRelease(16);
            }
            if (arg0.isButtonBJustReleased()) {
                this.robot.mouseRelease(8);
            }
            if (arg0.isButtonOneJustReleased()) {
                this.robot.mouseRelease(4);
            }
            if (arg0.isButtonUpPressed()) {
                this.robot.mouseWheel(-1);
            }
            if (arg0.isButtonDownPressed()) {
                this.robot.mouseWheel(1);
            }
            if (arg0.isButtonTwoPressed()) {
                this.mouseIRControlButtonMousePressed(null);
            }
        }
    }

    public void onIrEvent(IREvent arg0) {
        if (this.robot != null) {
            this.robot.mouseMove(arg0.getX(), arg0.getY());
        }
        if (this.statusIRRequested) {
            this.xResolutionTextField.setText("" + arg0.getXVRes());
            this.yResolutionTextField.setText("" + arg0.getYVRes());
            this.statusIRRequested = false;
        }
    }

    public void onMotionSensingEvent(MotionSensingEvent arg0) {
        if (this.statusMotionRequested) {
            this.accelerationThresholdTextField.setText("" + arg0.getAccelerationThreshold());
            this.orientationThresholdTextField.setText("" + arg0.getOrientationThreshold());
            this.alphaSmoothingTextField.setText("" + arg0.getAlphaSmoothing());
            this.statusMotionRequested = false;
        }
    }

    public void onExpansionEvent(ExpansionEvent e) {
    }

    public void onStatusEvent(StatusEvent arg0) {
        int eventType;
        if (!this.isFirstStatusGot) {
            if (arg0.isNunchukConnected()) {
                this.showExpansionWiimoteButton.setEnabled(true);
                this.showExpansionWiimoteButton.setText("Show Nunchuk");
                this.expansionFrame = new NunchukGuiTest(this.wiimote);
                this.expansionFrame.setDefaultCloseOperation(1);
                this.expansionFrame.addWindowListener(this.buttonSetter);
                this.isFirstStatusGot = true;
            } else if (arg0.isClassicControllerConnected()) {
                this.showExpansionWiimoteButton.setEnabled(true);
                this.showExpansionWiimoteButton.setText("Show Classic Controller");
                this.expansionFrame = new ClassicControllerGuiTest(this.wiimote);
                this.expansionFrame.setDefaultCloseOperation(1);
                this.expansionFrame.addWindowListener(this.buttonSetter);
                this.isFirstStatusGot = true;
            } else if (arg0.isGuitarHeroConnected()) {
                this.showExpansionWiimoteButton.setEnabled(true);
                this.showExpansionWiimoteButton.setText("Show Guitar Hero 3 Controller");
                this.expansionFrame = new GuitarHero3GuiTest(this.wiimote);
                this.expansionFrame.setDefaultCloseOperation(1);
                this.expansionFrame.addWindowListener(this.buttonSetter);
                this.isFirstStatusGot = true;
            }
        }
        this.messageText.setText("Status received !");
        this.batteryLevelText.setText(String.valueOf(arg0.getBatteryLevel()) + " %");
        this.led1Button.setEnabled(arg0.isLed1Set());
        this.led2Button.setEnabled(arg0.isLed2Set());
        this.led3Button.setEnabled(arg0.isLed3Set());
        this.led4Button.setEnabled(arg0.isLed4Set());
        if (arg0.isNunchukConnected()) {
            ((NunchukGuiTest)this.expansionFrame).requestThresholdsUpdate();
        }
        if ((eventType = arg0.getEventType()) == StatusEvent.WIIUSE_CLASSIC_CTRL_INSERTED) {
            this.expansionText.setText("Classic control connected.");
        } else if (eventType == StatusEvent.WIIUSE_CLASSIC_CTRL_REMOVED) {
            this.expansionText.setText("Classic control removed.");
        } else if (eventType == StatusEvent.WIIUSE_NUNCHUK_INSERTED) {
            this.expansionText.setText("Nunchuk connected.");
        } else if (eventType == StatusEvent.WIIUSE_NUNCHUK_REMOVED) {
            this.expansionText.setText("Nunchuk removed.");
        } else if (eventType == StatusEvent.WIIUSE_GUITAR_HERO_3_CTRL_INSERTED) {
            this.expansionText.setText("Guitar Hero 3 control connected.");
        } else if (eventType == StatusEvent.WIIUSE_GUITAR_HERO_3_CTRL_REMOVED) {
            this.expansionText.setText("Guitar Hero 3 control removed.");
        }
    }

    public void onDisconnectionEvent(DisconnectionEvent arg0) {
        this.messageText.setText("Wiimote Disconnected !");
        this.unregisterListeners();
        this.clearViews();
        this.isFirstStatusGot = false;
    }

    public void onNunchukInsertedEvent(NunchukInsertedEvent e) {
        this.messageText.setText("Nunchuk connected !");
        this.expansionText.setText("Expansion connected : Nunchuk.");
        this.showExpansionWiimoteButton.setEnabled(true);
        this.showExpansionWiimoteButton.setText("Show nunchuk");
        this.expansionFrame = new NunchukGuiTest(this.wiimote);
        this.expansionFrame.setDefaultCloseOperation(1);
        this.expansionFrame.addWindowListener(this.buttonSetter);
    }

    public void onNunchukRemovedEvent(NunchukRemovedEvent e) {
        this.messageText.setText("Nunchuk disconnected !");
        this.expansionText.setText("No expansion connected.");
        this.showExpansionWiimoteButton.setEnabled(false);
        this.showExpansionWiimoteButton.setText("No expansion");
        if (this.expansionFrame != null) {
            if (this.expansionFrame instanceof NunchukGuiTest) {
                ((NunchukGuiTest)this.expansionFrame).unRegisterListeners();
            }
            this.expansionFrame.setEnabled(false);
            this.expansionFrame.dispose();
            this.expansionFrame = null;
        }
    }

    public void onGuitarHeroInsertedEvent(GuitarHeroInsertedEvent arg0) {
        this.messageText.setText("Guitar Hero 3 connected !");
        this.expansionText.setText("Expansion connected : Guitar Hero 3.");
        this.showExpansionWiimoteButton.setEnabled(true);
        this.showExpansionWiimoteButton.setText("Show Guitar Hero 3");
        this.expansionFrame = new GuitarHero3GuiTest(this.wiimote);
        this.expansionFrame.setDefaultCloseOperation(1);
        this.expansionFrame.addWindowListener(this.buttonSetter);
    }

    public void onGuitarHeroRemovedEvent(GuitarHeroRemovedEvent arg0) {
        this.messageText.setText("Guitar Hero 3 disconnected !");
        this.expansionText.setText("No expansion connected.");
        this.showExpansionWiimoteButton.setEnabled(false);
        this.showExpansionWiimoteButton.setText("No expansion");
        if (this.expansionFrame != null) {
            if (this.expansionFrame instanceof GuitarHero3GuiTest) {
                ((GuitarHero3GuiTest)this.expansionFrame).unRegisterListeners();
            }
            this.expansionFrame.setEnabled(false);
            this.expansionFrame.dispose();
            this.expansionFrame = null;
        }
    }

    public void onClassicControllerInsertedEvent(ClassicControllerInsertedEvent arg0) {
        this.messageText.setText("Classic controller connected !");
        this.expansionText.setText("Expansion connected : Classic Controller.");
        this.showExpansionWiimoteButton.setEnabled(true);
        this.showExpansionWiimoteButton.setText("Show Classic Controller");
        this.expansionFrame = new ClassicControllerGuiTest(this.wiimote);
        this.expansionFrame.setDefaultCloseOperation(1);
        this.expansionFrame.addWindowListener(this.buttonSetter);
    }

    public void onClassicControllerRemovedEvent(ClassicControllerRemovedEvent arg0) {
        this.messageText.setText("Classic controller disconnected !");
        this.expansionText.setText("No expansion connected.");
        this.showExpansionWiimoteButton.setEnabled(false);
        this.showExpansionWiimoteButton.setText("No expansion");
        if (this.expansionFrame != null) {
            if (this.expansionFrame instanceof ClassicControllerGuiTest) {
                ((ClassicControllerGuiTest)this.expansionFrame).unRegisterListeners();
            }
            this.expansionFrame.setEnabled(false);
            this.expansionFrame.dispose();
            this.expansionFrame = null;
        }
    }

    private void initComponents() {
        this.leftPanel = new JPanel();
        this.irViewPanel = new IRPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.accelerationPanel = new AccelerationWiimoteEventPanel();
        this.motionSensingPanel = new OrientationWiimoteEventPanel();
        this.gForcePanel = new GForceWiimoteEventPanel();
        this.rightPanel = new JPanel();
        this.fixedWiimotePanel = new JPanel();
        this.buttonsPanel = new ButtonsEventPanel();
        this.controlsPanel = new JPanel();
        this.activateRumbleIRPanel = new JPanel();
        this.toggleRumbleButton = new JButton();
        this.toggleIRTrackingButton = new JButton();
        this.activateMotionSensingPanel = new JPanel();
        this.toggleMotionSensingTrackingButton = new JButton();
        this.activateSmoothingContinuousPanel = new JPanel();
        this.toggleSmoothingButton = new JButton();
        this.toggleContinuousButton = new JButton();
        this.setLedsPanel = new JPanel();
        this.led1Button = new JButton();
        this.led2Button = new JButton();
        this.led3Button = new JButton();
        this.led4Button = new JButton();
        this.setLedsButton = new JButton();
        this.setAlphaSmoothingPanel = new JPanel();
        this.alphaSmoothingTextField = new JTextField();
        this.alphaSmoothingButton = new JButton();
        this.setOrientationThresholdPanel = new JPanel();
        this.orientationThresholdTextField = new JTextField();
        this.orientationThresholdButton = new JButton();
        this.setAccelerationThresholdPanel = new JPanel();
        this.accelerationThresholdTextField = new JTextField();
        this.accelerationThresholdButton = new JButton();
        this.getStatusPanel = new JPanel();
        this.getStatusButton = new JButton();
        this.batteryText = new JLabel();
        this.batteryLevelText = new JLabel();
        this.setIrSensitivyPanel = new JPanel();
        this.setIrSensitivySpinner = new JSpinner();
        this.setIrSensitivyButton = new JButton();
        this.setTimeoutButton = new JButton();
        this.setTimeoutPanel = new JPanel();
        this.normalTimeoutSpinner = new JSpinner();
        this.normalTimeoutText = new JLabel();
        this.expansionHandshakeTimeoutSpinner = new JSpinner();
        this.expansionHandshakeTimeoutText = new JLabel();
        this.setIRConfPanel = new JPanel();
        this.toggleSensorBarPositionButton = new JButton();
        this.toggleScreenAspectRatioButton = new JButton();
        this.setVirtualResolutionPanel = new JPanel();
        this.xLabel = new JLabel();
        this.xResolutionTextField = new JTextField();
        this.yLabel = new JLabel();
        this.yResolutionTextField = new JTextField();
        this.setVirtualResolutionButton = new JButton();
        this.startMouseControlPanel = new JPanel();
        this.mouseIRControlButton = new JButton();
        this.exPansionPanel = new JPanel();
        this.expansionText = new JLabel();
        this.expansionButtonPanel = new JPanel();
        this.showExpansionWiimoteButton = new JButton();
        this.showExpansionWiimoteButton.setEnabled(false);
        this.messagesPanel = new JPanel();
        this.reconnectWiimotesButton = new JButton();
        this.messageLabelText = new JLabel();
        this.messageText = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("WiiuseJ Test GUI");
        this.setName("WiiuseJ Test GUI");
        this.leftPanel.setBorder(BorderFactory.createEtchedBorder());
        this.irViewPanel.setBackground(new Color(0, 0, 0));
        this.irViewPanel.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(0, 153, 153), 2, true), "IR View", 0, 0, new Font("Tahoma", 0, 11), new Color(255, 0, 51)));
        this.irViewPanel.setToolTipText("IREvent");
        GroupLayout irViewPanelLayout = new GroupLayout(this.irViewPanel);
        this.irViewPanel.setLayout(irViewPanelLayout);
        irViewPanelLayout.setHorizontalGroup(irViewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 272, Short.MAX_VALUE));
        irViewPanelLayout.setVerticalGroup(irViewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 299, Short.MAX_VALUE));
        this.accelerationPanel.setToolTipText("MotionSensingEvent");
        GroupLayout accelerationPanelLayout = new GroupLayout(this.accelerationPanel);
        this.accelerationPanel.setLayout(accelerationPanelLayout);
        accelerationPanelLayout.setHorizontalGroup(accelerationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 279, Short.MAX_VALUE));
        accelerationPanelLayout.setVerticalGroup(accelerationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 213, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("Acceleration", this.accelerationPanel);
        GroupLayout motionSensingPanelLayout = new GroupLayout(this.motionSensingPanel);
        this.motionSensingPanel.setLayout(motionSensingPanelLayout);
        motionSensingPanelLayout.setHorizontalGroup(motionSensingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 279, Short.MAX_VALUE));
        motionSensingPanelLayout.setVerticalGroup(motionSensingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 213, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("Orientation", this.motionSensingPanel);
        GroupLayout gForcePanelLayout = new GroupLayout(this.gForcePanel);
        this.gForcePanel.setLayout(gForcePanelLayout);
        gForcePanelLayout.setHorizontalGroup(gForcePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 279, Short.MAX_VALUE));
        gForcePanelLayout.setVerticalGroup(gForcePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 213, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("GForce", this.gForcePanel);
        GroupLayout leftPanelLayout = new GroupLayout(this.leftPanel);
        this.leftPanel.setLayout(leftPanelLayout);
        leftPanelLayout.setHorizontalGroup(leftPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.irViewPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jTabbedPane1, -1, 284, Short.MAX_VALUE));
        leftPanelLayout.setVerticalGroup(leftPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, leftPanelLayout.createSequentialGroup().addComponent(this.jTabbedPane1, -2, 238, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.irViewPanel, -1, -1, Short.MAX_VALUE)));
        this.jTabbedPane1.getAccessibleContext().setAccessibleName("Orientation");
        this.rightPanel.setBorder(BorderFactory.createEtchedBorder());
        this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 2));
        this.fixedWiimotePanel.setMaximumSize(new Dimension(120, Short.MAX_VALUE));
        this.fixedWiimotePanel.setMinimumSize(new Dimension(120, 100));
        this.fixedWiimotePanel.setPreferredSize(new Dimension(120, 100));
        this.fixedWiimotePanel.setRequestFocusEnabled(false);
        this.fixedWiimotePanel.setLayout(null);
        this.buttonsPanel.setMaximumSize(new Dimension(120, 484));
        this.buttonsPanel.setMinimumSize(new Dimension(120, 484));
        this.buttonsPanel.setOpaque(false);
        this.buttonsPanel.setPreferredSize(new Dimension(120, 484));
        GroupLayout buttonsPanelLayout = new GroupLayout(this.buttonsPanel);
        this.buttonsPanel.setLayout(buttonsPanelLayout);
        buttonsPanelLayout.setHorizontalGroup(buttonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 120, Short.MAX_VALUE));
        buttonsPanelLayout.setVerticalGroup(buttonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 484, Short.MAX_VALUE));
        this.fixedWiimotePanel.add(this.buttonsPanel);
        this.buttonsPanel.setBounds(0, 0, 120, 484);
        this.rightPanel.add(this.fixedWiimotePanel);
        this.controlsPanel.setMinimumSize(new Dimension(100, 264));
        this.controlsPanel.setPreferredSize(new Dimension(190, 264));
        this.controlsPanel.setLayout(new GridLayout(16, 1));
        this.toggleRumbleButton.setText("Activate Rumble");
        this.toggleRumbleButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.toggleRumbleButtonMousePressed(evt);
            }
        });
        this.activateRumbleIRPanel.add(this.toggleRumbleButton);
        this.toggleIRTrackingButton.setText("Activate IR Tracking");
        this.toggleIRTrackingButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.toggleIRTrackingButtonMousePressed(evt);
            }
        });
        this.activateRumbleIRPanel.add(this.toggleIRTrackingButton);
        this.controlsPanel.add(this.activateRumbleIRPanel);
        this.toggleMotionSensingTrackingButton.setText("Activate motion sensing Tracking");
        this.toggleMotionSensingTrackingButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.toggleMotionSensingTrackingButtonMousePressed(evt);
            }
        });
        this.activateMotionSensingPanel.add(this.toggleMotionSensingTrackingButton);
        this.controlsPanel.add(this.activateMotionSensingPanel);
        this.toggleSmoothingButton.setText("Activate Smoothing");
        this.toggleSmoothingButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.toggleSmoothingButtonMousePressed(evt);
            }
        });
        this.activateSmoothingContinuousPanel.add(this.toggleSmoothingButton);
        this.toggleContinuousButton.setText("Activate Continuous");
        this.toggleContinuousButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.toggleContinuousButtonMousePressed(evt);
            }
        });
        this.activateSmoothingContinuousPanel.add(this.toggleContinuousButton);
        this.controlsPanel.add(this.activateSmoothingContinuousPanel);
        this.led1Button.setText("Led1");
        this.led1Button.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.led1ButtonMousePressed(evt);
            }
        });
        this.setLedsPanel.add(this.led1Button);
        this.led2Button.setText("Led2");
        this.led2Button.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.led2ButtonMousePressed(evt);
            }
        });
        this.setLedsPanel.add(this.led2Button);
        this.led3Button.setText("Led3");
        this.led3Button.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.led3ButtonMousePressed(evt);
            }
        });
        this.setLedsPanel.add(this.led3Button);
        this.led4Button.setText("Led4");
        this.led4Button.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.led4ButtonMousePressed(evt);
            }
        });
        this.setLedsPanel.add(this.led4Button);
        this.setLedsButton.setText("Set leds");
        this.setLedsButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.setLedsButtonMousePressed(evt);
            }
        });
        this.setLedsPanel.add(this.setLedsButton);
        this.controlsPanel.add(this.setLedsPanel);
        this.alphaSmoothingTextField.setMinimumSize(new Dimension(100, 20));
        this.alphaSmoothingTextField.setPreferredSize(new Dimension(100, 20));
        this.setAlphaSmoothingPanel.add(this.alphaSmoothingTextField);
        this.alphaSmoothingButton.setText("Set alpha smoothing");
        this.alphaSmoothingButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.alphaSmoothingButtonMousePressed(evt);
            }
        });
        this.setAlphaSmoothingPanel.add(this.alphaSmoothingButton);
        this.controlsPanel.add(this.setAlphaSmoothingPanel);
        this.orientationThresholdTextField.setMinimumSize(new Dimension(100, 20));
        this.orientationThresholdTextField.setPreferredSize(new Dimension(100, 20));
        this.setOrientationThresholdPanel.add(this.orientationThresholdTextField);
        this.orientationThresholdButton.setText("Set orientation threshold");
        this.orientationThresholdButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.orientationThresholdButtonMousePressed(evt);
            }
        });
        this.setOrientationThresholdPanel.add(this.orientationThresholdButton);
        this.controlsPanel.add(this.setOrientationThresholdPanel);
        this.accelerationThresholdTextField.setPreferredSize(new Dimension(100, 20));
        this.setAccelerationThresholdPanel.add(this.accelerationThresholdTextField);
        this.accelerationThresholdButton.setText("Set acceleration threshold");
        this.accelerationThresholdButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.accelerationThresholdButtonMousePressed(evt);
            }
        });
        this.setAccelerationThresholdPanel.add(this.accelerationThresholdButton);
        this.controlsPanel.add(this.setAccelerationThresholdPanel);
        this.getStatusButton.setText("Get status");
        this.getStatusButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.getStatusButtonMousePressed(evt);
            }
        });
        this.getStatusPanel.add(this.getStatusButton);
        this.batteryText.setFont(new Font("Tahoma", 0, 14));
        this.batteryText.setText("Battery level :");
        this.getStatusPanel.add(this.batteryText);
        this.batteryLevelText.setFont(new Font("Arial", 0, 14));
        this.batteryLevelText.setText(" %");
        this.getStatusPanel.add(this.batteryLevelText);
        this.controlsPanel.add(this.getStatusPanel);
        this.setIrSensitivySpinner.setPreferredSize(new Dimension(50, 18));
        this.setIrSensitivySpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                WiiuseJGuiTest.this.setIrSensitivySpinnerStateChanged(evt);
            }
        });
        this.setIrSensitivyPanel.add(this.setIrSensitivySpinner);
        this.setIrSensitivyButton.setText("SetIrSensivity");
        this.setIrSensitivyButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.setIrSensitivyButtonMousePressed(evt);
            }
        });
        this.setIrSensitivyPanel.add(this.setIrSensitivyButton);
        this.setTimeoutButton.setText("Set timeouts in ms");
        this.setTimeoutButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.setTimeoutButtonMousePressed(evt);
            }
        });
        this.setIrSensitivyPanel.add(this.setTimeoutButton);
        this.controlsPanel.add(this.setIrSensitivyPanel);
        this.normalTimeoutSpinner.setPreferredSize(new Dimension(40, 18));
        this.normalTimeoutSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                WiiuseJGuiTest.this.normalTimeoutSpinnerStateChanged(evt);
            }
        });
        this.setTimeoutPanel.add(this.normalTimeoutSpinner);
        this.normalTimeoutText.setText("Normal timeout");
        this.setTimeoutPanel.add(this.normalTimeoutText);
        this.expansionHandshakeTimeoutSpinner.setPreferredSize(new Dimension(40, 18));
        this.expansionHandshakeTimeoutSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                WiiuseJGuiTest.this.expansionHandshakeTimeoutSpinnerStateChanged(evt);
            }
        });
        this.setTimeoutPanel.add(this.expansionHandshakeTimeoutSpinner);
        this.expansionHandshakeTimeoutText.setText("Expansion handshake timeout");
        this.setTimeoutPanel.add(this.expansionHandshakeTimeoutText);
        this.controlsPanel.add(this.setTimeoutPanel);
        this.toggleSensorBarPositionButton.setText("Set sensor bar above");
        this.toggleSensorBarPositionButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.toggleSensorBarPositionButtonMousePressed(evt);
            }
        });
        this.setIRConfPanel.add(this.toggleSensorBarPositionButton);
        this.toggleScreenAspectRatioButton.setText("Set screen aspect ratio 4/3");
        this.toggleScreenAspectRatioButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.toggleScreenAspectRatioButtonMousePressed(evt);
            }
        });
        this.setIRConfPanel.add(this.toggleScreenAspectRatioButton);
        this.controlsPanel.add(this.setIRConfPanel);
        this.xLabel.setText("X");
        this.setVirtualResolutionPanel.add(this.xLabel);
        this.xResolutionTextField.setMinimumSize(new Dimension(40, 20));
        this.xResolutionTextField.setPreferredSize(new Dimension(40, 20));
        this.setVirtualResolutionPanel.add(this.xResolutionTextField);
        this.yLabel.setText("Y");
        this.setVirtualResolutionPanel.add(this.yLabel);
        this.yResolutionTextField.setFocusTraversalPolicyProvider(true);
        this.yResolutionTextField.setMinimumSize(new Dimension(40, 20));
        this.yResolutionTextField.setPreferredSize(new Dimension(40, 20));
        this.setVirtualResolutionPanel.add(this.yResolutionTextField);
        this.setVirtualResolutionButton.setText("Set virtual resolution");
        this.setVirtualResolutionButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.setVirtualResolutionButtonMousePressed(evt);
            }
        });
        this.setVirtualResolutionPanel.add(this.setVirtualResolutionButton);
        this.controlsPanel.add(this.setVirtualResolutionPanel);
        this.mouseIRControlButton.setText("Start infrared mouse control");
        this.mouseIRControlButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.mouseIRControlButtonMousePressed(evt);
            }
        });
        this.startMouseControlPanel.add(this.mouseIRControlButton);
        this.controlsPanel.add(this.startMouseControlPanel);
        this.expansionText.setText("No expansion connected.");
        this.exPansionPanel.add(this.expansionText);
        this.controlsPanel.add(this.exPansionPanel);
        this.showExpansionWiimoteButton.setText("No expansion connected");
        this.showExpansionWiimoteButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.showExpansionWiimoteButtonMousePressed(evt);
            }
        });
        this.expansionButtonPanel.add(this.showExpansionWiimoteButton);
        this.controlsPanel.add(this.expansionButtonPanel);
        this.reconnectWiimotesButton.setText("Reconnect wiimote");
        this.reconnectWiimotesButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                WiiuseJGuiTest.this.reconnectWiimotesButtonMousePressed(evt);
            }
        });
        this.messagesPanel.add(this.reconnectWiimotesButton);
        this.messageLabelText.setFont(new Font("Tahoma", 0, 14));
        this.messageLabelText.setText("Message : ");
        this.messagesPanel.add(this.messageLabelText);
        this.messageText.setFont(new Font("Arial", 0, 14));
        this.messageText.setText("None");
        this.messagesPanel.add(this.messageText);
        this.controlsPanel.add(this.messagesPanel);
        this.rightPanel.add(this.controlsPanel);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.leftPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rightPanel, -1, 498, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.leftPanel, -1, -1, Short.MAX_VALUE).addComponent(this.rightPanel, -1, 573, Short.MAX_VALUE));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 800) / 2, (screenSize.height - 600) / 2, 800, 600);
    }

    private void toggleRumbleButtonMousePressed(MouseEvent evt) {
        if (this.toggleRumbleButton.isEnabled()) {
            this.wiimote.activateRumble();
            this.toggleRumbleButton.setEnabled(false);
            this.toggleRumbleButton.setText("Deactivate Rumble");
            this.messageText.setText("Rumble activated");
        } else {
            this.wiimote.deactivateRumble();
            this.toggleRumbleButton.setEnabled(true);
            this.toggleRumbleButton.setText("Activate Rumble");
            this.messageText.setText("Rumble deactivated");
        }
    }

    private void toggleIRTrackingButtonMousePressed(MouseEvent evt) {
        if (this.toggleIRTrackingButton.isEnabled()) {
            this.wiimote.activateIRTRacking();
            this.toggleIRTrackingButton.setEnabled(false);
            this.toggleIRTrackingButton.setText("Deactivate IR Tracking");
            this.messageText.setText("IR Tracking activated");
        } else {
            this.wiimote.deactivateIRTRacking();
            this.toggleIRTrackingButton.setEnabled(true);
            this.toggleIRTrackingButton.setText("Activate IR Tracking");
            ((IRPanel)this.irViewPanel).onDisconnectionEvent(null);
            this.messageText.setText("IR Tracking deactivated");
        }
    }

    private void toggleMotionSensingTrackingButtonMousePressed(MouseEvent evt) {
        if (this.toggleMotionSensingTrackingButton.isEnabled()) {
            this.wiimote.activateMotionSensing();
            this.toggleMotionSensingTrackingButton.setEnabled(false);
            this.toggleMotionSensingTrackingButton.setText("Deactivate Motion Sensing");
            this.messageText.setText("Motion Sensing activated");
        } else {
            this.wiimote.deactivateMotionSensing();
            this.toggleMotionSensingTrackingButton.setEnabled(true);
            this.toggleMotionSensingTrackingButton.setText("Activate Motion Sensing");
            ((OrientationPanel)this.motionSensingPanel).onDisconnectionEvent(null);
            ((GForcePanel)this.gForcePanel).onDisconnectionEvent(null);
            this.messageText.setText("Motion Sensing deactivated");
        }
    }

    private void toggleSmoothingButtonMousePressed(MouseEvent evt) {
        if (this.toggleSmoothingButton.isEnabled()) {
            this.wiimote.activateSmoothing();
            this.toggleSmoothingButton.setEnabled(false);
            this.toggleSmoothingButton.setText("Deactivate Alpha Smoothing");
            this.messageText.setText("Alpha Smoothing activated");
        } else {
            this.wiimote.deactivateSmoothing();
            this.toggleSmoothingButton.setEnabled(true);
            this.toggleSmoothingButton.setText("Activate Alpha Smoothing");
            this.messageText.setText("Alpha Smoothing deactivated");
        }
    }

    private void toggleContinuousButtonMousePressed(MouseEvent evt) {
        if (this.toggleContinuousButton.isEnabled()) {
            this.wiimote.activateContinuous();
            this.toggleContinuousButton.setEnabled(false);
            this.toggleContinuousButton.setText("Deactivate Continuous");
            this.messageText.setText("Continuous activated");
        } else {
            this.wiimote.deactivateContinuous();
            this.toggleContinuousButton.setEnabled(true);
            this.toggleContinuousButton.setText("Activate Continuous");
            this.messageText.setText("Continuous deactivated");
        }
    }

    private void led1ButtonMousePressed(MouseEvent evt) {
        if (this.led1Button.isEnabled()) {
            this.led1Button.setEnabled(false);
        } else {
            this.led1Button.setEnabled(true);
        }
    }

    private void led2ButtonMousePressed(MouseEvent evt) {
        if (this.led2Button.isEnabled()) {
            this.led2Button.setEnabled(false);
        } else {
            this.led2Button.setEnabled(true);
        }
    }

    private void led3ButtonMousePressed(MouseEvent evt) {
        if (this.led3Button.isEnabled()) {
            this.led3Button.setEnabled(false);
        } else {
            this.led3Button.setEnabled(true);
        }
    }

    private void led4ButtonMousePressed(MouseEvent evt) {
        if (this.led4Button.isEnabled()) {
            this.led4Button.setEnabled(false);
        } else {
            this.led4Button.setEnabled(true);
        }
    }

    private void setLedsButtonMousePressed(MouseEvent evt) {
        this.wiimote.setLeds(this.led1Button.isEnabled(), this.led2Button.isEnabled(), this.led3Button.isEnabled(), this.led4Button.isEnabled());
        this.messageText.setText("Leds set");
    }

    private void alphaSmoothingButtonMousePressed(MouseEvent evt) {
        try {
            float nb = Float.parseFloat(this.alphaSmoothingTextField.getText());
            this.wiimote.setAlphaSmoothingValue(nb);
            this.messageText.setText("Alpha smoothing set to " + nb);
        }
        catch (NumberFormatException e) {
            this.messageText.setText("Number is not a float, alpha smoothing not set !");
        }
    }

    private void orientationThresholdButtonMousePressed(MouseEvent evt) {
        try {
            float nb = Float.parseFloat(this.orientationThresholdTextField.getText());
            this.wiimote.setOrientationThreshold(nb);
            this.messageText.setText("Orientation threshold set to " + nb);
        }
        catch (NumberFormatException e) {
            this.messageText.setText("Number is not a float, orientation threshold not set !");
        }
    }

    private void accelerationThresholdButtonMousePressed(MouseEvent evt) {
        try {
            int nb = Integer.parseInt(this.accelerationThresholdTextField.getText());
            this.wiimote.setAccelerationThreshold(nb);
            this.messageText.setText("Acceleration threshold set to " + nb);
        }
        catch (NumberFormatException e) {
            this.messageText.setText("Number is not an integer, acceleration threshold not set !");
        }
    }

    private void getStatusButtonMousePressed(MouseEvent evt) {
        this.wiimote.getStatus();
        this.statusMotionRequested = true;
        this.statusIRRequested = true;
        if (this.expansionFrame instanceof NunchukGuiTest) {
            ((NunchukGuiTest)this.expansionFrame).requestThresholdsUpdate();
        }
    }

    private void toggleSensorBarPositionButtonMousePressed(MouseEvent evt) {
        if (this.toggleSensorBarPositionButton.isEnabled()) {
            this.wiimote.setSensorBarBelowScreen();
            this.toggleSensorBarPositionButton.setEnabled(false);
            this.toggleSensorBarPositionButton.setText("Set sensor bar below");
            this.messageText.setText("Sensor bar set above");
        } else {
            this.wiimote.setSensorBarAboveScreen();
            this.toggleSensorBarPositionButton.setEnabled(true);
            this.toggleSensorBarPositionButton.setText("Set sensor bar above");
            this.messageText.setText("Sensor bar set below");
        }
    }

    private void toggleScreenAspectRatioButtonMousePressed(MouseEvent evt) {
        if (this.toggleScreenAspectRatioButton.isEnabled()) {
            this.wiimote.setScreenAspectRatio43();
            this.toggleScreenAspectRatioButton.setEnabled(false);
            this.toggleScreenAspectRatioButton.setText("Set screen aspect ratio 16/9");
            this.messageText.setText("creen aspect ratio to 4/3");
        } else {
            this.wiimote.setScreenAspectRatio169();
            this.toggleScreenAspectRatioButton.setEnabled(true);
            this.toggleScreenAspectRatioButton.setText("Set screen aspect ratio 4/3");
            this.messageText.setText("Screen aspect ratio to 16/9");
        }
    }

    private void setVirtualResolutionButtonMousePressed(MouseEvent evt) {
        try {
            int xres = Integer.parseInt(this.xResolutionTextField.getText());
            int yres = Integer.parseInt(this.yResolutionTextField.getText());
            this.wiimote.setVirtualResolution(xres, yres);
            this.messageText.setText("Virtual resolution set to " + xres + "X" + yres);
        }
        catch (NumberFormatException e) {
            this.messageText.setText("A number in the virtual resolution is not an integer. Virtual resolution not set!");
        }
    }

    private void mouseIRControlButtonMousePressed(MouseEvent evt) {
        if (this.mouseIRControlButton.isEnabled()) {
            try {
                this.mouseIRControlButton.setEnabled(false);
                this.mouseIRControlButton.setText("Stop infrared mouse control");
                this.robot = new Robot();
                this.messageText.setText("Infrared mouse control started");
            }
            catch (AWTException ex) {
                Logger.getLogger(WiiuseJGuiTest.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.mouseIRControlButton.setEnabled(true);
            this.mouseIRControlButton.setText("Start infrared mouse control");
            this.robot = null;
            this.messageText.setText("Infrared mouse control stopped");
        }
    }

    private void normalTimeoutSpinnerStateChanged(ChangeEvent evt) {
        String value = this.normalTimeoutSpinner.getValue().toString();
        boolean isInt = true;
        int valueInt = 0;
        try {
            valueInt = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            isInt = false;
            this.messageText.setText("Wrong value for normal timeout.");
        }
        if (isInt) {
            if (valueInt > 1000) {
                this.normalTimeoutSpinner.setValue("1000");
            } else if (valueInt < 0) {
                this.normalTimeoutSpinner.setValue("0");
            }
        }
    }

    private void expansionHandshakeTimeoutSpinnerStateChanged(ChangeEvent evt) {
        String value = this.expansionHandshakeTimeoutSpinner.getValue().toString();
        boolean isInt = true;
        int valueInt = 0;
        try {
            valueInt = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            isInt = false;
            this.messageText.setText("Wrong value for expansion handshake timeout.");
        }
        if (isInt) {
            if (valueInt > 1000) {
                this.expansionHandshakeTimeoutSpinner.setValue("1000");
            } else if (valueInt < 0) {
                this.expansionHandshakeTimeoutSpinner.setValue("0");
            }
        }
    }

    private void setIrSensitivySpinnerStateChanged(ChangeEvent evt) {
        String value = this.setIrSensitivySpinner.getValue().toString();
        boolean isInt = true;
        int valueInt = 0;
        try {
            valueInt = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            isInt = false;
            this.messageText.setText("Wrong value for IR senstivity.");
        }
        if (isInt) {
            if (valueInt > 5) {
                this.setIrSensitivySpinner.setValue("1000");
            } else if (valueInt < 0) {
                this.setIrSensitivySpinner.setValue("0");
            }
        }
    }

    private void setIrSensitivyButtonMousePressed(MouseEvent evt) {
        String value = this.setIrSensitivySpinner.getValue().toString();
        boolean isInt = true;
        int valueInt = 0;
        try {
            valueInt = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            isInt = false;
            this.messageText.setText("Wrong value for IR sensitivity. It must be an int !");
        }
        if (isInt) {
            if (valueInt >= 1 && valueInt <= 5) {
                this.wiimote.setIrSensitivity(valueInt);
                this.messageText.setText("IR senstivity set to: " + valueInt + ".");
            } else {
                this.messageText.setText("Wrong value for IR senstivity. It muset be between 1 and 5 !");
            }
        }
    }

    private void setTimeoutButtonMousePressed(MouseEvent evt) {
        String value = this.normalTimeoutSpinner.getValue().toString();
        boolean isInt = true;
        short valueInt = 0;
        try {
            valueInt = Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            isInt = false;
            this.messageText.setText("Wrong value for normal timeout. It must be an int !");
        }
        String value2 = this.expansionHandshakeTimeoutSpinner.getValue().toString();
        boolean isInt2 = true;
        short valueInt2 = 0;
        try {
            valueInt2 = Short.parseShort(value2);
        }
        catch (NumberFormatException e) {
            isInt2 = false;
            this.messageText.setText("Wrong value for expansion handshake timeout. It must be an int !");
        }
        if (isInt && isInt2) {
            if (valueInt > 0 && valueInt2 > 0) {
                this.wiimote.setTimeout(valueInt, valueInt2);
                this.messageText.setText("Normal timeout set to: " + valueInt + " and expansion handshake timeout set to: " + valueInt2 + "!");
            } else {
                this.messageText.setText("Wrong value for one of the timeout value. It must be an integer > 0 !");
            }
        }
    }

    private void reconnectWiimotesButtonMousePressed(MouseEvent evt) {
        WiiUseApiManager.shutdown();
        if (this.wiimote != null) {
            this.onDisconnectionEvent(null);
        }
        if (this.expansionFrame != null) {
            if (this.expansionFrame instanceof NunchukGuiTest) {
                ((NunchukGuiTest)this.expansionFrame).unRegisterListeners();
            } else if (this.expansionFrame instanceof ClassicControllerGuiTest) {
                ((ClassicControllerGuiTest)this.expansionFrame).unRegisterListeners();
            }
            this.expansionFrame.setEnabled(false);
            this.expansionFrame.dispose();
            this.expansionFrame = null;
        }
        this.toggleRumbleButton.setText("Activate Rumble");
        this.toggleRumbleButton.setEnabled(true);
        this.toggleMotionSensingTrackingButton.setText("Activate motion sensing Tracking");
        this.toggleMotionSensingTrackingButton.setEnabled(true);
        this.toggleIRTrackingButton.setText("Activate IR Tracking");
        this.toggleIRTrackingButton.setEnabled(true);
        this.toggleContinuousButton.setText("Activate Continuous");
        this.toggleContinuousButton.setEnabled(true);
        this.toggleScreenAspectRatioButton.setText("Set screen aspect ratio 4/3");
        this.toggleScreenAspectRatioButton.setEnabled(true);
        this.toggleSensorBarPositionButton.setText("Set sensor bar above");
        this.toggleSensorBarPositionButton.setEnabled(true);
        this.toggleSmoothingButton.setText("Activate Smoothing");
        this.toggleSmoothingButton.setEnabled(true);
        this.mouseIRControlButton.setText("Start infrared mouse control");
        this.mouseIRControlButton.setEnabled(true);
        Wiimote[] listWiimote = WiiUseApiManager.getWiimotes(1, true);
        if (listWiimote != null && listWiimote.length > 0) {
            this.wiimote = listWiimote[0];
            this.registerListeners();
            this.initWiimote();
            this.isFirstStatusGot = false;
            this.getStatusButtonMousePressed(null);
        }
    }

    private void showExpansionWiimoteButtonMousePressed(MouseEvent evt) {
        if (this.expansionFrame != null) {
            if (this.showExpansionWiimoteButton.isEnabled()) {
                this.expansionFrame.setEnabled(true);
                this.expansionFrame.setVisible(true);
                this.showExpansionWiimoteButton.setEnabled(false);
                if (this.expansionFrame instanceof NunchukGuiTest) {
                    this.showExpansionWiimoteButton.setText("Hide Nunchuk");
                    this.messageText.setText("Nunchuk displayed !");
                } else if (this.expansionFrame instanceof GuitarHero3GuiTest) {
                    this.showExpansionWiimoteButton.setText("Hide Guitar");
                    this.messageText.setText("Guitar displayed !");
                } else if (this.expansionFrame instanceof ClassicControllerGuiTest) {
                    this.showExpansionWiimoteButton.setText("Hide Classic controller");
                    this.messageText.setText("Classic controller displayed !");
                }
            } else {
                this.expansionFrame.setEnabled(false);
                this.expansionFrame.setVisible(false);
                this.showExpansionWiimoteButton.setEnabled(true);
                if (this.expansionFrame instanceof NunchukGuiTest) {
                    this.showExpansionWiimoteButton.setText("Show Nunchuk");
                    this.messageText.setText("Nunchuk hidden !");
                } else if (this.expansionFrame instanceof GuitarHero3GuiTest) {
                    this.showExpansionWiimoteButton.setText("Show Guitar");
                    this.messageText.setText("Guitar hidden !");
                } else if (this.expansionFrame instanceof ClassicControllerGuiTest) {
                    this.showExpansionWiimoteButton.setText("Show Classic controller");
                    this.messageText.setText("Classic controller hidden !");
                }
            }
        }
    }
}

