/*
 * Decompiled with CFR 0.152.
 */
package wiiusej;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.EventListenerList;
import wiiusej.WiiUseApi;
import wiiusej.Wiimote;
import wiiusej.wiiusejevents.utils.EventsGatherer;
import wiiusej.wiiusejevents.utils.WiiUseApiListener;
import wiiusej.wiiusejevents.wiiuseapievents.WiiUseApiEvent;

public class WiiUseApiManager
extends Thread {
    private static WiiUseApiManager instance = new WiiUseApiManager();
    private final EventListenerList listeners = new EventListenerList();
    private Semaphore semaphore = new Semaphore(0);
    private Wiimote[] wiimotes;
    private WiiUseApi wiiuse = WiiUseApi.getInstance();
    private int connected = -1;
    private AtomicBoolean running = new AtomicBoolean(false);
    private boolean leave = false;
    public static int WIIUSE_STACK_UNKNOWN = 0;
    public static int WIIUSE_STACK_MS = 1;
    public static int WIIUSE_STACK_BLUESOLEIL = 2;

    public static WiiUseApiManager getInstance() {
        return instance;
    }

    public static Wiimote[] getWiimotes(int nb, boolean rumble) {
        return WiiUseApiManager.getWiimotesPrivate(nb, rumble, false, WIIUSE_STACK_UNKNOWN);
    }

    public static Wiimote[] getWiimotes(int nb, boolean rumble, int stackType) {
        return WiiUseApiManager.getWiimotesPrivate(nb, rumble, true, stackType);
    }

    private static synchronized Wiimote[] getWiimotesPrivate(int nb, boolean rumble, boolean forceStackType, int stackType) {
        WiiUseApiManager manager = WiiUseApiManager.getInstance();
        if (manager.leave) {
            return null;
        }
        if (manager.connected <= 0 && !manager.running.get()) {
            int nbWiimotes = manager.connectWiimotes(nb, rumble, forceStackType, stackType);
            manager.wiimotes = new Wiimote[nbWiimotes];
            int i = 0;
            while (i < nbWiimotes) {
                Wiimote wim;
                manager.wiimotes[i] = wim = new Wiimote(WiiUseApi.getInstance().getUnId(i), manager);
                manager.addWiiUseApiListener(wim);
                ++i;
            }
            Wiimote[] wiimoteArray = manager.wiimotes;
            int n = manager.wiimotes.length;
            int n2 = 0;
            while (n2 < n) {
                Wiimote wiimote = wiimoteArray[n2];
                int id = wiimote.getId();
                if (id % 4 == 0) {
                    wiimote.setLeds(true, true, true, true);
                } else if (id % 4 == 1) {
                    wiimote.setLeds(true, false, false, false);
                } else if (id % 4 == 2) {
                    wiimote.setLeds(true, true, false, false);
                } else if (id % 4 == 3) {
                    wiimote.setLeds(true, true, true, false);
                }
                ++n2;
            }
            if (rumble) {
                wiimoteArray = manager.wiimotes;
                n = manager.wiimotes.length;
                n2 = 0;
                while (n2 < n) {
                    Wiimote wiimote = wiimoteArray[n2];
                    wiimote.activateRumble();
                    ++n2;
                }
                try {
                    WiiUseApiManager.sleep(500L);
                }
                catch (InterruptedException wiimote) {
                    // empty catch block
                }
                wiimoteArray = manager.wiimotes;
                n = manager.wiimotes.length;
                n2 = 0;
                while (n2 < n) {
                    Wiimote wiimote = wiimoteArray[n2];
                    wiimote.deactivateRumble();
                    ++n2;
                }
            }
        }
        if (manager.connected == 0) {
            return new Wiimote[0];
        }
        if (!manager.isAlive()) {
            manager.start();
        }
        manager.semaphore.release(1);
        return manager.wiimotes;
    }

    private int connectWiimotes(int nb, boolean rumble, boolean forceStackType, int stackType) {
        if (this.connected <= 0) {
            this.wiiuse.init(nb);
            if (forceStackType) {
                this.setBlueToothstackType(stackType);
            }
            int nbWiimotesFound = this.wiiuse.find(nb, 3);
            this.connected = this.wiiuse.connect(nbWiimotesFound);
            return this.connected;
        }
        return 0;
    }

    protected void closeConnection(int id) {
        int index = 0;
        boolean found = false;
        while (index < this.wiimotes.length && !found) {
            if (this.wiimotes[index] != null && this.wiimotes[index].getId() == id) {
                this.removeWiiUseApiListener(this.wiimotes[index]);
                this.wiimotes[index] = null;
                --this.connected;
                if (this.connected == 0) {
                    this.running.set(false);
                }
                this.wiiuse.closeConnection(index);
            }
            ++index;
        }
    }

    public static int getNbConnectedWiimotes() {
        return WiiUseApiManager.getInstance().connected;
    }

    public static void shutdown() {
        WiiUseApiManager manager = WiiUseApiManager.getInstance();
        int pastConnected = manager.connected;
        if (manager.connected > 0) {
            Wiimote[] wiimoteArray = manager.wiimotes;
            int n = manager.wiimotes.length;
            int n2 = 0;
            while (n2 < n) {
                Wiimote wim = wiimoteArray[n2];
                if (wim != null) {
                    wim.disconnect();
                }
                ++n2;
            }
        }
        manager.running.set(false);
        if (pastConnected > 0) {
            manager.wiiuse.cleanUp();
        }
    }

    public static void definitiveShutdown() {
        WiiUseApiManager.getInstance().leave = true;
        WiiUseApiManager.shutdown();
    }

    protected void activateRumble(int id) {
        this.wiiuse.activateRumble(id);
    }

    protected void deactivateRumble(int id) {
        this.wiiuse.deactivateRumble(id);
    }

    protected void activateIRTRacking(int id) {
        this.wiiuse.activateIRTracking(id);
    }

    protected void deactivateIRTRacking(int id) {
        this.wiiuse.deactivateIRTracking(id);
    }

    protected void activateMotionSensing(int id) {
        this.wiiuse.activateMotionSensing(id);
    }

    protected void deactivateMotionSensing(int id) {
        this.wiiuse.deactivateMotionSensing(id);
    }

    protected void activateSmoothing(int id) {
        this.wiiuse.activateSmoothing(id);
    }

    protected void deactivateSmoothing(int id) {
        this.wiiuse.deactivateSmoothing(id);
    }

    protected void activateContinuous(int id) {
        this.wiiuse.activateContinuous(id);
    }

    protected void deactivateContinuous(int id) {
        this.wiiuse.deactivateContinuous(id);
    }

    protected void setLeds(int id, boolean l1, boolean l2, boolean l3, boolean l4) {
        this.wiiuse.setLeds(id, l1, l2, l3, l4);
    }

    protected void setOrientationThreshold(int id, float th) {
        this.wiiuse.setOrientThreshold(id, th);
    }

    protected void setAccelerationThreshold(int id, int th) {
        this.wiiuse.setAccelThreshold(id, th);
    }

    protected void setAlphaSmoothing(int id, float th) {
        this.wiiuse.setAlphaSmoothing(id, th);
    }

    protected void reSync(int id) {
        this.wiiuse.reSync(id);
    }

    protected void setScreenAspectRatio43(int id) {
        this.wiiuse.setScreenRatio43(id);
    }

    protected void setScreenAspectRatio169(int id) {
        this.wiiuse.setScreenRatio169(id);
    }

    protected void setSensorBarAboveScreen(int id) {
        this.wiiuse.setSensorBarAboveScreen(id);
    }

    protected void setSensorBarBelowScreen(int id) {
        this.wiiuse.setSensorBarBelowScreen(id);
    }

    protected void setVirtualResolution(int id, int x, int y) {
        this.wiiuse.setVirtualScreenResolution(id, x, y);
    }

    protected void getStatus(int id) {
        this.wiiuse.getStatus(id);
    }

    protected void setTimeout(int id, short normalTimeout, short expansionTimeout) {
        this.wiiuse.setTimeout(id, normalTimeout, expansionTimeout);
    }

    protected void setIrSensitivity(int id, int level) {
        this.wiiuse.setIrSensitivity(id, level);
    }

    protected void setNunchukOrientationThreshold(int id, float th) {
        this.wiiuse.setNunchukOrientationThreshold(id, th);
    }

    protected void setNunchukAccelerationThreshold(int id, int th) {
        this.wiiuse.setNunchukAccelerationThreshold(id, th);
    }

    private void setBlueToothstackType(int type) {
        this.wiiuse.windowsSetBluetoothStack(type);
    }

    public void run() {
        while (!this.leave) {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.connected <= 0) continue;
            this.running.set(true);
            EventsGatherer gather = new EventsGatherer(this.connected);
            while (this.running.get() && this.connected > 0) {
                this.wiiuse.specialPoll(gather);
                WiiUseApiEvent[] wiiUseApiEventArray = gather.getEvents();
                int n = wiiUseApiEventArray.length;
                int n2 = 0;
                while (n2 < n) {
                    WiiUseApiEvent evt = wiiUseApiEventArray[n2];
                    if (evt.getWiimoteId() != -1) {
                        this.notifyWiiUseApiListener(evt);
                        if (evt.getEventType() == WiiUseApiEvent.DISCONNECTION_EVENT) {
                            this.closeConnection(evt.getWiimoteId());
                        }
                    } else {
                        System.out.println("There is an event with id == -1 ??? there is a problem !!! : " + evt);
                    }
                    ++n2;
                }
                gather.clearEvents();
            }
        }
    }

    protected void addWiiUseApiListener(WiiUseApiListener listener) {
        this.listeners.add(WiiUseApiListener.class, listener);
    }

    protected void removeWiiUseApiListener(WiiUseApiListener listener) {
        this.listeners.remove(WiiUseApiListener.class, listener);
    }

    protected WiiUseApiListener[] getWiiUseApiListeners() {
        return (WiiUseApiListener[])this.listeners.getListeners(WiiUseApiListener.class);
    }

    private void notifyWiiUseApiListener(WiiUseApiEvent evt) {
        WiiUseApiListener[] wiiUseApiListenerArray = this.getWiiUseApiListeners();
        int n = wiiUseApiListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            WiiUseApiListener listener = wiiUseApiListenerArray[n2];
            listener.onWiiUseApiEvent(evt);
            ++n2;
        }
    }

    protected void finalize() throws Throwable {
        WiiUseApiManager.shutdown();
    }
}

