/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.alpha.impl;

import com.wolfram.alpha.WAException;
import com.wolfram.alpha.WAImage;
import com.wolfram.alpha.WARelatedLink;
import com.wolfram.alpha.impl.WAImageImpl;
import com.wolfram.alpha.net.HttpProvider;
import com.wolfram.alpha.visitor.Visitor;
import java.io.File;
import java.io.Serializable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WARelatedLinkImpl
implements WARelatedLink,
Serializable {
    private String url;
    private String text;
    private String source;
    private String excerpt;
    private WAImage image;
    static final WARelatedLinkImpl[] EMPTY_ARRAY = new WARelatedLinkImpl[0];
    private static final long serialVersionUID = -4694106442074004620L;

    WARelatedLinkImpl(Element thisElement, HttpProvider http, File tempDir) throws WAException {
        NodeList imgElements;
        int numImgElements;
        NodeList excerptElements;
        int numExcerptElements;
        this.text = thisElement.getAttribute("text");
        this.url = thisElement.getAttribute("url");
        this.source = thisElement.getAttribute("source");
        if (this.text.equals("")) {
            this.text = null;
        }
        if (this.url.equals("")) {
            this.url = null;
        }
        if (this.source.equals("")) {
            this.source = null;
        }
        if ((numExcerptElements = (excerptElements = thisElement.getElementsByTagName("excerpt")).getLength()) > 0) {
            Element excerptElement = (Element)excerptElements.item(0);
            this.excerpt = excerptElement.getFirstChild().getNodeValue();
        }
        if ((numImgElements = (imgElements = thisElement.getElementsByTagName("img")).getLength()) > 0) {
            Element imgElement = (Element)imgElements.item(0);
            this.image = new WAImageImpl(imgElement, http, tempDir);
        }
    }

    public String getSource() {
        return this.source;
    }

    public String getText() {
        return this.text;
    }

    public String getURL() {
        return this.url;
    }

    public String getExcerpt() {
        return this.excerpt;
    }

    public WAImage getImage() {
        return this.image;
    }

    public void accept(Visitor v) {
        v.visit(this);
    }
}

