/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.alpha.impl;

import com.wolfram.alpha.WAException;
import com.wolfram.alpha.WAInfo;
import com.wolfram.alpha.impl.WAImageImpl;
import com.wolfram.alpha.impl.WALinkImpl;
import com.wolfram.alpha.impl.WAUnitsImpl;
import com.wolfram.alpha.net.HttpProvider;
import com.wolfram.alpha.visitor.Visitable;
import com.wolfram.alpha.visitor.Visitor;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WAInfoImpl
implements WAInfo,
Serializable {
    private String text;
    private Visitable[] contentElements = EMPTY_VISITABLE_ARRAY;
    static final WAInfoImpl[] EMPTY_ARRAY = new WAInfoImpl[0];
    private static final long serialVersionUID = 687066271144463657L;

    WAInfoImpl(Element thisElement, HttpProvider http, File tempDir) throws WAException {
        this.text = thisElement.getAttribute("text");
        NodeList subElements = thisElement.getChildNodes();
        int numSubElements = subElements.getLength();
        ArrayList<Visitable> contentList = new ArrayList<Visitable>(numSubElements);
        for (int i = 0; i < numSubElements; ++i) {
            Node child = subElements.item(i);
            String name = child.getNodeName();
            if ("link".equals(name)) {
                contentList.add(new WALinkImpl((Element)child));
                continue;
            }
            if ("img".equals(name)) {
                contentList.add(new WAImageImpl((Element)child, http, tempDir));
                continue;
            }
            if (!"units".equals(name)) continue;
            contentList.add(new WAUnitsImpl((Element)child, http, tempDir));
        }
        this.contentElements = contentList.toArray(new Visitable[contentList.size()]);
    }

    public Visitable[] getContents() {
        return this.contentElements;
    }

    public String getText() {
        return this.text;
    }

    public void accept(Visitor v) {
        v.visit(this);
    }
}

