/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.alpha.impl;

import com.wolfram.alpha.WAException;
import com.wolfram.alpha.WAImage;
import com.wolfram.alpha.net.HttpProvider;
import com.wolfram.alpha.net.URLFetcher;
import com.wolfram.alpha.visitor.Visitable;
import com.wolfram.alpha.visitor.Visitor;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import org.w3c.dom.Element;

public class WAImageImpl
implements WAImage,
Visitable,
Serializable {
    private String url;
    private String alt;
    private String title;
    private int format;
    private int[] dimensions;
    private volatile File file;
    private volatile int cachedHashCode = 0;
    private volatile boolean imageAcquired = false;
    private transient HttpProvider http;
    private transient File tempDir;
    private static final long serialVersionUID = 8073460264016968534L;

    WAImageImpl(Element thisElement, HttpProvider http, File tempDir) throws WAException {
        this(thisElement.getAttribute("src"), http, tempDir);
        this.alt = thisElement.getAttribute("alt");
        this.title = thisElement.getAttribute("title");
        try {
            int width = Integer.parseInt(thisElement.getAttribute("width"));
            int height = Integer.parseInt(thisElement.getAttribute("height"));
            this.dimensions = new int[]{width, height};
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    WAImageImpl(String url, HttpProvider http, File tempDir) throws WAException {
        this.http = http;
        this.tempDir = tempDir;
        this.url = url;
        this.format = 0;
        int index = url.lastIndexOf("MSPStoreType=image/");
        if (index > 0) {
            String fmtString = url.substring(index + 19, index + 22);
            if (fmtString.equals("gif")) {
                this.format = 1;
            } else if (fmtString.equals("png")) {
                this.format = 2;
            }
        } else if (url.endsWith(".gif")) {
            this.format = 1;
        } else if (url.endsWith(".png")) {
            this.format = 2;
        }
    }

    public String getURL() {
        return this.url;
    }

    public String getAlt() {
        return this.alt;
    }

    public String getTitle() {
        return this.title;
    }

    public int getFormat() {
        return this.format;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public synchronized File getFile() {
        return this.file;
    }

    public void acquireImage() {
        if (!this.imageAcquired && this.http != null) {
            try {
                String suffix = this.format == 1 ? ".gif" : (this.format == 2 ? ".png" : ".tmp");
                String outFile = File.createTempFile("WAImage", suffix, this.tempDir).getAbsolutePath();
                URLFetcher fetcher = new URLFetcher(new URL(this.url), outFile, this.http, null);
                fetcher.fetch();
                this.setFile(fetcher.getFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.imageAcquired = true;
        }
    }

    public synchronized int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        int result = 17;
        result = 37 * result + this.title.hashCode();
        if (this.file != null) {
            result = 37 * result + this.file.hashCode();
        }
        this.cachedHashCode = result;
        return result;
    }

    synchronized void setFile(File file) {
        this.file = file;
        this.cachedHashCode = 0;
    }

    public void accept(Visitor v) {
        v.visit(this);
    }
}

