/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Random;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.Preferences;
import processing.core.PApplet;

public class UpdateCheck
implements Runnable {
    Base base;
    String downloadURL = "http://www.arduino.cc/latest.txt";
    static final long ONE_DAY = 86400000L;

    public UpdateCheck(Base base) {
        Thread thread = new Thread(this);
        this.base = base;
        thread.start();
    }

    public void run() {
        Random r = new Random();
        long id = r.nextLong();
        String idString = Preferences.get("update.id");
        if (idString != null) {
            id = Long.parseLong(idString);
        } else {
            Preferences.set("update.id", String.valueOf(id));
        }
        try {
            Object[] options;
            int result;
            long when;
            String info = URLEncoder.encode(id + "\t" + PApplet.nf((int)100, (int)4) + "\t" + System.getProperty("java.version") + "\t" + System.getProperty("java.vendor") + "\t" + System.getProperty("os.name") + "\t" + System.getProperty("os.version") + "\t" + System.getProperty("os.arch"), "UTF-8");
            int latest = this.readInt(this.downloadURL + "?" + info);
            String lastString = Preferences.get("update.last");
            long now = System.currentTimeMillis();
            if (lastString != null && now - (when = Long.parseLong(lastString)) < 86400000L) {
                return;
            }
            Preferences.set("update.last", String.valueOf(now));
            String prompt = "A new version of Arduino is available,\nwould you like to visit the Arduino download page?";
            if (this.base.activeEditor != null && latest > 100 && (result = JOptionPane.showOptionDialog(this.base.activeEditor, prompt, "Update", 0, 3, null, options = new Object[]{"Yes", "No"}, options[0])) == 0) {
                Base.openURL("http://www.arduino.cc/en/Main/Software");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected int readInt(String filename) throws Exception {
        URL url = new URL(filename);
        InputStream stream = url.openStream();
        InputStreamReader isr = new InputStreamReader(stream);
        BufferedReader reader = new BufferedReader(isr);
        return Integer.parseInt(reader.readLine());
    }
}

