/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.StringTokenizer;
import processing.app.Base;
import processing.app.syntax.SyntaxStyle;
import processing.core.PApplet;

public class Theme {
    static HashMap<String, String> defaults;
    static HashMap<String, String> table;

    protected static void init() {
        try {
            Theme.load(Base.getLibStream("theme/theme.txt"));
        }
        catch (Exception te) {
            Base.showError(null, "Could not read color theme settings.\nYou'll need to reinstall Processing.", te);
        }
        String platformExt = "." + Base.getPlatformName();
        int platformExtLength = platformExt.length();
        for (String key : table.keySet()) {
            if (!key.endsWith(platformExt)) continue;
            String actualKey = key.substring(0, key.length() - platformExtLength);
            String value = Theme.get(key);
            table.put(actualKey, value);
        }
        Theme.setColor("run.window.bgcolor", SystemColor.control);
        defaults = (HashMap)table.clone();
    }

    protected static void load(InputStream input) throws IOException {
        String[] lines;
        for (String line : lines = PApplet.loadStrings((InputStream)input)) {
            int equals;
            if (line.length() == 0 || line.charAt(0) == '#' || (equals = line.indexOf(61)) == -1) continue;
            String key = line.substring(0, equals).trim();
            String value = line.substring(equals + 1).trim();
            table.put(key, value);
        }
    }

    public static String get(String attribute) {
        return table.get(attribute);
    }

    public static String getDefault(String attribute) {
        return defaults.get(attribute);
    }

    public static void set(String attribute, String value) {
        table.put(attribute, value);
    }

    public static boolean getBoolean(String attribute) {
        String value = Theme.get(attribute);
        return new Boolean(value);
    }

    public static void setBoolean(String attribute, boolean value) {
        Theme.set(attribute, value ? "true" : "false");
    }

    public static int getInteger(String attribute) {
        return Integer.parseInt(Theme.get(attribute));
    }

    public static void setInteger(String key, int value) {
        Theme.set(key, String.valueOf(value));
    }

    public static Color getColor(String name) {
        Color parsed = null;
        String s = Theme.get(name);
        if (s != null && s.indexOf("#") == 0) {
            try {
                int v = Integer.parseInt(s.substring(1), 16);
                parsed = new Color(v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return parsed;
    }

    public static void setColor(String attr, Color what) {
        Theme.set(attr, "#" + PApplet.hex((int)(what.getRGB() & 0xFFFFFF), (int)6));
    }

    public static Font getFont(String attr) {
        String[] pieces;
        boolean replace = false;
        String value = Theme.get(attr);
        if (value == null) {
            value = Theme.getDefault(attr);
            replace = true;
        }
        if ((pieces = PApplet.split((String)value, (char)',')).length != 3) {
            value = Theme.getDefault(attr);
            pieces = PApplet.split((String)value, (char)',');
            replace = true;
        }
        String name = pieces[0];
        int style = 0;
        if (pieces[1].indexOf("bold") != -1) {
            style |= 1;
        }
        if (pieces[1].indexOf("italic") != -1) {
            style |= 2;
        }
        int size = PApplet.parseInt((String)pieces[2], (int)12);
        Font font = new Font(name, style, size);
        if (replace) {
            Theme.set(attr, value);
        }
        return font;
    }

    public static SyntaxStyle getStyle(String what) {
        String str = Theme.get("editor." + what + ".style");
        StringTokenizer st = new StringTokenizer(str, ",");
        String s = st.nextToken();
        if (s.indexOf("#") == 0) {
            s = s.substring(1);
        }
        Color color = new Color(Integer.parseInt(s, 16));
        s = st.nextToken();
        boolean bold = s.indexOf("bold") != -1;
        boolean italic = s.indexOf("italic") != -1;
        boolean underlined = s.indexOf("underlined") != -1;
        return new SyntaxStyle(color, italic, bold, underlined);
    }

    static {
        table = new HashMap();
    }
}

