/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util.props.tools;

import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;

public class HTMLDumper {
    public static void showConfigAsHTML(ConfigurationManager ConfigurationManager2, String path) throws IOException {
        PrintStream out = new PrintStream(new FileOutputStream(path));
        HTMLDumper.dumpHeader(out);
        for (String componentName : ConfigurationManager2.getInstanceNames(Configurable.class)) {
            HTMLDumper.dumpComponentAsHTML(out, componentName, ConfigurationManager2.getPropertySheet(componentName));
        }
        HTMLDumper.dumpFooter(out);
        out.close();
    }

    public static void dumpFooter(PrintStream out) {
        out.println("</body>");
        out.println("</html>");
    }

    public static void dumpHeader(PrintStream out) {
        out.println("<html><head>");
        out.println("    <title> Sphinx-4 Configuration</title");
        out.println("</head>");
        out.println("<body>");
    }

    public static void dumpComponentAsHTML(PrintStream out, String name, PropertySheet properties) {
        out.println("<table border=1>");
        out.print("    <tr><th bgcolor=\"#CCCCFF\" colspan=2>");
        out.print(name);
        out.print("</a>");
        out.println("</td></tr>");
        out.println("    <tr><th bgcolor=\"#CCCCFF\">Property</th><th bgcolor=\"#CCCCFF\"> Value</th></tr>");
        Collection<String> propertyNames = properties.getRegisteredProperties();
        for (String propertyName : propertyNames) {
            out.print("    <tr><th align=\"leftt\">" + propertyName + "</th>");
            Object obj = properties.getRaw(propertyName);
            if (obj instanceof String) {
                out.println("<td>" + obj + "</td></tr>");
                continue;
            }
            if (obj instanceof List) {
                List l = (List)obj;
                out.println("    <td><ul>");
                for (Object listElement : l) {
                    out.println("        <li>" + listElement + "</li>");
                }
                out.println("    </ul></td>");
                continue;
            }
            out.println("<td>DEFAULT</td></tr>");
        }
        out.println("</table><br>");
    }
}

