/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util.props;

import java.net.URL;
import java.util.List;

public enum PropertyType {
    INT("int"){

        @Override
        protected boolean validateString(String obj) throws Exception {
            Integer.parseInt(obj);
            return true;
        }
    }
    ,
    BOOLEAN("boolean"){

        @Override
        protected boolean validateString(String obj) throws Exception {
            return "true".equals(obj = obj.toLowerCase()) || "false".equals(obj);
        }
    }
    ,
    FLOAT("float"){

        @Override
        protected boolean validateString(String obj) throws Exception {
            Float.parseFloat(obj);
            return true;
        }
    }
    ,
    DOUBLE("double"){

        @Override
        protected boolean validateString(String obj) throws Exception {
            Double.parseDouble(obj);
            return true;
        }
    }
    ,
    COMPONENT("Component", String.class),
    COMPONENT_LIST("ComponentList", List.class),
    STRING("String", String.class),
    RESOURCE("Resource"){

        @Override
        public boolean validateString(String obj) throws Exception {
            if (obj.toLowerCase().startsWith("resource:/")) {
                return true;
            }
            if (obj.indexOf(58) == -1) {
                obj = "file:" + obj;
            }
            new URL(obj);
            return true;
        }
    }
    ,
    STRING_LIST("StringList", List.class);

    private final String displayName;
    private Class<?> checkClass;

    private PropertyType(String displayName) {
        this.displayName = displayName;
    }

    private PropertyType(String displayName, Class<?> checkClass) {
        this.displayName = displayName;
        this.checkClass = checkClass;
    }

    public String toString() {
        return this.displayName;
    }

    protected boolean validateString(String obj) throws Exception {
        return true;
    }

    public boolean isValid(Object obj) {
        if (this.checkClass != null) {
            return this.checkClass.isInstance(obj);
        }
        if (obj instanceof String) {
            try {
                return this.validateString((String)obj);
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }
}

