/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Double;
import java.io.Serializable;
import java.util.logging.Logger;

public final class LogMath
implements Configurable,
Serializable {
    @S4Double(defaultValue=1.0001)
    public static final String PROP_LOG_BASE = "logBase";
    @S4Boolean(defaultValue=true)
    public static final String PROP_USE_ADD_TABLE = "useAddTable";
    private static final float logZero = -3.4028235E38f;
    private static float logOne;
    private float logBase;
    private boolean useAddTable;
    private transient Logger logger;
    private transient float naturalLogBase;
    private transient float inverseNaturalLogBase;
    private transient float[] theAddTable;
    private transient float maxLogValue;
    private transient float minLogValue;

    public LogMath(float logBase, boolean useAddTable) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.logBase = logBase;
        this.useAddTable = useAddTable;
        this.init();
    }

    public LogMath() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.logger = ps.getLogger();
        this.logBase = ps.getFloat(PROP_LOG_BASE);
        this.useAddTable = ps.getBoolean(PROP_USE_ADD_TABLE);
        this.init();
    }

    private void init() {
        if (this.logger != null) {
            this.logger.config("Log base is " + this.logBase);
            if (this.useAddTable) {
                this.logger.config("Using AddTable when adding logs");
            } else {
                this.logger.config("Performing actual computation when adding logs");
            }
        }
        this.naturalLogBase = (float)Math.log(this.logBase);
        this.inverseNaturalLogBase = 1.0f / this.naturalLogBase;
        this.maxLogValue = this.linearToLog(Double.MAX_VALUE);
        this.minLogValue = this.linearToLog(Double.MIN_VALUE);
        if (this.useAddTable) {
            int veryLargeNumberOfEntries = 150000;
            boolean verySmallNumberOfEntries = false;
            int entriesInTheAddTable = (int)(-Math.rint(this.linearToLog(this.logToLinear(0.5f) - 1.0)));
            if (entriesInTheAddTable > 150000) {
                entriesInTheAddTable = 150000;
            }
            if (entriesInTheAddTable <= 0) {
                throw new IllegalArgumentException("The log base " + this.logBase + " yields a very small addTable. " + "Either choose not to use the addTable, " + "or choose a logBase closer to 1.0");
            }
            if (this.logger != null) {
                this.logger.config("LogAdd table has " + entriesInTheAddTable + " entries.");
            }
            this.theAddTable = new float[entriesInTheAddTable];
            for (int index = 0; index < entriesInTheAddTable; ++index) {
                float innerSummation = (float)this.logToLinear(-index);
                this.theAddTable[index] = this.linearToLog(innerSummation += 1.0f);
            }
        }
    }

    public final float addAsLinear(float logVal1, float logVal2) {
        float logHighestValue = logVal1;
        float logDifference = logVal1 - logVal2;
        if (logDifference < 0.0f) {
            logHighestValue = logVal2;
            logDifference = -logDifference;
        }
        return logHighestValue + this.addTable(logDifference);
    }

    private float addTableActualComputation(float index) {
        double logInnerSummation = this.logToLinear(-index);
        return this.linearToLog(logInnerSummation += 1.0);
    }

    private float addTable(float index) throws IllegalArgumentException {
        if (this.useAddTable) {
            int intIndex = (int)((double)index + 0.5);
            if (0 <= intIndex) {
                if (intIndex < this.theAddTable.length) {
                    return this.theAddTable[intIndex];
                }
                return 0.0f;
            }
            throw new IllegalArgumentException("addTable index has to be negative");
        }
        return this.addTableActualComputation(index);
    }

    public final float subtractAsLinear(float logMinuend, float logSubtrahend) throws IllegalArgumentException {
        if (logMinuend < logSubtrahend) {
            throw new IllegalArgumentException("Subtraction results in log of a negative number: " + logMinuend + " - " + logSubtrahend);
        }
        double logInnerSummation = 1.0;
        return logMinuend + this.linearToLog(logInnerSummation -= this.logToLinear(logSubtrahend - logMinuend));
    }

    public static float logToLog(float logSource, float sourceBase, float resultBase) throws IllegalArgumentException {
        if (sourceBase <= 0.0f || resultBase <= 0.0f) {
            throw new IllegalArgumentException("Trying to take log of  non-positive number: " + sourceBase + " or " + resultBase);
        }
        if (logSource == -3.4028235E38f) {
            return -3.4028235E38f;
        }
        float lnSourceBase = (float)Math.log(sourceBase);
        float lnResultBase = (float)Math.log(resultBase);
        return logSource * lnSourceBase / lnResultBase;
    }

    public final float lnToLog(float logSource) {
        if (logSource == -3.4028235E38f) {
            return -3.4028235E38f;
        }
        return logSource * this.inverseNaturalLogBase;
    }

    public final float log10ToLog(float logSource) {
        if (logSource == -3.4028235E38f) {
            return -3.4028235E38f;
        }
        return LogMath.logToLog(logSource, 10.0f, this.logBase);
    }

    public final float logToLn(float logSource) {
        if (logSource == -3.4028235E38f) {
            return -3.4028235E38f;
        }
        return logSource * this.naturalLogBase;
    }

    public final float linearToLog(double linearValue) throws IllegalArgumentException {
        if (linearValue < 0.0) {
            throw new IllegalArgumentException("linearToLog: param must be >= 0: " + linearValue);
        }
        if (linearValue == 0.0) {
            return LogMath.getLogZero();
        }
        double returnValue = Math.log(linearValue) * (double)this.inverseNaturalLogBase;
        if (returnValue > 3.4028234663852886E38) {
            return Float.MAX_VALUE;
        }
        if (returnValue < -3.4028234663852886E38) {
            return -3.4028235E38f;
        }
        return (float)returnValue;
    }

    public final double logToLinear(float logValue) {
        double returnValue = logValue < this.minLogValue ? 0.0 : (logValue > this.maxLogValue ? Double.MAX_VALUE : Math.exp(this.logToLn(logValue)));
        return returnValue;
    }

    public static float getLogZero() {
        return -3.4028235E38f;
    }

    public static float getLogOne() {
        return logOne;
    }

    public final float getLogBase() {
        return this.logBase;
    }

    public boolean isUseAddTable() {
        return this.useAddTable;
    }

    public static float log10(float value) {
        return (float)(0.4342944819 * Math.log(value));
    }

    public void linearToLog(float[] vector) {
        int nbGaussians = vector.length;
        for (int i = 0; i < nbGaussians; ++i) {
            vector[i] = this.linearToLog(vector[i]);
        }
    }

    public void logToLinear(float[] vector, float[] out) {
        for (int i = 0; i < vector.length; ++i) {
            out[i] = (float)this.logToLinear(vector[i]);
        }
    }
}

