/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.result.Edge;
import edu.cmu.sphinx.result.Lattice;
import edu.cmu.sphinx.result.Node;
import java.util.ArrayList;

public class LatticeOptimizer {
    protected final Lattice lattice;

    public LatticeOptimizer(Lattice lattice) {
        this.lattice = lattice;
    }

    public void optimize() {
        this.optimizeForward();
        this.optimizeBackward();
    }

    protected void optimizeForward() {
        boolean moreChanges = true;
        while (moreChanges) {
            moreChanges = false;
            for (Node n : this.lattice.getCopyOfNodes()) {
                if (!this.lattice.hasNode(n)) continue;
                moreChanges |= this.optimizeNodeForward(n);
            }
        }
    }

    protected boolean optimizeNodeForward(Node n) {
        assert (this.lattice.hasNode(n));
        ArrayList<Edge> leavingEdges = new ArrayList<Edge>(n.getLeavingEdges());
        for (int j = 0; j < leavingEdges.size(); ++j) {
            Edge e = (Edge)leavingEdges.get(j);
            for (int k = j + 1; k < leavingEdges.size(); ++k) {
                Edge e2 = (Edge)leavingEdges.get(k);
                assert (e != e2);
                if (!this.equivalentNodesForward(e.getToNode(), e2.getToNode())) continue;
                this.mergeNodesAndEdgesForward(n, e, e2);
                return true;
            }
        }
        return false;
    }

    protected boolean equivalentNodesForward(Node n1, Node n2) {
        assert (this.lattice.hasNode(n1));
        assert (this.lattice.hasNode(n2));
        if (!this.equivalentNodeLabels(n1, n2)) {
            return false;
        }
        return n1.hasEquivalentEnteringEdges(n2);
    }

    protected void mergeNodesAndEdgesForward(Node n, Edge e1, Edge e2) {
        assert (this.lattice.hasNode(n));
        assert (this.lattice.hasEdge(e1));
        assert (this.lattice.hasEdge(e2));
        assert (e1.getFromNode() == n);
        assert (e2.getFromNode() == n);
        Node n1 = e1.getToNode();
        Node n2 = e2.getToNode();
        assert (n1.hasEquivalentEnteringEdges(n1));
        assert (n1.getWord().equals(n2.getWord()));
        e1.setAcousticScore(this.mergeAcousticScores(e1.getAcousticScore(), e2.getAcousticScore()));
        e1.setLMScore(this.mergeLanguageScores(e1.getLMScore(), e2.getLMScore()));
        for (Edge e : n2.getLeavingEdges()) {
            e2 = n1.getEdgeToNode(e.getToNode());
            if (e2 == null) {
                this.lattice.addEdge(n1, e.getToNode(), e.getAcousticScore(), e.getLMScore());
                continue;
            }
            e2.setAcousticScore(this.mergeAcousticScores(e.getAcousticScore(), e2.getAcousticScore()));
            e2.setLMScore(this.mergeLanguageScores(e.getLMScore(), e2.getLMScore()));
        }
        this.lattice.removeNodeAndEdges(n2);
    }

    protected void optimizeBackward() {
        boolean moreChanges = true;
        while (moreChanges) {
            moreChanges = false;
            for (Node n : this.lattice.getCopyOfNodes()) {
                if (!this.lattice.hasNode(n)) continue;
                moreChanges |= this.optimizeNodeBackward(n);
            }
        }
    }

    protected boolean optimizeNodeBackward(Node n) {
        ArrayList<Edge> enteringEdges = new ArrayList<Edge>(n.getEnteringEdges());
        for (int j = 0; j < enteringEdges.size(); ++j) {
            Edge e = (Edge)enteringEdges.get(j);
            for (int k = j + 1; k < n.getEnteringEdges().size(); ++k) {
                Edge e2 = (Edge)enteringEdges.get(k);
                assert (e != e2);
                if (!this.equivalentNodesBackward(e.getFromNode(), e2.getFromNode())) continue;
                this.mergeNodesAndEdgesBackward(n, e, e2);
                return true;
            }
        }
        return false;
    }

    protected boolean equivalentNodesBackward(Node n1, Node n2) {
        assert (this.lattice.hasNode(n1));
        assert (this.lattice.hasNode(n2));
        if (!this.equivalentNodeLabels(n1, n2)) {
            return false;
        }
        return n1.hasEquivalentLeavingEdges(n2);
    }

    protected boolean equivalentNodeLabels(Node n1, Node n2) {
        return n1.getWord().equals(n2.getWord()) && n1.getBeginTime() == n2.getBeginTime() && n1.getEndTime() == n2.getEndTime();
    }

    protected void mergeNodesAndEdgesBackward(Node n, Edge e1, Edge e2) {
        assert (this.lattice.hasNode(n));
        assert (this.lattice.hasEdge(e1));
        assert (this.lattice.hasEdge(e2));
        assert (e1.getToNode() == n);
        assert (e2.getToNode() == n);
        Node n1 = e1.getFromNode();
        Node n2 = e2.getFromNode();
        assert (n1.hasEquivalentLeavingEdges(n2));
        assert (n1.getWord().equals(n2.getWord()));
        e1.setAcousticScore(this.mergeAcousticScores(e1.getAcousticScore(), e2.getAcousticScore()));
        e1.setLMScore(this.mergeLanguageScores(e1.getLMScore(), e2.getLMScore()));
        for (Edge e : n2.getEnteringEdges()) {
            e2 = n1.getEdgeFromNode(e.getFromNode());
            if (e2 == null) {
                this.lattice.addEdge(e.getFromNode(), n1, e.getAcousticScore(), e.getLMScore());
                continue;
            }
            e2.setAcousticScore(this.mergeAcousticScores(e.getAcousticScore(), e2.getAcousticScore()));
            e2.setLMScore(this.mergeLanguageScores(e.getLMScore(), e2.getLMScore()));
        }
        this.lattice.removeNodeAndEdges(n2);
    }

    protected void removeHangingNodes() {
        for (Node n : this.lattice.getCopyOfNodes()) {
            if (!this.lattice.hasNode(n) || n == this.lattice.getInitialNode() || n == this.lattice.getTerminalNode() || !n.getLeavingEdges().isEmpty() && !n.getEnteringEdges().isEmpty()) continue;
            this.lattice.removeNodeAndEdges(n);
            this.removeHangingNodes();
            return;
        }
    }

    private double mergeAcousticScores(double score1, double score2) {
        return Math.max(score1, score2);
    }

    private double mergeLanguageScores(double score1, double score2) {
        return Math.max(score1, score2);
    }

    public static void main(String[] args) {
        Lattice lattice = new Lattice(args[0]);
        LatticeOptimizer optimizer = new LatticeOptimizer(lattice);
        optimizer.optimize();
        lattice.dump(args[1]);
    }
}

