/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.research.parallel;

import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.flat.PronunciationState;
import edu.cmu.sphinx.linguist.flat.UnitState;
import edu.cmu.sphinx.research.parallel.ArrayTokenStack;
import edu.cmu.sphinx.research.parallel.FeatureStream;
import edu.cmu.sphinx.research.parallel.ParallelState;
import edu.cmu.sphinx.research.parallel.TokenStack;

public class ParallelUnitState
extends UnitState
implements ParallelState {
    private FeatureStream stream;
    private TokenStack tokenStack;

    public ParallelUnitState(PronunciationState parent, FeatureStream stream, int which, Unit unit, int tokenStackSize) {
        super(parent, which, unit);
        this.stream = stream;
        this.tokenStack = tokenStackSize > 0 ? new ArrayTokenStack(tokenStackSize) : null;
    }

    @Override
    public TokenStack getTokenStack() {
        return this.tokenStack;
    }

    @Override
    public FeatureStream getFeatureStream() {
        return this.stream;
    }

    @Override
    public String getName() {
        String name = super.getName();
        return name + '.' + this.stream.getName();
    }

    @Override
    public String getPrettyName() {
        return super.getPrettyName() + '.' + this.stream.getName();
    }

    @Override
    public String getTitle() {
        return super.getTitle() + '.' + this.stream.getName();
    }

    @Override
    public String getValueSignature() {
        return super.getValueSignature() + '.' + this.stream.getName();
    }

    public void clear() {
        if (this.tokenStack != null) {
            this.tokenStack.clear();
        }
    }
}

