/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.research.parallel;

import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.linguist.flat.SentenceHMMState;
import edu.cmu.sphinx.research.parallel.FeatureStream;

public class ParallelToken
extends Token {
    private FeatureStream featureStream;
    private float combinedScore;
    private boolean pruned;
    private int lastCombineTime;
    private String lastCombineStamp;

    public ParallelToken(ParallelToken predecessor, SentenceHMMState state, float featureScore, float combinedScore, int frameNumber) {
        super(predecessor, state, featureScore, 0.0f, 0.0f, frameNumber);
        if (predecessor != null) {
            this.featureStream = predecessor.getFeatureStream();
        }
        this.combinedScore = combinedScore;
        this.pruned = false;
    }

    public ParallelToken(ParallelToken predecessor, SentenceHMMState state, float featureScore, float combinedScore, int frameNumber, int lastCombineFrame) {
        this(predecessor, state, featureScore, combinedScore, frameNumber);
        this.lastCombineTime = lastCombineFrame;
    }

    public ParallelToken(ParallelToken predecessor, SentenceHMMState state, float featureScore, float combinedScore, int frameNumber, String lastCombineStamp) {
        this(predecessor, state, featureScore, combinedScore, -1);
        this.lastCombineStamp = lastCombineStamp;
    }

    public ParallelToken(SentenceHMMState state, FeatureStream featureStream, int frameNumber) {
        this(null, state, 0.0f, 0.0f, frameNumber);
        this.featureStream = featureStream;
    }

    public FeatureStream getFeatureStream() {
        return this.featureStream;
    }

    public float getEta() {
        return this.featureStream.getEta();
    }

    public float getCombinedScore() {
        return this.combinedScore;
    }

    public float getFeatureScore() {
        return this.getScore();
    }

    public String getModelName() {
        return this.featureStream.getName();
    }

    public int getLastCombineTime() {
        return this.lastCombineTime;
    }

    public String getLastCombineStamp() {
        return this.lastCombineStamp;
    }

    public void setCombinedScore(float combinedScore) {
        this.combinedScore = combinedScore;
    }

    public void setFeatureScore(float featureScore) {
        this.setScore(featureScore);
    }

    public void setLastCombineTime(int frameNumber) {
        this.lastCombineTime = frameNumber;
    }

    public void setLastCombineStamp(String stamp) {
        this.lastCombineStamp = stamp;
    }

    public boolean isPruned() {
        return this.pruned;
    }

    public void setPruned(boolean pruned) {
        this.pruned = pruned;
    }
}

