/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.research.parallel;

import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.research.parallel.TokenStack;

public class ArrayTokenStack
implements TokenStack {
    private final Token[] stack;

    public ArrayTokenStack(int capacity) {
        this.stack = new Token[capacity];
        this.clear();
    }

    @Override
    public Token add(Token newToken) {
        Token lowestToken = null;
        int lowestTokenIndex = -1;
        for (int i = 0; i < this.stack.length; ++i) {
            Token token = this.stack[i];
            if (token == null) {
                this.stack[i] = newToken;
                return null;
            }
            if (token.getFrameNumber() != newToken.getFrameNumber()) {
                this.stack[i] = newToken;
                return token;
            }
            if (lowestToken == null) {
                lowestToken = token;
                lowestTokenIndex = i;
                continue;
            }
            if (!(token.getScore() <= lowestToken.getScore())) continue;
            lowestToken = token;
            lowestTokenIndex = i;
        }
        if (lowestTokenIndex != -1) {
            this.stack[lowestTokenIndex] = newToken;
            return lowestToken;
        }
        this.stack[0] = newToken;
        return null;
    }

    @Override
    public boolean isInsertable(float score, int frameNumber) {
        for (Token token : this.stack) {
            if (token != null && token.getFrameNumber() == frameNumber && !(token.getScore() <= score)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getCapacity() {
        return this.stack.length;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.stack.length; ++i) {
            this.stack[i] = null;
        }
    }
}

