/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram.large;

import edu.cmu.sphinx.linguist.language.ngram.large.BinaryLoader;
import edu.cmu.sphinx.util.LogMath;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class BinaryStreamLoader
extends BinaryLoader {
    byte[] modelData;

    public BinaryStreamLoader(URL location, String format, boolean applyLanguageWeightAndWip, LogMath logMath, float languageWeight, double wip, float unigramWeight) throws IOException {
        super(format, applyLanguageWeightAndWip, logMath, languageWeight, wip, unigramWeight);
        InputStream stream = location.openStream();
        this.loadModelLayout(stream);
        stream = location.openStream();
        this.loadModelData(stream);
    }

    private void loadModelData(InputStream stream) throws IOException {
        DataInputStream dataStream = new DataInputStream(new BufferedInputStream(stream));
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while (dataStream.read(buffer) >= 0) {
            bytes.write(buffer);
        }
        this.modelData = bytes.toByteArray();
    }

    @Override
    public byte[] loadBuffer(long position, int size) throws IOException {
        byte[] result = new byte[size];
        System.arraycopy(this.modelData, (int)position, result, 0, size);
        return result;
    }
}

