/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.linguist.util.LRUCache;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class NetworkLanguageModel
implements LanguageModel {
    @S4Component(type=LogMath.class)
    public static final String PROP_LOG_MATH = "logMath";
    @S4String(defaultValue="localhost")
    public static final String PROP_HOST = "host";
    @S4Integer(defaultValue=2525)
    public static final String PROP_PORT = "port";
    LogMath logMath;
    private String host;
    private int port;
    private URL location;
    int maxDepth;
    Socket socket;
    private BufferedReader inReader;
    private PrintWriter outWriter;
    LRUCache<WordSequence, Float> cache;
    private boolean allocated;

    public NetworkLanguageModel(String host, int port, URL location, int maxDepth, LogMath logMath) {
        this.host = host;
        this.port = port;
        this.maxDepth = maxDepth;
        this.location = location;
        this.logMath = logMath;
    }

    public NetworkLanguageModel() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        if (this.allocated) {
            throw new RuntimeException("Can't change properties after allocation");
        }
        this.host = ps.getString(PROP_HOST);
        this.port = ps.getInt(PROP_PORT);
        this.location = ConfigurationManagerUtils.getResource("location", ps);
        this.logMath = (LogMath)ps.getComponent(PROP_LOG_MATH);
        this.maxDepth = ps.getInt("maxDepth");
        if (this.maxDepth == -1) {
            this.maxDepth = 3;
        }
    }

    @Override
    public void allocate() throws IOException {
        this.allocated = true;
        this.socket = new Socket(this.host, this.port);
        this.inReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.outWriter = new PrintWriter(this.socket.getOutputStream(), true);
        String greeting = this.inReader.readLine();
        if (!greeting.equals("probserver ready")) {
            throw new IOException("Incorrect input");
        }
        this.cache = new LRUCache(1000);
    }

    @Override
    public void deallocate() {
        this.allocated = false;
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public float getProbability(WordSequence wordSequence) {
        Float probability = (Float)this.cache.get(wordSequence);
        if (probability != null) {
            return probability.floatValue();
        }
        StringBuilder builder = new StringBuilder();
        if (wordSequence.size() == 0) {
            return 0.0f;
        }
        for (Word w : wordSequence.getWords()) {
            builder.append(w.toString());
            builder.append(' ');
        }
        this.outWriter.println(builder.toString());
        String result = "0";
        try {
            result = this.inReader.readLine();
            if (result.charAt(0) == '\u0000') {
                result = result.substring(1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        probability = !result.equals("-inf") ? Float.valueOf(this.logMath.log10ToLog(Float.parseFloat(result))) : Float.valueOf(LogMath.getLogZero());
        this.cache.put(wordSequence, probability);
        return probability.floatValue();
    }

    @Override
    public float getSmear(WordSequence wordSequence) {
        return 0.0f;
    }

    @Override
    public Set<String> getVocabulary() {
        HashSet<String> result = new HashSet<String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.location.openStream()));
            while ((line = reader.readLine()) != null) {
                if (line.length() == 0) continue;
                result.add(line.trim());
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

