/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;

public class KeywordOptimizerModel
implements LanguageModel {
    @S4Component(type=LanguageModel.class)
    public static final String PROP_PARENT = "parent";
    public HashMap<String, Float> keywordProbs;
    private LanguageModel parent;

    public KeywordOptimizerModel(LanguageModel parent) {
        this.parent = parent;
    }

    public KeywordOptimizerModel() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.parent = (LanguageModel)ps.getComponent(PROP_PARENT);
    }

    @Override
    public void allocate() throws IOException {
        this.parent.allocate();
    }

    @Override
    public void deallocate() throws IOException {
        this.parent.deallocate();
    }

    @Override
    public void start() {
        this.parent.start();
    }

    @Override
    public void stop() {
        this.parent.stop();
    }

    @Override
    public float getProbability(WordSequence wordSequence) {
        float prob = this.parent.getProbability(wordSequence);
        if (this.keywordProbs == null) {
            return prob;
        }
        for (Word word : wordSequence.getWords()) {
            String ws = word.toString();
            if (!this.keywordProbs.containsKey(ws)) continue;
            prob *= this.keywordProbs.get(ws).floatValue();
        }
        return prob;
    }

    @Override
    public float getSmear(WordSequence wordSequence) {
        return this.parent.getSmear(wordSequence);
    }

    @Override
    public int getMaxDepth() {
        return this.parent.getMaxDepth();
    }

    @Override
    public Set<String> getVocabulary() {
        return this.parent.getVocabulary();
    }
}

