/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.grammar;

import edu.cmu.sphinx.decoder.ResultListener;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.language.grammar.Grammar;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.ExtendedStreamTokenizer;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class TextAlignerGrammar
extends Grammar
implements ResultListener {
    @S4Component(type=LogMath.class)
    public static final String PROP_LOG_MATH = "logMath";
    protected GrammarNode finalNode;
    private LogMath logMath;
    private final List<String> tokens = new ArrayList<String>();
    private int start;
    private final int step = 40;

    public TextAlignerGrammar(String text, LogMath logMath, boolean showGrammar, boolean optimizeGrammar, boolean addSilenceWords, boolean addFillerWords, Dictionary dictionary) {
        super(showGrammar, optimizeGrammar, addSilenceWords, addFillerWords, dictionary);
        this.logMath = logMath;
        this.setText(text);
    }

    public TextAlignerGrammar() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.logMath = (LogMath)ps.getComponent(PROP_LOG_MATH);
    }

    public void setText(String text) {
        try {
            ExtendedStreamTokenizer tok = new ExtendedStreamTokenizer(new StringReader(text), true);
            this.tokens.clear();
            while (!tok.isEOF()) {
                String word;
                while ((word = tok.getString()) != null) {
                    word = word.toLowerCase();
                    this.tokens.add(word);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected GrammarNode createGrammar() {
        GrammarNode wordNode;
        this.initialNode = this.createGrammarNode("<sil>");
        this.finalNode = this.createGrammarNode("<sil>");
        this.finalNode.setFinalNode(true);
        GrammarNode branchNode = this.createGrammarNode(false);
        ArrayList<GrammarNode> wordGrammarNodes = new ArrayList<GrammarNode>();
        int end = this.start + 40 > this.tokens.size() ? this.tokens.size() : this.start + 40;
        for (String word : this.tokens.subList(this.start, end)) {
            wordNode = this.createGrammarNode(word);
            wordGrammarNodes.add(wordNode);
        }
        this.initialNode.add(branchNode, LogMath.getLogOne());
        float branchScore = this.logMath.linearToLog(1.0 / (double)wordGrammarNodes.size());
        for (int i = 0; i < wordGrammarNodes.size(); ++i) {
            wordNode = (GrammarNode)wordGrammarNodes.get(i);
            branchNode.add(wordNode, branchScore);
            wordNode.add(this.finalNode, LogMath.getLogOne());
            for (int j = i + 1; j < i + 2; ++j) {
                if (0 > j || j >= wordGrammarNodes.size()) continue;
                GrammarNode neighbour = (GrammarNode)wordGrammarNodes.get(j);
                wordNode.add(neighbour, LogMath.getLogOne());
            }
        }
        return this.initialNode;
    }

    @Override
    public void newResult(Result result) {
        if (result == null) {
            return;
        }
        int max = -1;
        block0: for (String word : result.toString().split(" ")) {
            for (int i = this.start; i < this.start + 40 && i < this.tokens.size(); ++i) {
                if (!this.tokens.get(i).equals(word)) continue;
                max = i;
                continue block0;
            }
        }
        if (max > 0) {
            this.start = max;
            this.newGrammar();
            this.createGrammar();
            this.postProcessGrammar();
        }
    }
}

